/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.recipes;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.proxy.CCTurtleProxyCommon;
import dan200.computercraft.shared.turtle.items.ITurtleItem;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class TurtleUpgradeRecipe
implements IRecipe {
    public int func_77570_a() {
        return 3;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return TurtleItemFactory.create(-1, null, -1, ComputerFamily.Normal, null, null, 0, null);
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inventory, @Nonnull World world) {
        return !this.func_77572_b(inventory).func_190926_b();
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inventory) {
        ItemStack leftItem = ItemStack.field_190927_a;
        ItemStack turtle = ItemStack.field_190927_a;
        ItemStack rightItem = ItemStack.field_190927_a;
        for (int y = 0; y < inventory.func_174923_h(); ++y) {
            if (turtle.func_190926_b()) {
                boolean finishedRow = false;
                for (int x = 0; x < inventory.func_174922_i(); ++x) {
                    ItemStack item = inventory.func_70463_b(x, y);
                    if (!item.func_190926_b()) {
                        if (finishedRow) {
                            return ItemStack.field_190927_a;
                        }
                        if (item.func_77973_b() instanceof ITurtleItem) {
                            if (turtle.func_190926_b()) {
                                turtle = item;
                                continue;
                            }
                            return ItemStack.field_190927_a;
                        }
                        if (turtle.func_190926_b() && leftItem.func_190926_b()) {
                            leftItem = item;
                            continue;
                        }
                        if (!turtle.func_190926_b() && rightItem.func_190926_b()) {
                            rightItem = item;
                            continue;
                        }
                        return ItemStack.field_190927_a;
                    }
                    if (leftItem.func_190926_b() && turtle.func_190926_b()) continue;
                    finishedRow = true;
                }
                if (!turtle.func_190926_b() || leftItem.func_190926_b() && rightItem.func_190926_b()) continue;
                return ItemStack.field_190927_a;
            }
            for (int x = 0; x < inventory.func_174922_i(); ++x) {
                ItemStack item = inventory.func_70463_b(x, y);
                if (item.func_190926_b()) continue;
                return ItemStack.field_190927_a;
            }
        }
        if (turtle.func_190926_b() || leftItem.func_190926_b() && rightItem.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ITurtleItem itemTurtle = (ITurtleItem)turtle.func_77973_b();
        ComputerFamily family = itemTurtle.getFamily(turtle);
        ITurtleUpgrade[] upgrades = new ITurtleUpgrade[]{itemTurtle.getUpgrade(turtle, TurtleSide.Left), itemTurtle.getUpgrade(turtle, TurtleSide.Right)};
        ItemStack[] items = new ItemStack[]{rightItem, leftItem};
        for (int i = 0; i < 2; ++i) {
            if (items[i].func_190926_b()) continue;
            ITurtleUpgrade itemUpgrade = ComputerCraft.getTurtleUpgrade(items[i]);
            if (itemUpgrade == null) {
                return ItemStack.field_190927_a;
            }
            if (upgrades[i] != null) {
                return ItemStack.field_190927_a;
            }
            if (!CCTurtleProxyCommon.isUpgradeSuitableForFamily(family, itemUpgrade)) {
                return ItemStack.field_190927_a;
            }
            upgrades[i] = itemUpgrade;
        }
        int computerID = itemTurtle.getComputerID(turtle);
        String label = itemTurtle.getLabel(turtle);
        int fuelLevel = itemTurtle.getFuelLevel(turtle);
        int colour = itemTurtle.getColour(turtle);
        ResourceLocation overlay = itemTurtle.getOverlay(turtle);
        return TurtleItemFactory.create(computerID, label, colour, family, upgrades[0], upgrades[1], fuelLevel, overlay);
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(@Nonnull InventoryCrafting inventoryCrafting) {
        NonNullList results = NonNullList.func_191197_a((int)inventoryCrafting.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < results.size(); ++i) {
            ItemStack stack = inventoryCrafting.func_70301_a(i);
            results.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)stack));
        }
        return results;
    }
}

