/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.recipes;

import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.items.IComputerItem;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class TurtleRecipe
implements IRecipe {
    private final Item[] m_recipe;
    private final ComputerFamily m_family;

    public TurtleRecipe(Item[] recipe, ComputerFamily family) {
        this.m_recipe = recipe;
        this.m_family = family;
    }

    public int func_77570_a() {
        return 9;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return TurtleItemFactory.create(-1, null, -1, this.m_family, null, null, 0, null);
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting _inventory, @Nonnull World world) {
        return !this.func_77572_b(_inventory).func_190926_b();
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inventory) {
        int computerID = -1;
        String label = null;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                ItemStack item = inventory.func_70463_b(x, y);
                if (!item.func_190926_b() && item.func_77973_b() == this.m_recipe[x + y * 3]) {
                    if (!(item.func_77973_b() instanceof IComputerItem)) continue;
                    IComputerItem itemComputer = (IComputerItem)item.func_77973_b();
                    if (this.m_family == ComputerFamily.Beginners || itemComputer.getFamily(item) == this.m_family) {
                        computerID = itemComputer.getComputerID(item);
                        label = itemComputer.getLabel(item);
                        continue;
                    }
                    return ItemStack.field_190927_a;
                }
                return ItemStack.field_190927_a;
            }
        }
        if (this.m_family != ComputerFamily.Beginners) {
            return TurtleItemFactory.create(computerID, label, -1, this.m_family, null, null, 0, null);
        }
        return TurtleItemFactory.create(-1, label, -1, this.m_family, null, null, 0, null);
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(@Nonnull InventoryCrafting inventoryCrafting) {
        NonNullList results = NonNullList.func_191197_a((int)inventoryCrafting.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < results.size(); ++i) {
            ItemStack stack = inventoryCrafting.func_70301_a(i);
            results.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)stack));
        }
        return results;
    }
}

