/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.items;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.items.ItemComputer;
import dan200.computercraft.shared.turtle.items.ItemTurtleBase;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class ItemTurtleLegacy
extends ItemTurtleBase {
    public ItemTurtleLegacy(Block block) {
        super(block);
        this.func_77655_b("computercraft:turtle");
        this.func_77637_a(ComputerCraft.mainCreativeTab);
    }

    @Override
    public ItemStack create(int id, String label, int colour, ITurtleUpgrade leftUpgrade, ITurtleUpgrade rightUpgrade, int fuelLevel, ResourceLocation overlay) {
        if (leftUpgrade != null && leftUpgrade != ComputerCraft.Upgrades.diamondPickaxe || rightUpgrade != null && rightUpgrade != ComputerCraft.Upgrades.wirelessModem || colour != -1 || overlay != null) {
            return null;
        }
        int subType = 0;
        if (leftUpgrade != null) {
            ++subType;
        }
        if (rightUpgrade != null) {
            subType += 2;
        }
        int damage = subType;
        if (id >= 0 && id <= ItemComputer.HIGHEST_DAMAGE_VALUE_ID) {
            damage += id + 1 << 2;
        }
        ItemStack stack = new ItemStack((Item)this, 1, damage);
        if (fuelLevel > 0 || id > ItemComputer.HIGHEST_DAMAGE_VALUE_ID) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (fuelLevel > 0) {
                nbt.func_74768_a("fuelLevel", fuelLevel);
            }
            if (id > ItemComputer.HIGHEST_DAMAGE_VALUE_ID) {
                nbt.func_74768_a("computerID", id);
            }
            stack.func_77982_d(nbt);
        }
        if (label != null) {
            stack.func_151001_c(label);
        }
        return stack;
    }

    @Override
    public int getComputerID(@Nonnull ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("computerID")) {
            return stack.func_77978_p().func_74762_e("computerID");
        }
        int damage = stack.func_77952_i();
        return ((damage & 0xFFFC) >> 2) - 1;
    }

    @Override
    public ComputerFamily getFamily(int damage) {
        return ComputerFamily.Normal;
    }

    @Override
    public ITurtleUpgrade getUpgrade(@Nonnull ItemStack stack, TurtleSide side) {
        int damage = stack.func_77952_i();
        switch (side) {
            case Left: {
                if ((damage & 1) <= 0) break;
                return ComputerCraft.Upgrades.diamondPickaxe;
            }
            case Right: {
                if ((damage & 2) <= 0) break;
                return ComputerCraft.Upgrades.wirelessModem;
            }
        }
        return null;
    }

    @Override
    public int getColour(@Nonnull ItemStack stack) {
        return -1;
    }

    @Override
    public ResourceLocation getOverlay(@Nonnull ItemStack stack) {
        return null;
    }

    @Override
    public int getFuelLevel(@Nonnull ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            return nbt.func_74762_e("fuelLevel");
        }
        return 0;
    }
}

