/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class TurtleSuckCommand
implements ITurtleCommand {
    private final InteractDirection m_direction;
    private final int m_quantity;

    public TurtleSuckCommand(InteractDirection direction, int quantity) {
        this.m_direction = direction;
        this.m_quantity = quantity;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        EnumFacing side;
        BlockPos oldPosition;
        BlockPos newPosition;
        if (this.m_quantity == 0) {
            turtle.playAnimation(TurtleAnimation.Wait);
            return TurtleCommandResult.success();
        }
        EnumFacing direction = this.m_direction.toWorldDir(turtle);
        World world = turtle.getWorld();
        IItemHandler inventory = InventoryUtil.getInventory(world, newPosition = WorldUtil.moveCoords(oldPosition = turtle.getPosition(), direction), side = direction.func_176734_d());
        if (inventory != null) {
            ItemStack stack = InventoryUtil.takeItems(this.m_quantity, inventory);
            if (!stack.func_190926_b()) {
                ItemStack remainder = InventoryUtil.storeItems(stack, (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot());
                if (!remainder.func_190926_b()) {
                    InventoryUtil.storeItems(remainder, inventory);
                }
                if (remainder != stack) {
                    turtle.playAnimation(TurtleAnimation.Wait);
                    return TurtleCommandResult.success();
                }
                return TurtleCommandResult.failure("No space for items");
            }
            return TurtleCommandResult.failure("No items to take");
        }
        AxisAlignedBB aabb = new AxisAlignedBB((double)newPosition.func_177958_n(), (double)newPosition.func_177956_o(), (double)newPosition.func_177952_p(), (double)newPosition.func_177958_n() + 1.0, (double)newPosition.func_177956_o() + 1.0, (double)newPosition.func_177952_p() + 1.0);
        List list = world.func_72839_b(null, aabb);
        if (list.size() > 0) {
            boolean foundItems = false;
            boolean storedItems = false;
            for (Entity entity : list) {
                ItemStack remainder;
                ItemStack leaveStack;
                ItemStack storeStack;
                if (entity == null || !(entity instanceof EntityItem) || entity.field_70128_L) continue;
                foundItems = true;
                EntityItem entityItem = (EntityItem)entity;
                ItemStack stack = entityItem.func_92059_d().func_77946_l();
                if (stack.func_190916_E() > this.m_quantity) {
                    storeStack = stack.func_77979_a(this.m_quantity);
                    leaveStack = stack;
                } else {
                    storeStack = stack;
                    leaveStack = ItemStack.field_190927_a;
                }
                if ((remainder = InventoryUtil.storeItems(storeStack, (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot())) == storeStack) continue;
                storedItems = true;
                if (remainder.func_190926_b() && leaveStack.func_190926_b()) {
                    entityItem.func_70106_y();
                    break;
                }
                if (remainder.func_190926_b()) {
                    entityItem.func_92058_a(leaveStack);
                    break;
                }
                if (leaveStack.func_190926_b()) {
                    entityItem.func_92058_a(remainder);
                    break;
                }
                leaveStack.func_190917_f(remainder.func_190916_E());
                entityItem.func_92058_a(leaveStack);
                break;
            }
            if (foundItems) {
                if (storedItems) {
                    world.func_175669_a(1000, oldPosition, 0);
                    turtle.playAnimation(TurtleAnimation.Wait);
                    return TurtleCommandResult.success();
                }
                return TurtleCommandResult.failure("No space for items");
            }
        }
        return TurtleCommandResult.failure("No items to take");
    }
}

