/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.IEntityDropConsumer;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBoat;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemGlassBottle;
import net.minecraft.item.ItemLilyPad;
import net.minecraft.item.ItemSign;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class TurtlePlaceCommand
implements ITurtleCommand {
    private final InteractDirection m_direction;
    private final Object[] m_extraArguments;

    public TurtlePlaceCommand(InteractDirection direction, Object[] arguments) {
        this.m_direction = direction;
        this.m_extraArguments = arguments;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        BlockPos coordinates;
        ItemStack stack = turtle.getInventory().func_70301_a(turtle.getSelectedSlot());
        if (stack.func_190926_b()) {
            return TurtleCommandResult.failure("No items to place");
        }
        EnumFacing direction = this.m_direction.toWorldDir(turtle);
        World world = turtle.getWorld();
        IBlockState previousState = WorldUtil.isBlockInWorld(world, coordinates = WorldUtil.moveCoords(turtle.getPosition(), direction)) ? world.func_180495_p(coordinates) : null;
        String[] errorMessage = new String[1];
        ItemStack remainder = TurtlePlaceCommand.deploy(stack, turtle, direction, this.m_extraArguments, errorMessage);
        if (remainder != stack) {
            turtle.getInventory().func_70299_a(turtle.getSelectedSlot(), remainder);
            turtle.getInventory().func_70296_d();
            if (turtle instanceof TurtleBrain && previousState != null) {
                TurtleBrain brain = (TurtleBrain)turtle;
                brain.saveBlockChange(coordinates, previousState);
            }
            turtle.playAnimation(TurtleAnimation.Wait);
            return TurtleCommandResult.success();
        }
        if (errorMessage[0] != null) {
            return TurtleCommandResult.failure(errorMessage[0]);
        }
        if (stack.func_77973_b() instanceof ItemBlock) {
            return TurtleCommandResult.failure("Cannot place block here");
        }
        return TurtleCommandResult.failure("Cannot place item here");
    }

    public static ItemStack deploy(@Nonnull ItemStack stack, ITurtleAccess turtle, EnumFacing direction, Object[] extraArguments, String[] o_errorMessage) {
        BlockPos playerPosition = WorldUtil.moveCoords(turtle.getPosition(), direction);
        TurtlePlayer turtlePlayer = TurtlePlaceCommand.createPlayer(turtle, playerPosition, direction);
        ItemStack remainder = TurtlePlaceCommand.deployOnEntity(stack, turtle, turtlePlayer, direction, extraArguments, o_errorMessage);
        if (remainder != stack) {
            return remainder;
        }
        BlockPos position = turtle.getPosition();
        BlockPos newPosition = WorldUtil.moveCoords(position, direction);
        remainder = TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, newPosition, direction.func_176734_d(), extraArguments, true, o_errorMessage);
        if (remainder != stack) {
            return remainder;
        }
        remainder = TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, WorldUtil.moveCoords(newPosition, direction), direction.func_176734_d(), extraArguments, false, o_errorMessage);
        if (remainder != stack) {
            return remainder;
        }
        if (direction.func_176740_k() != EnumFacing.Axis.Y && (remainder = TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, newPosition.func_177977_b(), EnumFacing.UP, extraArguments, false, o_errorMessage)) != stack) {
            return remainder;
        }
        remainder = TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, position, direction, extraArguments, false, o_errorMessage);
        if (remainder != stack) {
            return remainder;
        }
        return stack;
    }

    public static TurtlePlayer createPlayer(ITurtleAccess turtle, BlockPos position, EnumFacing direction) {
        TurtlePlayer turtlePlayer = new TurtlePlayer((WorldServer)turtle.getWorld());
        TurtlePlaceCommand.orientPlayer(turtle, turtlePlayer, position, direction);
        return turtlePlayer;
    }

    public static void orientPlayer(ITurtleAccess turtle, TurtlePlayer turtlePlayer, BlockPos position, EnumFacing direction) {
        turtlePlayer.field_70165_t = (double)position.func_177958_n() + 0.5;
        turtlePlayer.field_70163_u = (double)position.func_177956_o() + 0.5;
        turtlePlayer.field_70161_v = (double)position.func_177952_p() + 0.5;
        if (turtle.getPosition().equals((Object)position)) {
            turtlePlayer.field_70165_t += 0.48 * (double)direction.func_82601_c();
            turtlePlayer.field_70163_u += 0.48 * (double)direction.func_96559_d();
            turtlePlayer.field_70161_v += 0.48 * (double)direction.func_82599_e();
        }
        if (direction.func_176740_k() != EnumFacing.Axis.Y) {
            turtlePlayer.field_70177_z = DirectionUtil.toYawAngle(direction);
            turtlePlayer.field_70125_A = 0.0f;
        } else {
            turtlePlayer.field_70177_z = DirectionUtil.toYawAngle(turtle.getDirection());
            turtlePlayer.field_70125_A = DirectionUtil.toPitchAngle(direction);
        }
        turtlePlayer.field_70169_q = turtlePlayer.field_70165_t;
        turtlePlayer.field_70167_r = turtlePlayer.field_70163_u;
        turtlePlayer.field_70166_s = turtlePlayer.field_70161_v;
        turtlePlayer.field_70127_C = turtlePlayer.field_70125_A;
        turtlePlayer.field_70126_B = turtlePlayer.field_70177_z;
        turtlePlayer.field_70758_at = turtlePlayer.field_70759_as = turtlePlayer.field_70177_z;
    }

    @Nonnull
    private static ItemStack deployOnEntity(@Nonnull ItemStack stack, final ITurtleAccess turtle, TurtlePlayer turtlePlayer, EnumFacing direction, Object[] extraArguments, String[] o_errorMessage) {
        final World world = turtle.getWorld();
        final BlockPos position = turtle.getPosition();
        Vec3d turtlePos = new Vec3d(turtlePlayer.field_70165_t, turtlePlayer.field_70163_u, turtlePlayer.field_70161_v);
        Vec3d rayDir = turtlePlayer.func_70676_i(1.0f);
        Pair<Entity, Vec3d> hit = WorldUtil.rayTraceEntities(world, turtlePos, rayDir, 1.5);
        if (hit == null) {
            return stack;
        }
        ItemStack stackCopy = stack.func_77946_l();
        turtlePlayer.loadInventory(stackCopy);
        Entity hitEntity = (Entity)hit.getKey();
        Vec3d hitPos = (Vec3d)hit.getValue();
        ComputerCraft.setEntityDropConsumer(hitEntity, new IEntityDropConsumer(){

            @Override
            public void consumeDrop(Entity entity, @Nonnull ItemStack drop) {
                ItemStack remainder = InventoryUtil.storeItems(drop, (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot());
                if (!remainder.func_190926_b()) {
                    WorldUtil.dropItemStack(remainder, world, position, turtle.getDirection().func_176734_d());
                }
            }
        });
        boolean placed = false;
        EnumActionResult cancelResult = ForgeHooks.onInteractEntityAtAction((EntityPlayer)turtlePlayer, (Entity)hitEntity, (Vec3d)hitPos, (EnumHand)EnumHand.MAIN_HAND);
        if (cancelResult == null) {
            cancelResult = hitEntity.func_184199_a((EntityPlayer)turtlePlayer, hitPos, EnumHand.MAIN_HAND);
        }
        if (cancelResult == EnumActionResult.SUCCESS) {
            placed = true;
        } else {
            cancelResult = ForgeHooks.onInteractEntityAction((EntityPlayer)turtlePlayer, (Entity)hitEntity, (EnumHand)EnumHand.MAIN_HAND);
            if (cancelResult == EnumActionResult.SUCCESS) {
                placed = true;
            } else if (cancelResult == null) {
                if (hitEntity.func_184230_a((EntityPlayer)turtlePlayer, EnumHand.MAIN_HAND)) {
                    placed = true;
                } else if (hitEntity instanceof EntityLivingBase && (placed = stackCopy.func_111282_a((EntityPlayer)turtlePlayer, (EntityLivingBase)hitEntity, EnumHand.MAIN_HAND))) {
                    turtlePlayer.loadInventory(stackCopy);
                }
            }
        }
        ComputerCraft.clearEntityDropConsumer(hitEntity);
        ItemStack remainder = turtlePlayer.unloadInventory(turtle);
        if (!placed && ItemStack.func_77989_b((ItemStack)stack, (ItemStack)remainder)) {
            return stack;
        }
        if (!remainder.func_190926_b()) {
            return remainder;
        }
        return ItemStack.field_190927_a;
    }

    private static boolean canDeployOnBlock(@Nonnull ItemStack stack, ITurtleAccess turtle, TurtlePlayer player, BlockPos position, EnumFacing side, boolean allowReplaceable, String[] o_errorMessage) {
        World world = turtle.getWorld();
        if (!(!WorldUtil.isBlockInWorld(world, position) || world.func_175623_d(position) || stack.func_77973_b() instanceof ItemBlock && WorldUtil.isLiquidBlock(world, position))) {
            Block block = world.func_180495_p(position).func_177230_c();
            IBlockState state = world.func_180495_p(position);
            boolean replaceable = block.func_176200_f((IBlockAccess)world, position);
            if (allowReplaceable || !replaceable) {
                if (ComputerCraft.turtlesObeyBlockProtection) {
                    boolean editable = true;
                    if (replaceable) {
                        editable = ComputerCraft.isBlockEditable(world, position, (EntityPlayer)player);
                    } else {
                        BlockPos shiftedPos = WorldUtil.moveCoords(position, side);
                        if (WorldUtil.isBlockInWorld(world, shiftedPos)) {
                            editable = ComputerCraft.isBlockEditable(world, shiftedPos, (EntityPlayer)player);
                        }
                    }
                    if (!editable) {
                        if (o_errorMessage != null) {
                            o_errorMessage[0] = "Cannot place in protected area";
                        }
                        return false;
                    }
                }
                if (block.func_176209_a(state, true)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Nonnull
    private static ItemStack deployOnBlock(@Nonnull ItemStack stack, ITurtleAccess turtle, TurtlePlayer turtlePlayer, BlockPos position, EnumFacing side, Object[] extraArguments, boolean allowReplace, String[] o_errorMessage) {
        if (!TurtlePlaceCommand.canDeployOnBlock(stack, turtle, turtlePlayer, position, side, allowReplace, o_errorMessage)) {
            return stack;
        }
        EnumFacing playerDir = side.func_176734_d();
        BlockPos playerPosition = WorldUtil.moveCoords(position, side);
        TurtlePlaceCommand.orientPlayer(turtle, turtlePlayer, playerPosition, playerDir);
        float hitX = 0.5f + (float)side.func_82601_c() * 0.5f;
        float hitY = 0.5f + (float)side.func_96559_d() * 0.5f;
        float hitZ = 0.5f + (float)side.func_82599_e() * 0.5f;
        if (Math.abs(hitY - 0.5f) < 0.01f) {
            hitY = 0.45f;
        }
        Item item = stack.func_77973_b();
        ItemStack stackCopy = stack.func_77946_l();
        turtlePlayer.loadInventory(stackCopy);
        boolean placed = false;
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((EntityPlayer)turtlePlayer, (EnumHand)EnumHand.MAIN_HAND, (BlockPos)position, (EnumFacing)side, (Vec3d)new Vec3d((double)hitX, (double)hitY, (double)hitZ));
        if (!event.isCanceled()) {
            if (item.onItemUseFirst((EntityPlayer)turtlePlayer, turtle.getWorld(), position, side, hitX, hitY, hitZ, EnumHand.MAIN_HAND) == EnumActionResult.SUCCESS) {
                placed = true;
                turtlePlayer.loadInventory(stackCopy);
            } else if (event.getUseItem() != Event.Result.DENY && stackCopy.func_179546_a((EntityPlayer)turtlePlayer, turtle.getWorld(), position, EnumHand.MAIN_HAND, side, hitX, hitY, hitZ) == EnumActionResult.SUCCESS) {
                placed = true;
                turtlePlayer.loadInventory(stackCopy);
            }
        }
        if (!placed && (item instanceof ItemBucket || item instanceof ItemBoat || item instanceof ItemLilyPad || item instanceof ItemGlassBottle)) {
            ActionResult result;
            EnumActionResult actionResult = ForgeHooks.onItemRightClickAction((EntityPlayer)turtlePlayer, (EnumHand)EnumHand.MAIN_HAND);
            if (actionResult == EnumActionResult.SUCCESS) {
                placed = true;
            } else if (actionResult == null && (result = stackCopy.func_77957_a(turtle.getWorld(), (EntityPlayer)turtlePlayer, EnumHand.MAIN_HAND)).func_188397_a() == EnumActionResult.SUCCESS && !ItemStack.func_77989_b((ItemStack)stack, (ItemStack)((ItemStack)result.func_188398_b()))) {
                placed = true;
                turtlePlayer.loadInventory((ItemStack)result.func_188398_b());
            }
        }
        if (placed && item instanceof ItemSign && extraArguments != null && extraArguments.length >= 1 && extraArguments[0] instanceof String) {
            World world = turtle.getWorld();
            TileEntity tile = world.func_175625_s(position);
            if (tile == null) {
                BlockPos newPosition = WorldUtil.moveCoords(position, side);
                tile = world.func_175625_s(newPosition);
            }
            if (tile != null && tile instanceof TileEntitySign) {
                TileEntitySign signTile = (TileEntitySign)tile;
                String s = (String)extraArguments[0];
                String[] split = s.split("\n");
                int firstLine = split.length <= 2 ? 1 : 0;
                for (int i = 0; i < signTile.field_145915_a.length; ++i) {
                    if (i >= firstLine && i < firstLine + split.length) {
                        if (split[i - firstLine].length() > 15) {
                            signTile.field_145915_a[i] = new TextComponentString(split[i - firstLine].substring(0, 15));
                            continue;
                        }
                        signTile.field_145915_a[i] = new TextComponentString(split[i - firstLine]);
                        continue;
                    }
                    signTile.field_145915_a[i] = new TextComponentString("");
                }
                signTile.func_70296_d();
                world.func_175704_b(signTile.func_174877_v(), signTile.func_174877_v());
            }
        }
        ItemStack remainder = turtlePlayer.unloadInventory(turtle);
        if (!placed && ItemStack.func_77989_b((ItemStack)stack, (ItemStack)remainder)) {
            return stack;
        }
        if (!remainder.func_190926_b()) {
            return remainder;
        }
        return ItemStack.field_190927_a;
    }
}

