/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class TurtleDropCommand
implements ITurtleCommand {
    private final InteractDirection m_direction;
    private final int m_quantity;

    public TurtleDropCommand(InteractDirection direction, int quantity) {
        this.m_direction = direction;
        this.m_quantity = quantity;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        EnumFacing side;
        BlockPos oldPosition;
        BlockPos newPosition;
        if (this.m_quantity == 0) {
            turtle.playAnimation(TurtleAnimation.Wait);
            return TurtleCommandResult.success();
        }
        EnumFacing direction = this.m_direction.toWorldDir(turtle);
        ItemStack stack = InventoryUtil.takeItems(this.m_quantity, (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot(), 1, turtle.getSelectedSlot());
        if (stack.func_190926_b()) {
            return TurtleCommandResult.failure("No items to drop");
        }
        World world = turtle.getWorld();
        IItemHandler inventory = InventoryUtil.getInventory(world, newPosition = (oldPosition = turtle.getPosition()).func_177972_a(direction), side = direction.func_176734_d());
        if (inventory != null) {
            ItemStack remainder = InventoryUtil.storeItems(stack, inventory);
            if (!remainder.func_190926_b()) {
                InventoryUtil.storeItems(remainder, (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot());
            }
            if (remainder != stack) {
                turtle.playAnimation(TurtleAnimation.Wait);
                return TurtleCommandResult.success();
            }
            return TurtleCommandResult.failure("No space for items");
        }
        WorldUtil.dropItemStack(stack, world, oldPosition, direction);
        world.func_175669_a(1000, newPosition, 0);
        turtle.playAnimation(TurtleAnimation.Wait);
        return TurtleCommandResult.success();
    }
}

