/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import com.google.common.base.Objects;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.computer.blocks.BlockComputerBase;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.core.TurtleCommandQueueEntry;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.ColourUtils;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.Holiday;
import dan200.computercraft.shared.util.HolidayUtil;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TurtleBrain
implements ITurtleAccess {
    private static int s_nextInstanceID = 0;
    private static Map<Integer, WeakReference<TurtleBrain>> s_allClientBrains = new HashMap<Integer, WeakReference<TurtleBrain>>();
    private static final int ANIM_DURATION = 8;
    private TileTurtle m_owner;
    private LinkedList<TurtleCommandQueueEntry> m_commandQueue;
    private int m_commandsIssued;
    private Map<TurtleSide, ITurtleUpgrade> m_upgrades;
    private Map<TurtleSide, IPeripheral> m_peripherals;
    private Map<TurtleSide, NBTTagCompound> m_upgradeNBTData;
    private int m_selectedSlot;
    private int m_fuelLevel;
    private int m_colourHex;
    private ResourceLocation m_overlay;
    private int m_instanceID;
    private EnumFacing m_direction;
    private TurtleAnimation m_animation;
    private int m_animationProgress;
    private int m_lastAnimationProgress;

    public static int assignInstanceID() {
        return s_nextInstanceID++;
    }

    public static TurtleBrain getClientBrain(int instanceID) {
        WeakReference<TurtleBrain> ref;
        if (instanceID >= 0 && (ref = s_allClientBrains.get(instanceID)) != null) {
            TurtleBrain brain = (TurtleBrain)ref.get();
            if (brain != null) {
                return brain;
            }
            s_allClientBrains.remove(instanceID);
        }
        return null;
    }

    public static void setClientBrain(int instanceID, TurtleBrain brain) {
        if (instanceID >= 0 && TurtleBrain.getClientBrain(instanceID) != brain) {
            s_allClientBrains.put(instanceID, new WeakReference<TurtleBrain>(brain));
        }
    }

    public static void cleanupBrains() {
        if (s_allClientBrains.size() > 0) {
            Iterator<Map.Entry<Integer, WeakReference<TurtleBrain>>> it = s_allClientBrains.entrySet().iterator();
            while (it.hasNext()) {
                TurtleBrain brain;
                Map.Entry<Integer, WeakReference<TurtleBrain>> entry = it.next();
                WeakReference<TurtleBrain> ref = entry.getValue();
                if (ref == null || (brain = (TurtleBrain)ref.get()) != null) continue;
                it.remove();
            }
        }
    }

    public TurtleBrain(TileTurtle turtle) {
        this.m_owner = turtle;
        this.m_commandQueue = new LinkedList();
        this.m_commandsIssued = 0;
        this.m_upgrades = new HashMap<TurtleSide, ITurtleUpgrade>();
        this.m_peripherals = new HashMap<TurtleSide, IPeripheral>();
        this.m_upgradeNBTData = new HashMap<TurtleSide, NBTTagCompound>();
        this.m_selectedSlot = 0;
        this.m_fuelLevel = 0;
        this.m_colourHex = -1;
        this.m_overlay = null;
        this.m_instanceID = -1;
        this.m_direction = EnumFacing.NORTH;
        this.m_animation = TurtleAnimation.None;
        this.m_animationProgress = 0;
        this.m_lastAnimationProgress = 0;
    }

    public TurtleBrain getFutureSelf() {
        TurtleBrain futureSelf;
        if (this.getOwner().func_145831_w().field_72995_K && (futureSelf = TurtleBrain.getClientBrain(this.m_instanceID)) != null) {
            return futureSelf;
        }
        return this;
    }

    public void setOwner(TileTurtle owner) {
        this.m_owner = owner;
    }

    public TileTurtle getOwner() {
        return this.m_owner;
    }

    public ComputerFamily getFamily() {
        return this.m_owner.getFamily();
    }

    public void setupComputer(ServerComputer computer) {
        this.updatePeripherals(computer);
    }

    public void update() {
        World world = this.getWorld();
        if (!world.field_72995_K) {
            this.updateCommands();
        }
        this.updateAnimation();
        if (!this.m_upgrades.isEmpty()) {
            for (Map.Entry<TurtleSide, ITurtleUpgrade> entry : this.m_upgrades.entrySet()) {
                entry.getValue().update(this, entry.getKey());
            }
        }
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.m_direction = EnumFacing.func_82600_a((int)nbttagcompound.func_74762_e("dir"));
        this.m_selectedSlot = nbttagcompound.func_74762_e("selectedSlot");
        this.m_fuelLevel = nbttagcompound.func_74764_b("fuelLevel") ? nbttagcompound.func_74762_e("fuelLevel") : 0;
        this.m_colourHex = ColourUtils.getHexColour(nbttagcompound);
        if (nbttagcompound.func_74764_b("overlay_mod")) {
            String overlay_mod = nbttagcompound.func_74779_i("overlay_mod");
            if (nbttagcompound.func_74764_b("overlay_path")) {
                String overlay_path = nbttagcompound.func_74779_i("overlay_path");
                this.m_overlay = new ResourceLocation(overlay_mod, overlay_path);
            } else {
                this.m_overlay = null;
            }
        } else {
            this.m_overlay = null;
        }
        ITurtleUpgrade leftUpgrade = null;
        ITurtleUpgrade rightUpgrade = null;
        if (nbttagcompound.func_74764_b("subType")) {
            int subType = nbttagcompound.func_74762_e("subType");
            if ((subType & 1) > 0) {
                leftUpgrade = ComputerCraft.Upgrades.diamondPickaxe;
            }
            if ((subType & 2) > 0) {
                rightUpgrade = ComputerCraft.Upgrades.wirelessModem;
            }
        } else {
            if (nbttagcompound.func_74764_b("leftUpgrade")) {
                leftUpgrade = nbttagcompound.func_150299_b("leftUpgrade") == 8 ? ComputerCraft.getTurtleUpgrade(nbttagcompound.func_74779_i("leftUpgrade")) : ComputerCraft.getTurtleUpgrade(nbttagcompound.func_74765_d("leftUpgrade"));
            }
            if (nbttagcompound.func_74764_b("rightUpgrade")) {
                rightUpgrade = nbttagcompound.func_150299_b("rightUpgrade") == 8 ? ComputerCraft.getTurtleUpgrade(nbttagcompound.func_74779_i("rightUpgrade")) : ComputerCraft.getTurtleUpgrade(nbttagcompound.func_74765_d("rightUpgrade"));
            }
        }
        this.setUpgrade(TurtleSide.Left, leftUpgrade);
        this.setUpgrade(TurtleSide.Right, rightUpgrade);
        this.m_upgradeNBTData.clear();
        if (nbttagcompound.func_74764_b("leftUpgradeNBT")) {
            this.m_upgradeNBTData.put(TurtleSide.Left, nbttagcompound.func_74775_l("leftUpgradeNBT").func_74737_b());
        }
        if (nbttagcompound.func_74764_b("rightUpgradeNBT")) {
            this.m_upgradeNBTData.put(TurtleSide.Right, nbttagcompound.func_74775_l("rightUpgradeNBT").func_74737_b());
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        String rightUpgradeID;
        nbttagcompound.func_74768_a("dir", this.m_direction.func_176745_a());
        nbttagcompound.func_74768_a("selectedSlot", this.m_selectedSlot);
        nbttagcompound.func_74768_a("fuelLevel", this.m_fuelLevel);
        String leftUpgradeID = this.getUpgradeID(this.getUpgrade(TurtleSide.Left));
        if (leftUpgradeID != null) {
            nbttagcompound.func_74778_a("leftUpgrade", leftUpgradeID);
        }
        if ((rightUpgradeID = this.getUpgradeID(this.getUpgrade(TurtleSide.Right))) != null) {
            nbttagcompound.func_74778_a("rightUpgrade", rightUpgradeID);
        }
        if (this.m_colourHex != -1) {
            nbttagcompound.func_74768_a("colour", this.m_colourHex);
        }
        if (this.m_overlay != null) {
            nbttagcompound.func_74778_a("overlay_mod", this.m_overlay.func_110624_b());
            nbttagcompound.func_74778_a("overlay_path", this.m_overlay.func_110623_a());
        }
        if (this.m_upgradeNBTData.containsKey((Object)TurtleSide.Left)) {
            nbttagcompound.func_74782_a("leftUpgradeNBT", (NBTBase)this.getUpgradeNBTData(TurtleSide.Left).func_74737_b());
        }
        if (this.m_upgradeNBTData.containsKey((Object)TurtleSide.Right)) {
            nbttagcompound.func_74782_a("rightUpgradeNBT", (NBTBase)this.getUpgradeNBTData(TurtleSide.Right).func_74737_b());
        }
        return nbttagcompound;
    }

    private String getUpgradeID(ITurtleUpgrade upgrade) {
        if (upgrade != null) {
            return upgrade.getUpgradeID().toString();
        }
        return null;
    }

    public void writeDescription(NBTTagCompound nbttagcompound) {
        String rightUpgradeID;
        String leftUpgradeID = this.getUpgradeID(this.getUpgrade(TurtleSide.Left));
        if (leftUpgradeID != null) {
            nbttagcompound.func_74778_a("leftUpgrade", leftUpgradeID);
        }
        if ((rightUpgradeID = this.getUpgradeID(this.getUpgrade(TurtleSide.Right))) != null) {
            nbttagcompound.func_74778_a("rightUpgrade", rightUpgradeID);
        }
        if (this.m_upgradeNBTData.containsKey((Object)TurtleSide.Left)) {
            nbttagcompound.func_74782_a("leftUpgradeNBT", (NBTBase)this.getUpgradeNBTData(TurtleSide.Left).func_74737_b());
        }
        if (this.m_upgradeNBTData.containsKey((Object)TurtleSide.Right)) {
            nbttagcompound.func_74782_a("rightUpgradeNBT", (NBTBase)this.getUpgradeNBTData(TurtleSide.Right).func_74737_b());
        }
        if (this.m_colourHex != -1) {
            nbttagcompound.func_74768_a("colour", this.m_colourHex);
        }
        if (this.m_overlay != null) {
            nbttagcompound.func_74778_a("overlay_mod", this.m_overlay.func_110624_b());
            nbttagcompound.func_74778_a("overlay_path", this.m_overlay.func_110623_a());
        }
        if (this.m_instanceID < 0) {
            this.m_instanceID = TurtleBrain.assignInstanceID();
        }
        nbttagcompound.func_74768_a("brainInstanceID", this.m_instanceID);
        nbttagcompound.func_74768_a("animation", this.m_animation.ordinal());
        nbttagcompound.func_74768_a("direction", this.m_direction.func_176745_a());
        nbttagcompound.func_74768_a("fuelLevel", this.m_fuelLevel);
    }

    public void readDescription(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.func_74764_b("leftUpgrade")) {
            this.setUpgrade(TurtleSide.Left, ComputerCraft.getTurtleUpgrade(nbttagcompound.func_74779_i("leftUpgrade")));
        } else {
            this.setUpgrade(TurtleSide.Left, null);
        }
        if (nbttagcompound.func_74764_b("rightUpgrade")) {
            this.setUpgrade(TurtleSide.Right, ComputerCraft.getTurtleUpgrade(nbttagcompound.func_74779_i("rightUpgrade")));
        } else {
            this.setUpgrade(TurtleSide.Right, null);
        }
        this.m_upgradeNBTData.clear();
        if (nbttagcompound.func_74764_b("leftUpgradeNBT")) {
            this.m_upgradeNBTData.put(TurtleSide.Left, nbttagcompound.func_74775_l("leftUpgradeNBT").func_74737_b());
        }
        if (nbttagcompound.func_74764_b("rightUpgradeNBT")) {
            this.m_upgradeNBTData.put(TurtleSide.Right, nbttagcompound.func_74775_l("rightUpgradeNBT").func_74737_b());
        }
        this.m_colourHex = ColourUtils.getHexColour(nbttagcompound);
        if (nbttagcompound.func_74764_b("overlay_mod") && nbttagcompound.func_74764_b("overlay_path")) {
            String overlay_mod = nbttagcompound.func_74779_i("overlay_mod");
            String overlay_path = nbttagcompound.func_74779_i("overlay_path");
            this.m_overlay = new ResourceLocation(overlay_mod, overlay_path);
        } else {
            this.m_overlay = null;
        }
        this.m_instanceID = nbttagcompound.func_74762_e("brainInstanceID");
        TurtleBrain.setClientBrain(this.m_instanceID, this);
        TurtleAnimation anim = TurtleAnimation.values()[nbttagcompound.func_74762_e("animation")];
        if (anim != this.m_animation && anim != TurtleAnimation.Wait && anim != TurtleAnimation.ShortWait && anim != TurtleAnimation.None) {
            this.m_animation = TurtleAnimation.values()[nbttagcompound.func_74762_e("animation")];
            this.m_animationProgress = 0;
            this.m_lastAnimationProgress = 0;
        }
        this.m_direction = EnumFacing.func_82600_a((int)nbttagcompound.func_74762_e("direction"));
        this.m_fuelLevel = nbttagcompound.func_74762_e("fuelLevel");
    }

    @Override
    @Nonnull
    public World getWorld() {
        return this.m_owner.func_145831_w();
    }

    @Override
    @Nonnull
    public BlockPos getPosition() {
        return this.m_owner.func_174877_v();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean teleportTo(@Nonnull World world, @Nonnull BlockPos pos) {
        if (world.field_72995_K || this.getWorld().field_72995_K) {
            throw new UnsupportedOperationException();
        }
        World oldWorld = this.getWorld();
        TileTurtle oldOwner = this.m_owner;
        BlockPos oldPos = this.m_owner.func_174877_v();
        BlockComputerBase oldBlock = this.m_owner.getBlock();
        if (oldWorld == world && oldPos.equals((Object)pos)) {
            return true;
        }
        if (!world.func_175667_e(pos)) {
            return false;
        }
        oldOwner.notifyMoveStart();
        try {
            if (world.func_180501_a(pos, oldBlock.func_176223_P(), 0)) {
                TileEntity newTile;
                Block block = world.func_180495_p(pos).func_177230_c();
                if (block == oldBlock && (newTile = world.func_175625_s(pos)) != null && newTile instanceof TileTurtle) {
                    TileTurtle newTurtle = (TileTurtle)newTile;
                    newTurtle.func_145834_a(world);
                    newTurtle.func_174878_a(pos);
                    newTurtle.transferStateFrom(oldOwner);
                    newTurtle.createServerComputer().setWorld(world);
                    newTurtle.createServerComputer().setPosition(pos);
                    oldWorld.func_175698_g(oldPos);
                    newTurtle.updateBlock();
                    newTurtle.updateInput();
                    newTurtle.updateOutput();
                    boolean bl = true;
                    return bl;
                }
                world.func_175698_g(pos);
            }
        }
        finally {
            oldOwner.notifyMoveEnd();
        }
        return false;
    }

    @Override
    @Nonnull
    public Vec3d getVisualPosition(float f) {
        Vec3d offset = this.getRenderOffset(f);
        BlockPos pos = this.m_owner.func_174877_v();
        return new Vec3d((double)pos.func_177958_n() + 0.5 + offset.field_72450_a, (double)pos.func_177956_o() + 0.5 + offset.field_72448_b, (double)pos.func_177952_p() + 0.5 + offset.field_72449_c);
    }

    @Override
    public float getVisualYaw(float f) {
        float yaw = DirectionUtil.toYawAngle(this.getDirection());
        switch (this.m_animation) {
            case TurnLeft: {
                yaw += 90.0f * (1.0f - this.getAnimationFraction(f));
                if (!(yaw >= 360.0f)) break;
                yaw -= 360.0f;
                break;
            }
            case TurnRight: {
                yaw += -90.0f * (1.0f - this.getAnimationFraction(f));
                if (!(yaw < 0.0f)) break;
                yaw += 360.0f;
            }
        }
        return yaw;
    }

    @Override
    @Nonnull
    public EnumFacing getDirection() {
        return this.m_direction;
    }

    @Override
    public void setDirection(@Nonnull EnumFacing dir) {
        if (dir.func_176740_k() == EnumFacing.Axis.Y) {
            dir = EnumFacing.NORTH;
        }
        this.m_direction = dir;
        this.m_owner.updateOutput();
        this.m_owner.updateInput();
        this.m_owner.onTileEntityChange();
    }

    @Override
    public int getSelectedSlot() {
        return this.m_selectedSlot;
    }

    @Override
    public void setSelectedSlot(int slot) {
        if (this.getWorld().field_72995_K) {
            throw new UnsupportedOperationException();
        }
        if (slot >= 0 && slot < this.m_owner.func_70302_i_()) {
            this.m_selectedSlot = slot;
            this.m_owner.onTileEntityChange();
        }
    }

    @Override
    @Nonnull
    public IInventory getInventory() {
        return this.m_owner;
    }

    @Override
    @Nonnull
    public IItemHandlerModifiable getItemHandler() {
        return this.m_owner.getItemHandler();
    }

    @Override
    public boolean isFuelNeeded() {
        return ComputerCraft.turtlesNeedFuel;
    }

    @Override
    public int getFuelLevel() {
        return Math.min(this.m_fuelLevel, this.getFuelLimit());
    }

    @Override
    public void setFuelLevel(int level) {
        this.m_fuelLevel = Math.min(level, this.getFuelLimit());
        this.m_owner.onTileEntityChange();
    }

    @Override
    public int getFuelLimit() {
        if (this.m_owner.getFamily() == ComputerFamily.Advanced) {
            return ComputerCraft.advancedTurtleFuelLimit;
        }
        return ComputerCraft.turtleFuelLimit;
    }

    @Override
    public boolean consumeFuel(int fuel) {
        if (this.getWorld().field_72995_K) {
            throw new UnsupportedOperationException();
        }
        if (!this.isFuelNeeded()) {
            return true;
        }
        int consumption = Math.max(fuel, 0);
        if (this.getFuelLevel() >= consumption) {
            this.setFuelLevel(this.getFuelLevel() - consumption);
            return true;
        }
        return false;
    }

    @Override
    public void addFuel(int fuel) {
        if (this.getWorld().field_72995_K) {
            throw new UnsupportedOperationException();
        }
        int addition = Math.max(fuel, 0);
        this.setFuelLevel(this.getFuelLevel() + addition);
    }

    private int issueCommand(ITurtleCommand command) {
        this.m_commandQueue.offer(new TurtleCommandQueueEntry(++this.m_commandsIssued, command));
        return this.m_commandsIssued;
    }

    @Override
    @Nonnull
    public Object[] executeCommand(@Nonnull ILuaContext context, @Nonnull ITurtleCommand command) throws LuaException, InterruptedException {
        Object[] response;
        if (this.getWorld().field_72995_K) {
            throw new UnsupportedOperationException();
        }
        int commandID = this.issueCommand(command);
        while ((response = context.pullEvent("turtle_response")).length < 3 || !(response[1] instanceof Number) || !(response[2] instanceof Boolean) || ((Number)response[1]).intValue() != commandID) {
        }
        Object[] returnValues = new Object[response.length - 2];
        System.arraycopy(response, 2, returnValues, 0, returnValues.length);
        return returnValues;
    }

    @Override
    public void playAnimation(@Nonnull TurtleAnimation animation) {
        if (this.getWorld().field_72995_K) {
            throw new UnsupportedOperationException();
        }
        this.m_animation = animation;
        if (this.m_animation == TurtleAnimation.ShortWait) {
            this.m_animationProgress = 4;
            this.m_lastAnimationProgress = 4;
        } else {
            this.m_animationProgress = 0;
            this.m_lastAnimationProgress = 0;
        }
        this.m_owner.updateBlock();
    }

    public ResourceLocation getOverlay() {
        return this.m_overlay;
    }

    public void setOverlay(ResourceLocation overlay) {
        if (!Objects.equal((Object)this.m_overlay, (Object)overlay)) {
            this.m_overlay = overlay;
            this.m_owner.updateBlock();
        }
    }

    public int getDyeColour() {
        if (this.m_colourHex == -1) {
            return -1;
        }
        Colour colour = Colour.fromHex(this.m_colourHex);
        return colour == null ? -1 : colour.ordinal();
    }

    public void setDyeColour(int dyeColour) {
        int newColour = -1;
        if (dyeColour >= 0 && dyeColour < 16) {
            newColour = Colour.values()[dyeColour].getHex();
        }
        if (this.m_colourHex != newColour) {
            this.m_colourHex = newColour;
            this.m_owner.updateBlock();
        }
    }

    @Override
    public void setColour(int colour) {
        if (colour >= 0 && colour <= 0xFFFFFF) {
            if (this.m_colourHex != colour) {
                this.m_colourHex = colour;
                this.m_owner.updateBlock();
            }
        } else if (this.m_colourHex != -1) {
            this.m_colourHex = -1;
            this.m_owner.updateBlock();
        }
    }

    @Override
    public int getColour() {
        return this.m_colourHex;
    }

    @Override
    public ITurtleUpgrade getUpgrade(@Nonnull TurtleSide side) {
        if (this.m_upgrades.containsKey((Object)side)) {
            return this.m_upgrades.get((Object)side);
        }
        return null;
    }

    @Override
    public void setUpgrade(@Nonnull TurtleSide side, ITurtleUpgrade upgrade) {
        if (this.m_upgrades.containsKey((Object)side)) {
            if (this.m_upgrades.get((Object)side) == upgrade) {
                return;
            }
            this.m_upgrades.remove((Object)side);
        } else if (upgrade == null) {
            return;
        }
        if (this.m_upgradeNBTData.containsKey((Object)side)) {
            this.m_upgradeNBTData.remove((Object)side);
        }
        if (upgrade != null) {
            this.m_upgrades.put(side, upgrade);
        }
        if (this.m_owner.func_145831_w() != null) {
            this.updatePeripherals(this.m_owner.createServerComputer());
            this.m_owner.updateBlock();
        }
    }

    @Override
    public IPeripheral getPeripheral(@Nonnull TurtleSide side) {
        if (this.m_peripherals.containsKey((Object)side)) {
            return this.m_peripherals.get((Object)side);
        }
        return null;
    }

    @Override
    @Nonnull
    public NBTTagCompound getUpgradeNBTData(TurtleSide side) {
        if (!this.m_upgradeNBTData.containsKey((Object)side)) {
            this.m_upgradeNBTData.put(side, new NBTTagCompound());
        }
        return this.m_upgradeNBTData.get((Object)side);
    }

    @Override
    public void updateUpgradeNBTData(@Nonnull TurtleSide side) {
        this.m_owner.updateBlock();
    }

    public boolean saveBlockChange(BlockPos coordinates, IBlockState previousState) {
        return false;
    }

    public Vec3d getRenderOffset(float f) {
        switch (this.m_animation) {
            case MoveForward: 
            case MoveBack: 
            case MoveUp: 
            case MoveDown: {
                EnumFacing dir;
                switch (this.m_animation) {
                    default: {
                        dir = this.getDirection();
                        break;
                    }
                    case MoveBack: {
                        dir = this.getDirection().func_176734_d();
                        break;
                    }
                    case MoveUp: {
                        dir = EnumFacing.UP;
                        break;
                    }
                    case MoveDown: {
                        dir = EnumFacing.DOWN;
                    }
                }
                double distance = -1.0 + (double)this.getAnimationFraction(f);
                return new Vec3d(distance * (double)dir.func_82601_c(), distance * (double)dir.func_96559_d(), distance * (double)dir.func_82599_e());
            }
        }
        return new Vec3d(0.0, 0.0, 0.0);
    }

    public float getToolRenderAngle(TurtleSide side, float f) {
        if (side == TurtleSide.Left && this.m_animation == TurtleAnimation.SwingLeftTool || side == TurtleSide.Right && this.m_animation == TurtleAnimation.SwingRightTool) {
            return 45.0f * (float)Math.sin((double)this.getAnimationFraction(f) * Math.PI);
        }
        return 0.0f;
    }

    private int toDirection(TurtleSide side) {
        switch (side) {
            case Left: {
                return 5;
            }
        }
        return 4;
    }

    public void updatePeripherals(ServerComputer serverComputer) {
        if (serverComputer == null) {
            return;
        }
        for (TurtleSide side : TurtleSide.values()) {
            ITurtleUpgrade upgrade = this.getUpgrade(side);
            IPeripheral peripheral = null;
            if (upgrade != null && upgrade.getType().isPeripheral()) {
                peripheral = upgrade.createPeripheral(this, side);
            }
            int dir = this.toDirection(side);
            if (peripheral != null) {
                if (!this.m_peripherals.containsKey((Object)side)) {
                    serverComputer.setPeripheral(dir, peripheral);
                    this.m_peripherals.put(side, peripheral);
                    continue;
                }
                if (this.m_peripherals.get((Object)side).equals(peripheral)) continue;
                serverComputer.setPeripheral(dir, peripheral);
                this.m_peripherals.remove((Object)side);
                this.m_peripherals.put(side, peripheral);
                continue;
            }
            if (!this.m_peripherals.containsKey((Object)side)) continue;
            serverComputer.setPeripheral(dir, null);
            this.m_peripherals.remove((Object)side);
        }
    }

    private void updateCommands() {
        if (this.m_animation == TurtleAnimation.None) {
            TurtleCommandQueueEntry nextCommand = null;
            if (this.m_commandQueue.peek() != null) {
                nextCommand = this.m_commandQueue.remove();
            }
            if (nextCommand != null) {
                TurtleCommandResult result = nextCommand.command.execute(this);
                int callbackID = nextCommand.callbackID;
                if (callbackID >= 0) {
                    if (result != null && result.isSuccess()) {
                        IComputer computer = this.m_owner.getComputer();
                        if (computer != null) {
                            Object[] results = result.getResults();
                            if (results != null) {
                                Object[] arguments = new Object[results.length + 2];
                                arguments[0] = callbackID;
                                arguments[1] = true;
                                System.arraycopy(results, 0, arguments, 2, results.length);
                                computer.queueEvent("turtle_response", arguments);
                            } else {
                                computer.queueEvent("turtle_response", new Object[]{callbackID, true});
                            }
                        }
                    } else {
                        IComputer computer = this.m_owner.getComputer();
                        if (computer != null) {
                            computer.queueEvent("turtle_response", new Object[]{callbackID, false, result != null ? result.getErrorMessage() : null});
                        }
                    }
                }
            }
        }
    }

    private void updateAnimation() {
        if (this.m_animation != TurtleAnimation.None) {
            Vec3d position;
            Holiday currentHoliday;
            World world = this.getWorld();
            if (ComputerCraft.turtlesCanPush && (this.m_animation == TurtleAnimation.MoveForward || this.m_animation == TurtleAnimation.MoveBack || this.m_animation == TurtleAnimation.MoveUp || this.m_animation == TurtleAnimation.MoveDown)) {
                EnumFacing moveDir;
                BlockPos pos = this.getPosition();
                switch (this.m_animation) {
                    default: {
                        moveDir = this.m_direction;
                        break;
                    }
                    case MoveBack: {
                        moveDir = this.m_direction.func_176734_d();
                        break;
                    }
                    case MoveUp: {
                        moveDir = EnumFacing.UP;
                        break;
                    }
                    case MoveDown: {
                        moveDir = EnumFacing.DOWN;
                    }
                }
                double minX = pos.func_177958_n();
                double minY = pos.func_177956_o();
                double minZ = pos.func_177952_p();
                double maxX = minX + 1.0;
                double maxY = minY + 1.0;
                double maxZ = minZ + 1.0;
                float pushFrac = 1.0f - (float)(this.m_animationProgress + 1) / 8.0f;
                float push = Math.max(pushFrac + 0.0125f, 0.0f);
                if (moveDir.func_82601_c() < 0) {
                    minX += (double)((float)moveDir.func_82601_c() * push);
                } else {
                    maxX -= (double)((float)moveDir.func_82601_c() * push);
                }
                if (moveDir.func_96559_d() < 0) {
                    minY += (double)((float)moveDir.func_96559_d() * push);
                } else {
                    maxY -= (double)((float)moveDir.func_96559_d() * push);
                }
                if (moveDir.func_82599_e() < 0) {
                    minZ += (double)((float)moveDir.func_82599_e() * push);
                } else {
                    maxZ -= (double)((float)moveDir.func_82599_e() * push);
                }
                AxisAlignedBB aabb = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
                List list = world.func_72839_b(null, aabb);
                if (!list.isEmpty()) {
                    double pushStep = 0.125;
                    double pushStepX = (double)moveDir.func_82601_c() * pushStep;
                    double pushStepY = (double)moveDir.func_96559_d() * pushStep;
                    double pushStepZ = (double)moveDir.func_82599_e() * pushStep;
                    for (Entity entity : list) {
                        entity.func_70091_d(MoverType.PISTON, pushStepX, pushStepY, pushStepZ);
                    }
                }
            }
            if (world.field_72995_K && this.m_animation == TurtleAnimation.MoveForward && this.m_animationProgress == 4 && (currentHoliday = HolidayUtil.getCurrentHoliday()) == Holiday.Valentines && (position = this.getVisualPosition(1.0f)) != null) {
                double x = position.field_72450_a + world.field_73012_v.nextGaussian() * 0.1;
                double y = position.field_72448_b + 0.5 + world.field_73012_v.nextGaussian() * 0.1;
                double z = position.field_72449_c + world.field_73012_v.nextGaussian() * 0.1;
                world.func_175688_a(EnumParticleTypes.HEART, x, y, z, world.field_73012_v.nextGaussian() * 0.02, world.field_73012_v.nextGaussian() * 0.02, world.field_73012_v.nextGaussian() * 0.02, new int[0]);
            }
            this.m_lastAnimationProgress = this.m_animationProgress++;
            if (this.m_animationProgress >= 8) {
                this.m_animation = TurtleAnimation.None;
                this.m_animationProgress = 0;
                this.m_lastAnimationProgress = 0;
            }
        }
    }

    private float getAnimationFraction(float f) {
        float next = (float)this.m_animationProgress / 8.0f;
        float previous = (float)this.m_lastAnimationProgress / 8.0f;
        return previous + (next - previous) * f;
    }
}

