/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.blocks;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.computer.blocks.TileComputerBase;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.turtle.apis.TurtleAPI;
import dan200.computercraft.shared.turtle.blocks.ITurtleTile;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.RedstoneUtil;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileTurtle
extends TileComputerBase
implements ITurtleTile,
IInventory,
ITickable {
    public static final int INVENTORY_SIZE = 16;
    public static final int INVENTORY_WIDTH = 4;
    public static final int INVENTORY_HEIGHT = 4;
    private NonNullList<ItemStack> m_inventory;
    private NonNullList<ItemStack> m_previousInventory;
    private final IItemHandlerModifiable m_itemHandler = new InvWrapper((IInventory)this);
    private boolean m_inventoryChanged = false;
    private TurtleBrain m_brain;
    private MoveState m_moveState;

    public TileTurtle() {
        this.m_inventory = NonNullList.func_191197_a((int)16, (Object)ItemStack.field_190927_a);
        this.m_previousInventory = NonNullList.func_191197_a((int)16, (Object)ItemStack.field_190927_a);
        this.m_brain = this.createBrain();
        this.m_moveState = MoveState.NOT_MOVED;
    }

    public boolean hasMoved() {
        return this.m_moveState == MoveState.MOVED;
    }

    protected TurtleBrain createBrain() {
        return new TurtleBrain(this);
    }

    protected final ServerComputer createComputer(int instanceID, int id, int termWidth, int termHeight) {
        ServerComputer computer = new ServerComputer(this.func_145831_w(), id, this.m_label, instanceID, this.getFamily(), termWidth, termHeight);
        computer.setPosition(this.func_174877_v());
        computer.addAPI(new TurtleAPI(computer.getAPIEnvironment(), this.getAccess()));
        this.m_brain.setupComputer(computer);
        return computer;
    }

    @Override
    protected ServerComputer createComputer(int instanceID, int id) {
        return this.createComputer(instanceID, id, 39, 13);
    }

    @Override
    public void destroy() {
        block3: {
            block2: {
                if (this.hasMoved()) break block2;
                super.destroy();
                if (this.func_145831_w().field_72995_K) break block3;
                int size = this.func_70302_i_();
                for (int i = 0; i < size; ++i) {
                    ItemStack stack = this.func_70301_a(i);
                    if (stack.func_190926_b()) continue;
                    WorldUtil.dropItemStack(stack, this.func_145831_w(), this.func_174877_v());
                }
                break block3;
            }
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                RedstoneUtil.propogateRedstoneOutput(this.func_145831_w(), this.func_174877_v(), dir);
            }
        }
    }

    @Override
    protected void unload() {
        if (!this.hasMoved()) {
            super.unload();
        }
    }

    @Override
    public void getDroppedItems(@Nonnull List<ItemStack> drops, boolean creative) {
        IComputer computer = this.getComputer();
        if (!creative || computer != null && computer.getLabel() != null) {
            drops.add(TurtleItemFactory.create(this));
        }
    }

    @Override
    public ItemStack getPickedItem() {
        return TurtleItemFactory.create(this);
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.requestTileEntityUpdate();
        ItemStack currentItem = player.func_184586_b(EnumHand.MAIN_HAND);
        if (!currentItem.func_190926_b()) {
            if (currentItem.func_77973_b() == Items.field_151100_aR) {
                if (!this.func_145831_w().field_72995_K) {
                    int dye = currentItem.func_77952_i() & 0xF;
                    if (this.m_brain.getDyeColour() != dye) {
                        this.m_brain.setDyeColour(dye);
                        if (!player.field_71075_bZ.field_75098_d) {
                            currentItem.func_190918_g(1);
                        }
                    }
                }
                return true;
            }
            if (currentItem.func_77973_b() == Items.field_151131_as && this.m_brain.getColour() != -1) {
                if (!this.func_145831_w().field_72995_K && this.m_brain.getColour() != -1) {
                    this.m_brain.setColour(-1);
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151133_ar));
                        player.field_71071_by.func_70296_d();
                    }
                }
                return true;
            }
        }
        return super.onActivate(player, side, hitX, hitY, hitZ);
    }

    @Override
    protected boolean canNameWithTag(EntityPlayer player) {
        return true;
    }

    @Override
    public void openGUI(EntityPlayer player) {
        ComputerCraft.openTurtleGUI(player, this);
    }

    @Override
    public boolean isSolidOnSide(int side) {
        return false;
    }

    @Override
    public boolean isImmuneToExplosion(Entity exploder) {
        if (this.getFamily() == ComputerFamily.Advanced) {
            return true;
        }
        return exploder != null && (exploder instanceof EntityLivingBase || exploder instanceof EntityFireball);
    }

    @Override
    @Nonnull
    public AxisAlignedBB getBounds() {
        Vec3d offset = this.getRenderOffset(1.0f);
        return new AxisAlignedBB(offset.field_72450_a + 0.125, offset.field_72448_b + 0.125, offset.field_72449_c + 0.125, offset.field_72450_a + 0.875, offset.field_72448_b + 0.875, offset.field_72449_c + 0.875);
    }

    @Override
    protected double getInteractRange(EntityPlayer player) {
        return 12.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.m_brain.update();
        NonNullList<ItemStack> nonNullList = this.m_inventory;
        synchronized (nonNullList) {
            if (!this.func_145831_w().field_72995_K && this.m_inventoryChanged) {
                IComputer computer = this.getComputer();
                if (computer != null) {
                    computer.queueEvent("turtle_inventory");
                }
                this.m_inventoryChanged = false;
                for (int n = 0; n < this.func_70302_i_(); ++n) {
                    this.m_previousInventory.set(n, (Object)InventoryUtil.copyItem(this.func_70301_a(n)));
                }
            }
        }
    }

    @Override
    public void onNeighbourChange() {
        if (this.m_moveState == MoveState.NOT_MOVED) {
            super.onNeighbourChange();
        }
    }

    @Override
    public void onNeighbourTileEntityChange(@Nonnull BlockPos neighbour) {
        if (this.m_moveState == MoveState.NOT_MOVED) {
            super.onNeighbourTileEntityChange(neighbour);
        }
    }

    public void notifyMoveStart() {
        if (this.m_moveState == MoveState.NOT_MOVED) {
            this.m_moveState = MoveState.IN_PROGRESS;
        }
    }

    public void notifyMoveEnd() {
        if (this.m_moveState == MoveState.IN_PROGRESS) {
            this.m_moveState = MoveState.NOT_MOVED;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
        this.m_inventory = NonNullList.func_191197_a((int)16, (Object)ItemStack.field_190927_a);
        this.m_previousInventory = NonNullList.func_191197_a((int)16, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound itemtag = nbttaglist.func_150305_b(i);
            int slot = itemtag.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.m_inventory.set(slot, (Object)new ItemStack(itemtag));
            this.m_previousInventory.set(slot, (Object)InventoryUtil.copyItem((ItemStack)this.m_inventory.get(slot)));
        }
        this.m_brain.readFromNBT(nbttagcompound);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < 16; ++i) {
            if (((ItemStack)this.m_inventory.get(i)).func_190926_b()) continue;
            NBTTagCompound itemtag = new NBTTagCompound();
            itemtag.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.m_inventory.get(i)).func_77955_b(itemtag);
            nbttaglist.func_74742_a((NBTBase)itemtag);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
        nbttagcompound = this.m_brain.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    protected boolean isPeripheralBlockedOnSide(int localSide) {
        return this.hasPeripheralUpgradeOnSide(localSide);
    }

    @Override
    protected boolean isRedstoneBlockedOnSide(int localSide) {
        return false;
    }

    @Override
    public EnumFacing getDirection() {
        return this.m_brain.getDirection();
    }

    @Override
    public void setDirection(EnumFacing dir) {
        this.m_brain.setDirection(dir);
    }

    @Override
    public ITurtleUpgrade getUpgrade(TurtleSide side) {
        return this.m_brain.getUpgrade(side);
    }

    @Override
    public int getColour() {
        return this.m_brain.getColour();
    }

    @Override
    public ResourceLocation getOverlay() {
        return this.m_brain.getOverlay();
    }

    @Override
    public ITurtleAccess getAccess() {
        return this.m_brain;
    }

    @Override
    public Vec3d getRenderOffset(float f) {
        return this.m_brain.getRenderOffset(f);
    }

    @Override
    public float getRenderYaw(float f) {
        return this.m_brain.getVisualYaw(f);
    }

    @Override
    public float getToolRenderAngle(TurtleSide side, float f) {
        return this.m_brain.getToolRenderAngle(side, f);
    }

    public int func_70302_i_() {
        return 16;
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.m_inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ItemStack func_70301_a(int slot) {
        if (slot >= 0 && slot < 16) {
            NonNullList<ItemStack> nonNullList = this.m_inventory;
            synchronized (nonNullList) {
                return (ItemStack)this.m_inventory.get(slot);
            }
        }
        return ItemStack.field_190927_a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ItemStack func_70304_b(int slot) {
        NonNullList<ItemStack> nonNullList = this.m_inventory;
        synchronized (nonNullList) {
            ItemStack result = this.func_70301_a(slot);
            this.func_70299_a(slot, ItemStack.field_190927_a);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ItemStack func_70298_a(int slot, int count) {
        if (count == 0) {
            return ItemStack.field_190927_a;
        }
        NonNullList<ItemStack> nonNullList = this.m_inventory;
        synchronized (nonNullList) {
            ItemStack stack = this.func_70301_a(slot);
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190916_E() <= count) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
                return stack;
            }
            ItemStack part = stack.func_77979_a(count);
            this.onInventoryDefinitelyChanged();
            return part;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_70299_a(int i, @Nonnull ItemStack stack) {
        if (i >= 0 && i < 16) {
            NonNullList<ItemStack> nonNullList = this.m_inventory;
            synchronized (nonNullList) {
                if (!InventoryUtil.areItemsEqual(stack, (ItemStack)this.m_inventory.get(i))) {
                    this.m_inventory.set(i, (Object)stack);
                    this.onInventoryDefinitelyChanged();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_174888_l() {
        NonNullList<ItemStack> nonNullList = this.m_inventory;
        synchronized (nonNullList) {
            boolean changed = false;
            for (int i = 0; i < 16; ++i) {
                if (((ItemStack)this.m_inventory.get(i)).func_190926_b()) continue;
                this.m_inventory.set(i, (Object)ItemStack.field_190927_a);
                changed = true;
            }
            if (changed) {
                this.onInventoryDefinitelyChanged();
            }
        }
    }

    @Nonnull
    public String func_70005_c_() {
        String label;
        IComputer computer = this.getComputer();
        if (computer != null && (label = computer.getLabel()) != null && label.length() > 0) {
            return label;
        }
        return "tile.computercraft:turtle.name";
    }

    public boolean func_145818_k_() {
        String label;
        IComputer computer = this.getComputer();
        return computer != null && (label = computer.getLabel()) != null && label.length() > 0;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        if (this.func_145818_k_()) {
            return new TextComponentString(this.func_70005_c_());
        }
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_70296_d() {
        super.func_70296_d();
        NonNullList<ItemStack> nonNullList = this.m_inventory;
        synchronized (nonNullList) {
            if (!this.m_inventoryChanged) {
                for (int n = 0; n < this.func_70302_i_(); ++n) {
                    if (ItemStack.func_77989_b((ItemStack)this.func_70301_a(n), (ItemStack)((ItemStack)this.m_previousInventory.get(n)))) continue;
                    this.m_inventoryChanged = true;
                    break;
                }
            }
        }
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return this.isUsable(player, false);
    }

    public int func_174890_g() {
        return 0;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public boolean isUseableByRemote(EntityPlayer player) {
        return this.isUsable(player, true);
    }

    public void onInventoryDefinitelyChanged() {
        super.func_70296_d();
        this.m_inventoryChanged = true;
    }

    public void onTileEntityChange() {
        super.func_70296_d();
    }

    @Override
    public void writeDescription(@Nonnull NBTTagCompound nbttagcompound) {
        super.writeDescription(nbttagcompound);
        this.m_brain.writeDescription(nbttagcompound);
    }

    @Override
    public void readDescription(@Nonnull NBTTagCompound nbttagcompound) {
        super.readDescription(nbttagcompound);
        this.m_brain.readDescription(nbttagcompound);
        this.updateBlock();
    }

    private boolean hasPeripheralUpgradeOnSide(int side) {
        ITurtleUpgrade upgrade;
        switch (side) {
            case 4: {
                upgrade = this.getUpgrade(TurtleSide.Right);
                break;
            }
            case 5: {
                upgrade = this.getUpgrade(TurtleSide.Left);
                break;
            }
            default: {
                return false;
            }
        }
        return upgrade != null && upgrade.getType().isPeripheral();
    }

    public void transferStateFrom(TileTurtle copy) {
        super.transferStateFrom(copy);
        this.m_inventory = copy.m_inventory;
        this.m_previousInventory = copy.m_previousInventory;
        this.m_inventoryChanged = copy.m_inventoryChanged;
        this.m_brain = copy.m_brain;
        this.m_brain.setOwner(this);
        copy.m_moveState = MoveState.MOVED;
    }

    public IItemHandlerModifiable getItemHandler() {
        return this.m_itemHandler;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.m_itemHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    static enum MoveState {
        NOT_MOVED,
        IN_PROGRESS,
        MOVED;

    }
}

