/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.proxy;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.core.computer.MainThread;
import dan200.computercraft.shared.common.ColourableRecipe;
import dan200.computercraft.shared.common.DefaultBundledRedstoneProvider;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.computer.blocks.BlockCommandComputer;
import dan200.computercraft.shared.computer.blocks.BlockComputer;
import dan200.computercraft.shared.computer.blocks.TileCommandComputer;
import dan200.computercraft.shared.computer.blocks.TileComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.inventory.ContainerComputer;
import dan200.computercraft.shared.computer.items.ComputerItemFactory;
import dan200.computercraft.shared.computer.items.ItemCommandComputer;
import dan200.computercraft.shared.computer.items.ItemComputer;
import dan200.computercraft.shared.media.common.DefaultMediaProvider;
import dan200.computercraft.shared.media.inventory.ContainerHeldItem;
import dan200.computercraft.shared.media.items.ItemDiskExpanded;
import dan200.computercraft.shared.media.items.ItemDiskLegacy;
import dan200.computercraft.shared.media.items.ItemPrintout;
import dan200.computercraft.shared.media.items.ItemTreasureDisk;
import dan200.computercraft.shared.media.recipes.DiskRecipe;
import dan200.computercraft.shared.media.recipes.PrintoutRecipe;
import dan200.computercraft.shared.network.ComputerCraftPacket;
import dan200.computercraft.shared.peripheral.PeripheralType;
import dan200.computercraft.shared.peripheral.commandblock.CommandBlockPeripheralProvider;
import dan200.computercraft.shared.peripheral.common.BlockCable;
import dan200.computercraft.shared.peripheral.common.BlockPeripheral;
import dan200.computercraft.shared.peripheral.common.DefaultPeripheralProvider;
import dan200.computercraft.shared.peripheral.common.ItemAdvancedModem;
import dan200.computercraft.shared.peripheral.common.ItemCable;
import dan200.computercraft.shared.peripheral.common.ItemPeripheral;
import dan200.computercraft.shared.peripheral.common.PeripheralItemFactory;
import dan200.computercraft.shared.peripheral.diskdrive.ContainerDiskDrive;
import dan200.computercraft.shared.peripheral.diskdrive.TileDiskDrive;
import dan200.computercraft.shared.peripheral.modem.BlockAdvancedModem;
import dan200.computercraft.shared.peripheral.modem.TileAdvancedModem;
import dan200.computercraft.shared.peripheral.modem.TileCable;
import dan200.computercraft.shared.peripheral.modem.TileWirelessModem;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import dan200.computercraft.shared.peripheral.printer.ContainerPrinter;
import dan200.computercraft.shared.peripheral.printer.TilePrinter;
import dan200.computercraft.shared.peripheral.speaker.TileSpeaker;
import dan200.computercraft.shared.pocket.inventory.ContainerPocketComputer;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.pocket.items.PocketComputerItemFactory;
import dan200.computercraft.shared.pocket.peripherals.PocketModem;
import dan200.computercraft.shared.pocket.peripherals.PocketSpeaker;
import dan200.computercraft.shared.pocket.recipes.PocketComputerUpgradeRecipe;
import dan200.computercraft.shared.proxy.IComputerCraftProxy;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.inventory.ContainerTurtle;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.CreativeTabMain;
import dan200.computercraft.shared.util.ImpostorRecipe;
import dan200.computercraft.shared.util.ImpostorShapelessRecipe;
import dan200.computercraft.shared.util.StringUtil;
import java.io.File;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.RecipeSorter;

public abstract class ComputerCraftProxyCommon
implements IComputerCraftProxy {
    @Override
    public void preInit() {
        this.registerItems();
    }

    @Override
    public void init() {
        this.registerTileEntities();
        this.registerForgeHandlers();
    }

    @Override
    public abstract boolean isClient();

    @Override
    public abstract boolean getGlobalCursorBlink();

    @Override
    public abstract long getRenderFrame();

    @Override
    public void deleteDisplayLists(int list, int range) {
    }

    @Override
    public abstract Object getFixedWidthFontRenderer();

    @Override
    public String getRecordInfo(@Nonnull ItemStack recordStack) {
        Item item = recordStack.func_77973_b();
        if (item instanceof ItemRecord) {
            ItemRecord record = (ItemRecord)item;
            return StringUtil.translateToLocal(record.field_185077_c);
        }
        return null;
    }

    @Override
    public abstract void playRecord(SoundEvent var1, String var2, World var3, BlockPos var4);

    @Override
    public abstract Object getDiskDriveGUI(InventoryPlayer var1, TileDiskDrive var2);

    @Override
    public abstract Object getComputerGUI(TileComputer var1);

    @Override
    public abstract Object getPrinterGUI(InventoryPlayer var1, TilePrinter var2);

    @Override
    public abstract Object getTurtleGUI(InventoryPlayer var1, TileTurtle var2);

    @Override
    public abstract Object getPrintoutGUI(EntityPlayer var1, EnumHand var2);

    @Override
    public abstract Object getPocketComputerGUI(EntityPlayer var1, EnumHand var2);

    @Override
    public abstract File getWorldDir(World var1);

    @Override
    public void handlePacket(final ComputerCraftPacket packet, final EntityPlayer player) {
        MinecraftServer listener = player.func_184102_h();
        if (listener != null) {
            if (listener.func_152345_ab()) {
                this.processPacket(packet, player);
            } else {
                listener.func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        ComputerCraftProxyCommon.this.processPacket(packet, player);
                    }
                });
            }
        }
    }

    private void processPacket(ComputerCraftPacket packet, EntityPlayer player) {
        switch (packet.m_packetType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                int instance = packet.m_dataInt[0];
                ServerComputer computer = (ServerComputer)ComputerCraft.serverComputerRegistry.get(instance);
                if (computer == null) break;
                computer.handlePacket(packet, player);
                break;
            }
            case 9: {
                TileGeneric generic;
                SPacketUpdateTileEntity description;
                int x = packet.m_dataInt[0];
                int y = packet.m_dataInt[1];
                int z = packet.m_dataInt[2];
                BlockPos pos = new BlockPos(x, y, z);
                World world = player.func_130014_f_();
                TileEntity tileEntity = world.func_175625_s(pos);
                if (tileEntity == null || !(tileEntity instanceof TileGeneric) || (description = (generic = (TileGeneric)tileEntity).func_189518_D_()) == null) break;
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)description);
                break;
            }
        }
    }

    private void registerItems() {
        ComputerCraft.mainCreativeTab = new CreativeTabMain(CreativeTabs.getNextID());
        ComputerCraft.Blocks.computer = new BlockComputer();
        this.registerBlock(ComputerCraft.Blocks.computer, (Item)new ItemComputer(ComputerCraft.Blocks.computer), "computer");
        ComputerCraft.Blocks.peripheral = new BlockPeripheral();
        this.registerBlock(ComputerCraft.Blocks.peripheral, (Item)new ItemPeripheral(ComputerCraft.Blocks.peripheral), "peripheral");
        ComputerCraft.Blocks.cable = new BlockCable();
        this.registerBlock(ComputerCraft.Blocks.cable, (Item)new ItemCable(ComputerCraft.Blocks.cable), "cable");
        ComputerCraft.Blocks.commandComputer = new BlockCommandComputer();
        this.registerBlock(ComputerCraft.Blocks.commandComputer, (Item)new ItemCommandComputer(ComputerCraft.Blocks.commandComputer), "command_computer");
        ComputerCraft.Blocks.advancedModem = new BlockAdvancedModem();
        this.registerBlock(ComputerCraft.Blocks.advancedModem, (Item)new ItemAdvancedModem(ComputerCraft.Blocks.advancedModem), "advanced_modem");
        ComputerCraft.Items.disk = new ItemDiskLegacy();
        GameRegistry.register((IForgeRegistryEntry)ComputerCraft.Items.disk.setRegistryName(new ResourceLocation("computercraft", "disk")));
        ComputerCraft.Items.diskExpanded = new ItemDiskExpanded();
        GameRegistry.register((IForgeRegistryEntry)ComputerCraft.Items.diskExpanded.setRegistryName(new ResourceLocation("computercraft", "disk_expanded")));
        ComputerCraft.Items.treasureDisk = new ItemTreasureDisk();
        GameRegistry.register((IForgeRegistryEntry)ComputerCraft.Items.treasureDisk.setRegistryName(new ResourceLocation("computercraft", "treasure_disk")));
        ComputerCraft.Items.printout = new ItemPrintout();
        GameRegistry.register((IForgeRegistryEntry)ComputerCraft.Items.printout.setRegistryName(new ResourceLocation("computercraft", "printout")));
        ComputerCraft.Items.pocketComputer = new ItemPocketComputer();
        GameRegistry.register((IForgeRegistryEntry)ComputerCraft.Items.pocketComputer.setRegistryName(new ResourceLocation("computercraft", "pocket_computer")));
        RecipeSorter.register((String)"computercraft:impostor", ImpostorRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shapeless");
        RecipeSorter.register((String)"computercraft:impostor_shapeless", ImpostorShapelessRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        RecipeSorter.register((String)"computercraft:disk", DiskRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        RecipeSorter.register((String)"computercraft:colour", ColourableRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        RecipeSorter.register((String)"computercraft:printout", PrintoutRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        RecipeSorter.register((String)"computercraft:pocket_computer_upgrade", PocketComputerUpgradeRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        ItemStack computer = ComputerItemFactory.create(-1, null, ComputerFamily.Normal);
        GameRegistry.addRecipe((ItemStack)computer, (Object[])new Object[]{"XXX", "XYX", "XZX", Character.valueOf('X'), Blocks.field_150348_b, Character.valueOf('Y'), Items.field_151137_ax, Character.valueOf('Z'), Blocks.field_150410_aZ});
        ItemStack advancedComputer = ComputerItemFactory.create(-1, null, ComputerFamily.Advanced);
        GameRegistry.addRecipe((ItemStack)advancedComputer, (Object[])new Object[]{"XXX", "XYX", "XZX", Character.valueOf('X'), Items.field_151043_k, Character.valueOf('Y'), Items.field_151137_ax, Character.valueOf('Z'), Blocks.field_150410_aZ});
        ItemStack diskDrive = PeripheralItemFactory.create(PeripheralType.DiskDrive, null, 1);
        GameRegistry.addRecipe((ItemStack)diskDrive, (Object[])new Object[]{"XXX", "XYX", "XYX", Character.valueOf('X'), Blocks.field_150348_b, Character.valueOf('Y'), Items.field_151137_ax});
        ItemStack speaker = PeripheralItemFactory.create(PeripheralType.Speaker, null, 1);
        GameRegistry.addRecipe((ItemStack)speaker, (Object[])new Object[]{"XXX", "XYX", "XZX", Character.valueOf('X'), Blocks.field_150348_b, Character.valueOf('Y'), Blocks.field_150323_B, Character.valueOf('Z'), Items.field_151137_ax});
        ItemStack wirelessModem = PeripheralItemFactory.create(PeripheralType.WirelessModem, null, 1);
        GameRegistry.addRecipe((ItemStack)wirelessModem, (Object[])new Object[]{"XXX", "XYX", "XXX", Character.valueOf('X'), Blocks.field_150348_b, Character.valueOf('Y'), Items.field_151079_bi});
        ItemStack monitor = PeripheralItemFactory.create(PeripheralType.Monitor, null, 1);
        GameRegistry.addRecipe((ItemStack)monitor, (Object[])new Object[]{"XXX", "XYX", "XXX", Character.valueOf('X'), Blocks.field_150348_b, Character.valueOf('Y'), Blocks.field_150410_aZ});
        ItemStack printer = PeripheralItemFactory.create(PeripheralType.Printer, null, 1);
        GameRegistry.addRecipe((ItemStack)printer, (Object[])new Object[]{"XXX", "XYX", "XZX", Character.valueOf('X'), Blocks.field_150348_b, Character.valueOf('Y'), Items.field_151137_ax, Character.valueOf('Z'), new ItemStack(Items.field_151100_aR, 1, 0)});
        ItemStack advancedMonitors = PeripheralItemFactory.create(PeripheralType.AdvancedMonitor, null, 4);
        GameRegistry.addRecipe((ItemStack)advancedMonitors, (Object[])new Object[]{"XXX", "XYX", "XXX", Character.valueOf('X'), Items.field_151043_k, Character.valueOf('Y'), Blocks.field_150410_aZ});
        ItemStack cable = PeripheralItemFactory.create(PeripheralType.Cable, null, 6);
        GameRegistry.addRecipe((ItemStack)cable, (Object[])new Object[]{" X ", "XYX", " X ", Character.valueOf('X'), Blocks.field_150348_b, Character.valueOf('Y'), Items.field_151137_ax});
        ItemStack wiredModem = PeripheralItemFactory.create(PeripheralType.WiredModem, null, 1);
        GameRegistry.addRecipe((ItemStack)wiredModem, (Object[])new Object[]{"XXX", "XYX", "XXX", Character.valueOf('X'), Blocks.field_150348_b, Character.valueOf('Y'), Items.field_151137_ax});
        ItemStack commandComputer = ComputerItemFactory.create(-1, null, ComputerFamily.Command);
        GameRegistry.addRecipe((ItemStack)commandComputer, (Object[])new Object[]{"XXX", "XYX", "XZX", Character.valueOf('X'), Blocks.field_150348_b, Character.valueOf('Y'), Blocks.field_150483_bI, Character.valueOf('Z'), Blocks.field_150410_aZ});
        ItemStack advancedModem = PeripheralItemFactory.create(PeripheralType.AdvancedModem, null, 1);
        GameRegistry.addRecipe((ItemStack)advancedModem, (Object[])new Object[]{"XXX", "XYX", "XXX", Character.valueOf('X'), Items.field_151043_k, Character.valueOf('Y'), Items.field_151061_bv});
        GameRegistry.addRecipe((IRecipe)new DiskRecipe());
        GameRegistry.addRecipe((IRecipe)new ColourableRecipe());
        ItemStack paper = new ItemStack(Items.field_151121_aF, 1);
        ItemStack redstone = new ItemStack(Items.field_151137_ax, 1);
        ItemStack basicDisk = ItemDiskLegacy.createFromIDAndColour(-1, null, Colour.Blue.getHex());
        GameRegistry.addRecipe((IRecipe)new ImpostorShapelessRecipe(basicDisk, new ItemStack[]{redstone, paper}));
        for (int colour = 0; colour < 16; ++colour) {
            ItemStack disk = ItemDiskLegacy.createFromIDAndColour(-1, null, Colour.values()[colour].getHex());
            ItemStack dye = new ItemStack(Items.field_151100_aR, 1, colour);
            for (int otherColour = 0; otherColour < 16; ++otherColour) {
                if (colour == otherColour) continue;
                ItemStack otherDisk = ItemDiskLegacy.createFromIDAndColour(-1, null, Colour.values()[colour].getHex());
                GameRegistry.addRecipe((IRecipe)new ImpostorShapelessRecipe(disk, new ItemStack[]{otherDisk, dye}));
            }
            GameRegistry.addRecipe((IRecipe)new ImpostorShapelessRecipe(disk, new ItemStack[]{redstone, paper, dye}));
        }
        GameRegistry.addRecipe((IRecipe)new PrintoutRecipe());
        ItemStack singlePrintout = ItemPrintout.createSingleFromTitleAndText(null, null, null);
        ItemStack multiplePrintout = ItemPrintout.createMultipleFromTitleAndText(null, null, null);
        ItemStack bookPrintout = ItemPrintout.createBookFromTitleAndText(null, null, null);
        ItemStack string = new ItemStack(Items.field_151007_F, 1, 0);
        GameRegistry.addRecipe((IRecipe)new ImpostorShapelessRecipe(multiplePrintout, new ItemStack[]{singlePrintout, singlePrintout, string}));
        ItemStack leather = new ItemStack(Items.field_151116_aA, 1, 0);
        GameRegistry.addRecipe((IRecipe)new ImpostorShapelessRecipe(bookPrintout, new ItemStack[]{leather, singlePrintout, string}));
        ItemStack pocketComputer = PocketComputerItemFactory.create(-1, null, -1, ComputerFamily.Normal, null);
        GameRegistry.addRecipe((ItemStack)pocketComputer, (Object[])new Object[]{"XXX", "XYX", "XZX", Character.valueOf('X'), Blocks.field_150348_b, Character.valueOf('Y'), Items.field_151153_ao, Character.valueOf('Z'), Blocks.field_150410_aZ});
        ItemStack advancedPocketComputer = PocketComputerItemFactory.create(-1, null, -1, ComputerFamily.Advanced, null);
        GameRegistry.addRecipe((ItemStack)advancedPocketComputer, (Object[])new Object[]{"XXX", "XYX", "XZX", Character.valueOf('X'), Items.field_151043_k, Character.valueOf('Y'), Items.field_151153_ao, Character.valueOf('Z'), Blocks.field_150410_aZ});
        ComputerCraft.PocketUpgrades.wirelessModem = new PocketModem(false);
        ComputerCraftAPI.registerPocketUpgrade(ComputerCraft.PocketUpgrades.wirelessModem);
        ComputerCraft.PocketUpgrades.advancedModem = new PocketModem(true);
        ComputerCraftAPI.registerPocketUpgrade(ComputerCraft.PocketUpgrades.advancedModem);
        ComputerCraft.PocketUpgrades.pocketSpeaker = new PocketSpeaker();
        ComputerCraftAPI.registerPocketUpgrade(ComputerCraft.PocketUpgrades.pocketSpeaker);
        GameRegistry.addRecipe((IRecipe)new PocketComputerUpgradeRecipe());
        for (IPocketUpgrade upgrade : ComputerCraft.getVanillaPocketUpgrades()) {
            GameRegistry.addRecipe((IRecipe)new ImpostorRecipe(1, 2, new ItemStack[]{upgrade.getCraftingItem(), pocketComputer}, PocketComputerItemFactory.create(-1, null, -1, ComputerFamily.Normal, upgrade)));
            GameRegistry.addRecipe((IRecipe)new ImpostorRecipe(1, 2, new ItemStack[]{upgrade.getCraftingItem(), advancedPocketComputer}, PocketComputerItemFactory.create(-1, null, -1, ComputerFamily.Advanced, upgrade)));
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("SkullOwner", "dan200");
        ItemStack danHead = new ItemStack(Items.field_151144_bL, 1, 3);
        danHead.func_77982_d(tag);
        GameRegistry.addShapelessRecipe((ItemStack)danHead, (Object[])new Object[]{computer, new ItemStack(Items.field_151144_bL, 1, 1)});
        tag = new NBTTagCompound();
        tag.func_74778_a("SkullOwner", "Cloudhunter");
        ItemStack cloudyHead = new ItemStack(Items.field_151144_bL, 1, 3);
        cloudyHead.func_77982_d(tag);
        GameRegistry.addShapelessRecipe((ItemStack)cloudyHead, (Object[])new Object[]{monitor, new ItemStack(Items.field_151144_bL, 1, 1)});
    }

    @Override
    public void remap(FMLMissingMappingsEvent mappings) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : mappings.getAll()) {
            String domain = mapping.resourceLocation.func_110624_b();
            if (!domain.equalsIgnoreCase("computercraft")) continue;
            String key = mapping.resourceLocation.func_110623_a();
            if (key.equalsIgnoreCase("CC-Computer")) {
                ComputerCraftProxyCommon.remap(mapping, ComputerCraft.Blocks.computer);
                continue;
            }
            if (key.equalsIgnoreCase("CC-Peripheral")) {
                ComputerCraftProxyCommon.remap(mapping, ComputerCraft.Blocks.peripheral);
                continue;
            }
            if (key.equalsIgnoreCase("CC-Cable")) {
                ComputerCraftProxyCommon.remap(mapping, ComputerCraft.Blocks.cable);
                continue;
            }
            if (key.equalsIgnoreCase("diskExpanded")) {
                mapping.remap((Item)ComputerCraft.Items.diskExpanded);
                continue;
            }
            if (key.equalsIgnoreCase("treasureDisk")) {
                mapping.remap((Item)ComputerCraft.Items.treasureDisk);
                continue;
            }
            if (!key.equalsIgnoreCase("pocketComputer")) continue;
            mapping.remap((Item)ComputerCraft.Items.pocketComputer);
        }
    }

    private static void remap(FMLMissingMappingsEvent.MissingMapping mapping, Block block) {
        if (mapping.type == GameRegistry.Type.BLOCK) {
            mapping.remap(block);
        } else {
            mapping.remap(Item.func_150898_a((Block)block));
        }
    }

    private void registerBlock(Block block, Item item, String name) {
        GameRegistry.register((IForgeRegistryEntry)block.setRegistryName(new ResourceLocation("computercraft", name)));
        GameRegistry.register((IForgeRegistryEntry)item.setRegistryName(new ResourceLocation("computercraft", name)));
    }

    private void registerTileEntity(Class<? extends TileEntity> klass, String name) {
        GameRegistry.registerTileEntityWithAlternatives(klass, (String)("computercraft : " + name), (String[])new String[]{name});
    }

    private void registerTileEntities() {
        this.registerTileEntity(TileComputer.class, "computer");
        this.registerTileEntity(TileDiskDrive.class, "diskdrive");
        this.registerTileEntity(TileWirelessModem.class, "wirelessmodem");
        this.registerTileEntity(TileMonitor.class, "monitor");
        this.registerTileEntity(TilePrinter.class, "ccprinter");
        this.registerTileEntity(TileCable.class, "wiredmodem");
        this.registerTileEntity(TileCommandComputer.class, "command_computer");
        this.registerTileEntity(TileAdvancedModem.class, "advanced_modem");
        this.registerTileEntity(TileSpeaker.class, "speaker");
        ComputerCraftAPI.registerPeripheralProvider(new DefaultPeripheralProvider());
        if (ComputerCraft.enableCommandBlock) {
            ComputerCraftAPI.registerPeripheralProvider(new CommandBlockPeripheralProvider());
        }
        ComputerCraftAPI.registerBundledRedstoneProvider(new DefaultBundledRedstoneProvider());
        ComputerCraftAPI.registerMediaProvider(new DefaultMediaProvider());
    }

    private void registerForgeHandlers() {
        ForgeHandlers handlers = new ForgeHandlers();
        MinecraftForge.EVENT_BUS.register((Object)handlers);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)ComputerCraft.instance, (IGuiHandler)handlers);
    }

    public class ForgeHandlers
    implements IGuiHandler {
        private ForgeHandlers() {
        }

        public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
            BlockPos pos = new BlockPos(x, y, z);
            switch (id) {
                case 100: {
                    TileEntity tile = world.func_175625_s(pos);
                    if (tile == null || !(tile instanceof TileDiskDrive)) break;
                    TileDiskDrive drive = (TileDiskDrive)tile;
                    return new ContainerDiskDrive((IInventory)player.field_71071_by, drive);
                }
                case 101: {
                    TileEntity tile = world.func_175625_s(pos);
                    if (tile == null || !(tile instanceof TileComputer)) break;
                    TileComputer computer = (TileComputer)tile;
                    return new ContainerComputer(computer);
                }
                case 102: {
                    TileEntity tile = world.func_175625_s(pos);
                    if (tile == null || !(tile instanceof TilePrinter)) break;
                    TilePrinter printer = (TilePrinter)tile;
                    return new ContainerPrinter((IInventory)player.field_71071_by, printer);
                }
                case 103: {
                    TileEntity tile = world.func_175625_s(pos);
                    if (tile == null || !(tile instanceof TileTurtle)) break;
                    TileTurtle turtle = (TileTurtle)tile;
                    return new ContainerTurtle((IInventory)player.field_71071_by, turtle.getAccess(), turtle.getServerComputer());
                }
                case 105: {
                    return new ContainerHeldItem(player, x == 0 ? EnumHand.MAIN_HAND : EnumHand.MAIN_HAND);
                }
                case 106: {
                    return new ContainerPocketComputer(player, x == 0 ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND);
                }
            }
            return null;
        }

        public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
            BlockPos pos = new BlockPos(x, y, z);
            switch (id) {
                case 100: {
                    TileEntity tile = world.func_175625_s(pos);
                    if (tile == null || !(tile instanceof TileDiskDrive)) break;
                    TileDiskDrive drive = (TileDiskDrive)tile;
                    return ComputerCraftProxyCommon.this.getDiskDriveGUI(player.field_71071_by, drive);
                }
                case 101: {
                    TileEntity tile = world.func_175625_s(pos);
                    if (tile == null || !(tile instanceof TileComputer)) break;
                    TileComputer computer = (TileComputer)tile;
                    return ComputerCraftProxyCommon.this.getComputerGUI(computer);
                }
                case 102: {
                    TileEntity tile = world.func_175625_s(pos);
                    if (tile == null || !(tile instanceof TilePrinter)) break;
                    TilePrinter printer = (TilePrinter)tile;
                    return ComputerCraftProxyCommon.this.getPrinterGUI(player.field_71071_by, printer);
                }
                case 103: {
                    TileEntity tile = world.func_175625_s(pos);
                    if (tile == null || !(tile instanceof TileTurtle)) break;
                    TileTurtle turtle = (TileTurtle)tile;
                    return ComputerCraftProxyCommon.this.getTurtleGUI(player.field_71071_by, turtle);
                }
                case 105: {
                    return ComputerCraftProxyCommon.this.getPrintoutGUI(player, x == 0 ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND);
                }
                case 106: {
                    return ComputerCraftProxyCommon.this.getPocketComputerGUI(player, x == 0 ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND);
                }
            }
            return null;
        }

        @SubscribeEvent
        public void onConnectionOpened(FMLNetworkEvent.ClientConnectedToServerEvent event) {
            ComputerCraft.clientComputerRegistry.reset();
        }

        @SubscribeEvent
        public void onConnectionClosed(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
            ComputerCraft.clientComputerRegistry.reset();
        }

        @SubscribeEvent
        public void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                ComputerCraft.clientComputerRegistry.update();
            }
        }

        @SubscribeEvent
        public void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                MainThread.executePendingTasks();
                ComputerCraft.serverComputerRegistry.update();
            }
        }

        @SubscribeEvent
        public void onWorldLoad(WorldEvent.Load event) {
        }

        @SubscribeEvent
        public void onWorldUnload(WorldEvent.Unload event) {
        }

        @SubscribeEvent
        public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("computercraft")) {
                ComputerCraft.syncConfig();
            }
        }
    }
}

