/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.proxy;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.items.ComputerItemFactory;
import dan200.computercraft.shared.proxy.ICCTurtleProxy;
import dan200.computercraft.shared.turtle.blocks.BlockTurtle;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.blocks.TileTurtleAdvanced;
import dan200.computercraft.shared.turtle.blocks.TileTurtleExpanded;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.turtle.items.ItemTurtleAdvanced;
import dan200.computercraft.shared.turtle.items.ItemTurtleLegacy;
import dan200.computercraft.shared.turtle.items.ItemTurtleNormal;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import dan200.computercraft.shared.turtle.recipes.TurtleRecipe;
import dan200.computercraft.shared.turtle.recipes.TurtleUpgradeRecipe;
import dan200.computercraft.shared.turtle.upgrades.TurtleAxe;
import dan200.computercraft.shared.turtle.upgrades.TurtleCraftingTable;
import dan200.computercraft.shared.turtle.upgrades.TurtleHoe;
import dan200.computercraft.shared.turtle.upgrades.TurtleModem;
import dan200.computercraft.shared.turtle.upgrades.TurtleShovel;
import dan200.computercraft.shared.turtle.upgrades.TurtleSpeaker;
import dan200.computercraft.shared.turtle.upgrades.TurtleSword;
import dan200.computercraft.shared.turtle.upgrades.TurtleTool;
import dan200.computercraft.shared.util.IEntityDropConsumer;
import dan200.computercraft.shared.util.ImpostorRecipe;
import dan200.computercraft.shared.util.InventoryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.RecipeSorter;

public abstract class CCTurtleProxyCommon
implements ICCTurtleProxy {
    private Map<Integer, ITurtleUpgrade> m_legacyTurtleUpgrades = new HashMap<Integer, ITurtleUpgrade>();
    private Map<String, ITurtleUpgrade> m_turtleUpgrades = new HashMap<String, ITurtleUpgrade>();
    private Map<Entity, IEntityDropConsumer> m_dropConsumers = new WeakHashMap<Entity, IEntityDropConsumer>();

    @Override
    public void preInit() {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("computercraft", "turtle_player"), TurtlePlayer.class, (String)"turtle_player", (int)0, (Object)ComputerCraft.instance, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (boolean)false);
        this.registerItems();
    }

    @Override
    public void init() {
        this.registerForgeHandlers();
        this.registerTileEntities();
    }

    @Override
    public void registerTurtleUpgrade(ITurtleUpgrade upgrade) {
        int id = upgrade.getLegacyUpgradeID();
        if (id >= 0 && id < 64) {
            String message = "Error registering '" + upgrade.getUnlocalisedAdjective() + " Turtle'. Legacy UpgradeID '" + id + "' is reserved by ComputerCraft";
            ComputerCraft.log.error(message);
            throw new RuntimeException(message);
        }
        this.registerTurtleUpgradeInternal(upgrade);
    }

    @Override
    public ITurtleUpgrade getTurtleUpgrade(String id) {
        return this.m_turtleUpgrades.get(id);
    }

    @Override
    public ITurtleUpgrade getTurtleUpgrade(int legacyId) {
        return this.m_legacyTurtleUpgrades.get(legacyId);
    }

    @Override
    public ITurtleUpgrade getTurtleUpgrade(@Nonnull ItemStack stack) {
        for (ITurtleUpgrade upgrade : this.m_turtleUpgrades.values()) {
            try {
                ItemStack upgradeStack = upgrade.getCraftingItem();
                if (!InventoryUtil.areItemsStackable(upgradeStack, stack)) continue;
                return upgrade;
            }
            catch (Exception e) {
                ComputerCraft.log.error("Error getting computer upgrade item", (Throwable)e);
            }
        }
        return null;
    }

    public static boolean isUpgradeVanilla(ITurtleUpgrade upgrade) {
        return upgrade instanceof TurtleTool || upgrade instanceof TurtleModem || upgrade instanceof TurtleCraftingTable || upgrade instanceof TurtleSpeaker;
    }

    public static boolean isUpgradeSuitableForFamily(ComputerFamily family, ITurtleUpgrade upgrade) {
        if (family == ComputerFamily.Beginners) {
            return upgrade.getType().isTool();
        }
        return true;
    }

    private void addAllUpgradedTurtles(ComputerFamily family, NonNullList<ItemStack> list) {
        ItemStack basicStack = TurtleItemFactory.create(-1, null, -1, family, null, null, 0, null);
        if (!basicStack.func_190926_b()) {
            list.add((Object)basicStack);
        }
        this.addUpgradedTurtle(family, ComputerCraft.Upgrades.diamondPickaxe, (List<ItemStack>)list);
        this.addUpgradedTurtle(family, ComputerCraft.Upgrades.diamondAxe, (List<ItemStack>)list);
        this.addUpgradedTurtle(family, ComputerCraft.Upgrades.diamondSword, (List<ItemStack>)list);
        this.addUpgradedTurtle(family, ComputerCraft.Upgrades.diamondShovel, (List<ItemStack>)list);
        this.addUpgradedTurtle(family, ComputerCraft.Upgrades.diamondHoe, (List<ItemStack>)list);
        this.addUpgradedTurtle(family, ComputerCraft.Upgrades.craftingTable, (List<ItemStack>)list);
        this.addUpgradedTurtle(family, ComputerCraft.Upgrades.wirelessModem, (List<ItemStack>)list);
        this.addUpgradedTurtle(family, ComputerCraft.Upgrades.advancedModem, (List<ItemStack>)list);
        this.addUpgradedTurtle(family, ComputerCraft.Upgrades.turtleSpeaker, (List<ItemStack>)list);
    }

    private void addUpgradedTurtle(ComputerFamily family, ITurtleUpgrade upgrade, List<ItemStack> list) {
        ItemStack stack;
        if (CCTurtleProxyCommon.isUpgradeSuitableForFamily(family, upgrade) && !(stack = TurtleItemFactory.create(-1, null, -1, family, upgrade, null, 0, null)).func_190926_b()) {
            list.add(stack);
        }
    }

    @Override
    public void addAllUpgradedTurtles(NonNullList<ItemStack> list) {
        this.addAllUpgradedTurtles(ComputerFamily.Normal, list);
        this.addAllUpgradedTurtles(ComputerFamily.Advanced, list);
    }

    @Override
    public void setEntityDropConsumer(Entity entity, IEntityDropConsumer consumer) {
        boolean captured;
        if (!this.m_dropConsumers.containsKey(entity) && !(captured = entity.captureDrops)) {
            entity.captureDrops = true;
            ArrayList items = entity.capturedDrops;
            if (items == null || items.size() == 0) {
                this.m_dropConsumers.put(entity, consumer);
            }
        }
    }

    @Override
    public void clearEntityDropConsumer(Entity entity) {
        if (this.m_dropConsumers.containsKey(entity)) {
            boolean captured = entity.captureDrops;
            if (captured) {
                entity.captureDrops = false;
                ArrayList items = entity.capturedDrops;
                if (items != null) {
                    this.dispatchEntityDrops(entity, items);
                    items.clear();
                }
            }
            this.m_dropConsumers.remove(entity);
        }
    }

    private void registerTurtleUpgradeInternal(ITurtleUpgrade upgrade) {
        String id;
        ITurtleUpgrade existing;
        int legacyID = upgrade.getLegacyUpgradeID();
        if (legacyID >= 0) {
            if (legacyID >= Short.MAX_VALUE) {
                String message = "Error registering '" + upgrade.getUnlocalisedAdjective() + " Turtle'. UpgradeID '" + legacyID + "' is out of range";
                ComputerCraft.log.error(message);
                throw new RuntimeException(message);
            }
            ITurtleUpgrade existing2 = this.m_legacyTurtleUpgrades.get(legacyID);
            if (existing2 != null) {
                String message = "Error registering '" + upgrade.getUnlocalisedAdjective() + " Turtle'. UpgradeID '" + legacyID + "' is already registered by '" + existing2.getUnlocalisedAdjective() + " Turtle'";
                ComputerCraft.log.error(message);
                throw new RuntimeException(message);
            }
        }
        if ((existing = this.m_turtleUpgrades.get(id = upgrade.getUpgradeID().toString())) != null) {
            String message = "Error registering '" + upgrade.getUnlocalisedAdjective() + " Turtle'. UpgradeID '" + id + "' is already registered by '" + existing.getUnlocalisedAdjective() + " Turtle'";
            ComputerCraft.log.error(message);
            throw new RuntimeException(message);
        }
        if (legacyID >= 0) {
            this.m_legacyTurtleUpgrades.put(legacyID, upgrade);
        }
        this.m_turtleUpgrades.put(id, upgrade);
        if (CCTurtleProxyCommon.isUpgradeVanilla(upgrade)) {
            List recipeList = CraftingManager.func_77594_a().func_77592_b();
            ItemStack craftingItem = upgrade.getCraftingItem();
            for (ComputerFamily family : ComputerFamily.values()) {
                ItemStack baseTurtle;
                if (!CCTurtleProxyCommon.isUpgradeSuitableForFamily(family, upgrade) || (baseTurtle = TurtleItemFactory.create(-1, null, -1, family, null, null, 0, null)).func_190926_b()) continue;
                ItemStack craftedTurtle = TurtleItemFactory.create(-1, null, -1, family, upgrade, null, 0, null);
                ItemStack craftedTurtleFlipped = TurtleItemFactory.create(-1, null, -1, family, null, upgrade, 0, null);
                recipeList.add(new ImpostorRecipe(2, 1, new ItemStack[]{baseTurtle, craftingItem}, craftedTurtle));
                recipeList.add(new ImpostorRecipe(2, 1, new ItemStack[]{craftingItem, baseTurtle}, craftedTurtleFlipped));
                for (ITurtleUpgrade otherUpgrade : this.m_turtleUpgrades.values()) {
                    if (!CCTurtleProxyCommon.isUpgradeVanilla(otherUpgrade) || !CCTurtleProxyCommon.isUpgradeSuitableForFamily(family, otherUpgrade)) continue;
                    ItemStack otherCraftingItem = otherUpgrade.getCraftingItem();
                    ItemStack otherCraftedTurtle = TurtleItemFactory.create(-1, null, -1, family, null, otherUpgrade, 0, null);
                    ItemStack comboCraftedTurtle = TurtleItemFactory.create(-1, null, -1, family, upgrade, otherUpgrade, 0, null);
                    ItemStack otherCraftedTurtleFlipped = TurtleItemFactory.create(-1, null, -1, family, otherUpgrade, null, 0, null);
                    ItemStack comboCraftedTurtleFlipped = TurtleItemFactory.create(-1, null, -1, family, otherUpgrade, upgrade, 0, null);
                    recipeList.add(new ImpostorRecipe(2, 1, new ItemStack[]{otherCraftingItem, craftedTurtle}, comboCraftedTurtle));
                    recipeList.add(new ImpostorRecipe(2, 1, new ItemStack[]{otherCraftedTurtle, craftingItem}, comboCraftedTurtle));
                    recipeList.add(new ImpostorRecipe(2, 1, new ItemStack[]{craftedTurtleFlipped, otherCraftingItem}, comboCraftedTurtleFlipped));
                    recipeList.add(new ImpostorRecipe(2, 1, new ItemStack[]{craftingItem, otherCraftedTurtleFlipped}, comboCraftedTurtleFlipped));
                    recipeList.add(new ImpostorRecipe(3, 1, new ItemStack[]{otherCraftingItem, baseTurtle, craftingItem}, comboCraftedTurtle));
                    recipeList.add(new ImpostorRecipe(3, 1, new ItemStack[]{craftingItem, baseTurtle, otherCraftingItem}, comboCraftedTurtleFlipped));
                }
            }
        }
    }

    private void registerItems() {
        ComputerCraft.Blocks.turtle = BlockTurtle.createTurtleBlock();
        this.registerBlock(ComputerCraft.Blocks.turtle, (Item)new ItemTurtleLegacy(ComputerCraft.Blocks.turtle), "turtle");
        ComputerCraft.Blocks.turtleExpanded = BlockTurtle.createTurtleBlock();
        this.registerBlock(ComputerCraft.Blocks.turtleExpanded, (Item)new ItemTurtleNormal(ComputerCraft.Blocks.turtleExpanded), "turtle_expanded");
        ComputerCraft.Blocks.turtleAdvanced = BlockTurtle.createTurtleBlock();
        this.registerBlock(ComputerCraft.Blocks.turtleAdvanced, (Item)new ItemTurtleAdvanced(ComputerCraft.Blocks.turtleAdvanced), "turtle_advanced");
        RecipeSorter.register((String)"computercraft:turtle", TurtleRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shapeless");
        RecipeSorter.register((String)"computercraft:turtle_upgrade", TurtleUpgradeRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shapeless");
        GameRegistry.addRecipe((IRecipe)new TurtleRecipe(new Item[]{Items.field_151042_j, Items.field_151042_j, Items.field_151042_j, Items.field_151042_j, Item.func_150898_a((Block)ComputerCraft.Blocks.computer), Items.field_151042_j, Items.field_151042_j, Item.func_150898_a((Block)Blocks.field_150486_ae), Items.field_151042_j}, ComputerFamily.Normal));
        GameRegistry.addRecipe((IRecipe)new TurtleUpgradeRecipe());
        ItemStack iron = new ItemStack(Items.field_151042_j, 1);
        GameRegistry.addRecipe((IRecipe)new ImpostorRecipe(3, 3, new ItemStack[]{iron, iron, iron, iron, ComputerItemFactory.create(-1, null, ComputerFamily.Normal), iron, iron, new ItemStack((Block)Blocks.field_150486_ae, 1), iron}, TurtleItemFactory.create(-1, null, -1, ComputerFamily.Normal, null, null, 0, null)));
        GameRegistry.addRecipe((IRecipe)new TurtleRecipe(new Item[]{Items.field_151043_k, Items.field_151043_k, Items.field_151043_k, Items.field_151043_k, Item.func_150898_a((Block)ComputerCraft.Blocks.computer), Items.field_151043_k, Items.field_151043_k, Item.func_150898_a((Block)Blocks.field_150486_ae), Items.field_151043_k}, ComputerFamily.Advanced));
        ItemStack gold = new ItemStack(Items.field_151043_k, 1);
        GameRegistry.addRecipe((IRecipe)new ImpostorRecipe(3, 3, new ItemStack[]{gold, gold, gold, gold, ComputerItemFactory.create(-1, null, ComputerFamily.Advanced), gold, gold, new ItemStack((Block)Blocks.field_150486_ae, 1), gold}, TurtleItemFactory.create(-1, null, -1, ComputerFamily.Advanced, null, null, 0, null)));
        ComputerCraft.Upgrades.wirelessModem = new TurtleModem(false, new ResourceLocation("computercraft", "wireless_modem"), 1);
        this.registerTurtleUpgradeInternal(ComputerCraft.Upgrades.wirelessModem);
        ComputerCraft.Upgrades.craftingTable = new TurtleCraftingTable(2);
        this.registerTurtleUpgradeInternal(ComputerCraft.Upgrades.craftingTable);
        ComputerCraft.Upgrades.diamondSword = new TurtleSword(new ResourceLocation("minecraft", "diamond_sword"), 3, "upgrade.minecraft:diamond_sword.adjective", Items.field_151048_u);
        this.registerTurtleUpgradeInternal(ComputerCraft.Upgrades.diamondSword);
        ComputerCraft.Upgrades.diamondShovel = new TurtleShovel(new ResourceLocation("minecraft", "diamond_shovel"), 4, "upgrade.minecraft:diamond_shovel.adjective", Items.field_151047_v);
        this.registerTurtleUpgradeInternal(ComputerCraft.Upgrades.diamondShovel);
        ComputerCraft.Upgrades.diamondPickaxe = new TurtleTool(new ResourceLocation("minecraft", "diamond_pickaxe"), 5, "upgrade.minecraft:diamond_pickaxe.adjective", Items.field_151046_w);
        this.registerTurtleUpgradeInternal(ComputerCraft.Upgrades.diamondPickaxe);
        ComputerCraft.Upgrades.diamondAxe = new TurtleAxe(new ResourceLocation("minecraft", "diamond_axe"), 6, "upgrade.minecraft:diamond_axe.adjective", Items.field_151056_x);
        this.registerTurtleUpgradeInternal(ComputerCraft.Upgrades.diamondAxe);
        ComputerCraft.Upgrades.diamondHoe = new TurtleHoe(new ResourceLocation("minecraft", "diamond_hoe"), 7, "upgrade.minecraft:diamond_hoe.adjective", Items.field_151012_L);
        this.registerTurtleUpgradeInternal(ComputerCraft.Upgrades.diamondHoe);
        ComputerCraft.Upgrades.advancedModem = new TurtleModem(true, new ResourceLocation("computercraft", "advanced_modem"), -1);
        this.registerTurtleUpgradeInternal(ComputerCraft.Upgrades.advancedModem);
        ComputerCraft.Upgrades.turtleSpeaker = new TurtleSpeaker(new ResourceLocation("computercraft", "speaker"), 8);
        this.registerTurtleUpgradeInternal(ComputerCraft.Upgrades.turtleSpeaker);
    }

    @Override
    public void remap(FMLMissingMappingsEvent mappings) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : mappings.getAll()) {
            String domain = mapping.resourceLocation.func_110624_b();
            if (!domain.equalsIgnoreCase("computercraft")) continue;
            String key = mapping.resourceLocation.func_110623_a();
            if (key.equalsIgnoreCase("CC-Turtle")) {
                CCTurtleProxyCommon.remap(mapping, ComputerCraft.Blocks.turtle);
                continue;
            }
            if (key.equalsIgnoreCase("CC-TurtleExpanded")) {
                CCTurtleProxyCommon.remap(mapping, ComputerCraft.Blocks.turtleExpanded);
                continue;
            }
            if (!key.equalsIgnoreCase("CC-TurtleAdvanced")) continue;
            CCTurtleProxyCommon.remap(mapping, ComputerCraft.Blocks.turtleAdvanced);
        }
    }

    private static void remap(FMLMissingMappingsEvent.MissingMapping mapping, Block block) {
        if (mapping.type == GameRegistry.Type.BLOCK) {
            mapping.remap(block);
        } else {
            mapping.remap(Item.func_150898_a((Block)block));
        }
    }

    private void registerBlock(Block block, Item item, String name) {
        GameRegistry.register((IForgeRegistryEntry)block.setRegistryName(new ResourceLocation("computercraft", name)));
        GameRegistry.register((IForgeRegistryEntry)item.setRegistryName(new ResourceLocation("computercraft", name)));
    }

    private void registerTileEntity(Class<? extends TileEntity> klass, String name) {
        GameRegistry.registerTileEntityWithAlternatives(klass, (String)("computercraft : " + name), (String[])new String[]{name});
    }

    private void registerTileEntities() {
        this.registerTileEntity(TileTurtle.class, "turtle");
        this.registerTileEntity(TileTurtleExpanded.class, "turtleex");
        this.registerTileEntity(TileTurtleAdvanced.class, "turtleadv");
    }

    private void registerForgeHandlers() {
        ForgeHandlers handlers = new ForgeHandlers();
        MinecraftForge.EVENT_BUS.register((Object)handlers);
    }

    private void dispatchEntityDrops(Entity entity, List<EntityItem> drops) {
        IEntityDropConsumer consumer = this.m_dropConsumers.get(entity);
        if (consumer != null) {
            for (EntityItem entityItem : drops) {
                consumer.consumeDrop(entity, entityItem.func_92059_d());
            }
            drops.clear();
        }
    }

    public class ForgeHandlers {
        private ForgeHandlers() {
        }

        @SubscribeEvent
        public void onEntityLivingDrops(LivingDropsEvent event) {
            CCTurtleProxyCommon.this.dispatchEntityDrops(event.getEntity(), event.getDrops());
        }
    }
}

