/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.peripherals;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.shared.peripheral.PeripheralType;
import dan200.computercraft.shared.peripheral.common.PeripheralItemFactory;
import dan200.computercraft.shared.pocket.peripherals.PocketSpeakerPeripheral;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class PocketSpeaker
implements IPocketUpgrade {
    @Override
    @Nonnull
    public ResourceLocation getUpgradeID() {
        return new ResourceLocation("computercraft", "speaker");
    }

    @Override
    @Nonnull
    public String getUnlocalisedAdjective() {
        return "upgrade.computercraft:speaker.adjective";
    }

    @Override
    @Nonnull
    public ItemStack getCraftingItem() {
        return PeripheralItemFactory.create(PeripheralType.Speaker, null, 1);
    }

    @Override
    @Nullable
    public IPeripheral createPeripheral(@Nonnull IPocketAccess access) {
        return new PocketSpeakerPeripheral();
    }

    @Override
    public void update(@Nonnull IPocketAccess access, @Nullable IPeripheral peripheral) {
        if (peripheral instanceof PocketSpeakerPeripheral) {
            Entity entity = access.getEntity();
            PocketSpeakerPeripheral speaker = (PocketSpeakerPeripheral)peripheral;
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase player = (EntityLivingBase)entity;
                speaker.setLocation(entity.func_130014_f_(), player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
            } else if (entity != null) {
                speaker.setLocation(entity.func_130014_f_(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            }
            speaker.update();
        }
    }

    @Override
    public boolean onRightClick(@Nonnull World world, @Nonnull IPocketAccess access, @Nullable IPeripheral peripheral) {
        return false;
    }
}

