/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.items;

import com.google.common.base.Objects;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.computer.blocks.ComputerState;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.items.IComputerItem;
import dan200.computercraft.shared.pocket.apis.PocketAPI;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.pocket.items.PocketComputerItemFactory;
import dan200.computercraft.shared.util.StringUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPocketComputer
extends Item
implements IComputerItem,
IMedia,
IColouredItem {
    public ItemPocketComputer() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77655_b("computercraft:pocket_computer");
        this.func_77637_a(ComputerCraft.mainCreativeTab);
    }

    public ItemStack create(int id, String label, int colour, ComputerFamily family, IPocketUpgrade upgrade) {
        if (family != ComputerFamily.Normal && family != ComputerFamily.Advanced) {
            return null;
        }
        int damage = family == ComputerFamily.Advanced ? 1 : 0;
        ItemStack result = new ItemStack((Item)this, 1, damage);
        if (id >= 0 || upgrade != null) {
            NBTTagCompound compound = new NBTTagCompound();
            if (id >= 0) {
                compound.func_74768_a("computerID", id);
            }
            if (upgrade != null) {
                compound.func_74778_a("upgrade", upgrade.getUpgradeID().toString());
            }
            result.func_77982_d(compound);
        }
        if (label != null) {
            result.func_151001_c(label);
        }
        if (colour != -1) {
            NBTTagCompound tag = result.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
                result.func_77982_d(tag);
            }
            tag.func_74768_a("colour", colour);
        }
        return result;
    }

    public void func_150895_a(@Nonnull Item itemID, CreativeTabs tabs, NonNullList<ItemStack> list) {
        this.getSubItems(list, ComputerFamily.Normal);
        this.getSubItems(list, ComputerFamily.Advanced);
    }

    private void getSubItems(NonNullList<ItemStack> list, ComputerFamily family) {
        list.add((Object)PocketComputerItemFactory.create(-1, null, -1, family, null));
        for (IPocketUpgrade upgrade : ComputerCraft.getVanillaPocketUpgrades()) {
            list.add((Object)PocketComputerItemFactory.create(-1, null, -1, family, upgrade));
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotNum, boolean selected) {
        if (!world.field_72995_K) {
            InventoryPlayer inventory = entity instanceof EntityPlayer ? ((EntityPlayer)entity).field_71071_by : null;
            PocketServerComputer computer = this.createServerComputer(world, (IInventory)inventory, entity, stack);
            if (computer != null) {
                String label;
                IPocketUpgrade upgrade = this.getUpgrade(stack);
                computer.keepAlive();
                computer.setWorld(world);
                computer.updateValues(entity, stack, upgrade);
                int id = computer.getID();
                if (id != this.getComputerID(stack)) {
                    this.setComputerID(stack, id);
                    if (inventory != null) {
                        inventory.func_70296_d();
                    }
                }
                if (!Objects.equal((Object)(label = computer.getLabel()), (Object)this.getLabel(stack))) {
                    this.setLabel(stack, label);
                    if (inventory != null) {
                        inventory.func_70296_d();
                    }
                }
                if (upgrade != null) {
                    upgrade.update(computer, computer.getPeripheral(2));
                }
            }
        } else {
            ClientComputer computer = this.createClientComputer(stack);
            if (computer != null) {
                // empty if block
            }
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            PocketServerComputer computer = this.createServerComputer(world, (IInventory)player.field_71071_by, (Entity)player, stack);
            boolean stop = false;
            if (computer != null) {
                computer.turnOn();
                IPocketUpgrade upgrade = this.getUpgrade(stack);
                if (upgrade != null) {
                    computer.updateValues((Entity)player, stack, upgrade);
                    stop = upgrade.onRightClick(world, computer, computer.getPeripheral(2));
                }
            }
            if (!stop) {
                ComputerCraft.openPocketComputerGUI(player, hand);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @Nonnull
    public String func_77667_c(@Nonnull ItemStack stack) {
        switch (this.getFamily(stack)) {
            default: {
                return "item.computercraft:pocket_computer";
            }
            case Advanced: 
        }
        return "item.computercraft:advanced_pocket_computer";
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        String baseString = this.func_77667_c(stack);
        IPocketUpgrade upgrade = this.getUpgrade(stack);
        if (upgrade != null) {
            return StringUtil.translateToLocalFormatted(baseString + ".upgraded.name", StringUtil.translateToLocal(upgrade.getUnlocalisedAdjective()));
        }
        return StringUtil.translateToLocal(baseString + ".name");
    }

    public void func_77624_a(@Nonnull ItemStack stack, EntityPlayer player, List<String> list, boolean debug) {
        int id;
        if (debug && (id = this.getComputerID(stack)) >= 0) {
            list.add("(Computer ID: " + id + ")");
        }
    }

    private PocketServerComputer createServerComputer(World world, IInventory inventory, Entity entity, @Nonnull ItemStack stack) {
        PocketServerComputer computer;
        if (world.field_72995_K) {
            return null;
        }
        int instanceID = this.getInstanceID(stack);
        int sessionID = this.getSessionID(stack);
        int correctSessionID = ComputerCraft.serverComputerRegistry.getSessionID();
        if (instanceID >= 0 && sessionID == correctSessionID && ComputerCraft.serverComputerRegistry.contains(instanceID)) {
            computer = (PocketServerComputer)ComputerCraft.serverComputerRegistry.get(instanceID);
        } else {
            int computerID;
            if (instanceID < 0 || sessionID != correctSessionID) {
                instanceID = ComputerCraft.serverComputerRegistry.getUnusedInstanceID();
                this.setInstanceID(stack, instanceID);
                this.setSessionID(stack, correctSessionID);
            }
            if ((computerID = this.getComputerID(stack)) < 0) {
                computerID = ComputerCraft.createUniqueNumberedSaveDir(world, "computer");
                this.setComputerID(stack, computerID);
            }
            computer = new PocketServerComputer(world, computerID, this.getLabel(stack), instanceID, this.getFamily(stack));
            computer.updateValues(entity, stack, this.getUpgrade(stack));
            computer.addAPI(new PocketAPI(computer));
            ComputerCraft.serverComputerRegistry.add(instanceID, computer);
            if (inventory != null) {
                inventory.func_70296_d();
            }
        }
        computer.setWorld(world);
        return computer;
    }

    public ServerComputer getServerComputer(@Nonnull ItemStack stack) {
        int instanceID = this.getInstanceID(stack);
        if (instanceID >= 0) {
            return (ServerComputer)ComputerCraft.serverComputerRegistry.get(instanceID);
        }
        return null;
    }

    public ClientComputer createClientComputer(@Nonnull ItemStack stack) {
        int instanceID = this.getInstanceID(stack);
        if (instanceID >= 0) {
            if (!ComputerCraft.clientComputerRegistry.contains(instanceID)) {
                ComputerCraft.clientComputerRegistry.add(instanceID, new ClientComputer(instanceID));
            }
            return (ClientComputer)ComputerCraft.clientComputerRegistry.get(instanceID);
        }
        return null;
    }

    private ClientComputer getClientComputer(@Nonnull ItemStack stack) {
        int instanceID = this.getInstanceID(stack);
        if (instanceID >= 0) {
            return (ClientComputer)ComputerCraft.clientComputerRegistry.get(instanceID);
        }
        return null;
    }

    @Override
    public int getComputerID(@Nonnull ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && compound.func_74764_b("computerID")) {
            return compound.func_74762_e("computerID");
        }
        return -1;
    }

    private void setComputerID(@Nonnull ItemStack stack, int computerID) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("computerID", computerID);
    }

    @Override
    public String getLabel(@Nonnull ItemStack stack) {
        if (stack.func_82837_s()) {
            return stack.func_82833_r();
        }
        return null;
    }

    @Override
    public ComputerFamily getFamily(@Nonnull ItemStack stack) {
        int damage = stack.func_77952_i();
        switch (damage) {
            default: {
                return ComputerFamily.Normal;
            }
            case 1: 
        }
        return ComputerFamily.Advanced;
    }

    @Override
    public boolean setLabel(@Nonnull ItemStack stack, String label) {
        if (label != null) {
            stack.func_151001_c(label);
        } else {
            stack.func_135074_t();
        }
        return true;
    }

    @Override
    public String getAudioTitle(@Nonnull ItemStack stack) {
        return null;
    }

    @Override
    public SoundEvent getAudio(@Nonnull ItemStack stack) {
        return null;
    }

    @Override
    public IMount createDataMount(@Nonnull ItemStack stack, @Nonnull World world) {
        PocketServerComputer computer = this.createServerComputer(world, null, null, stack);
        if (computer != null) {
            return computer.getRootMount();
        }
        return null;
    }

    private int getInstanceID(@Nonnull ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && compound.func_74764_b("instanceID")) {
            return compound.func_74762_e("instanceID");
        }
        return -1;
    }

    private void setInstanceID(@Nonnull ItemStack stack, int instanceID) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("instanceID", instanceID);
    }

    private int getSessionID(@Nonnull ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && compound.func_74764_b("sessionID")) {
            return compound.func_74762_e("sessionID");
        }
        return -1;
    }

    private void setSessionID(@Nonnull ItemStack stack, int sessionID) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("sessionID", sessionID);
    }

    @SideOnly(value=Side.CLIENT)
    public ComputerState getState(@Nonnull ItemStack stack) {
        ClientComputer computer = this.getClientComputer(stack);
        if (computer != null && computer.isOn()) {
            return computer.isCursorDisplayed() ? ComputerState.Blinking : ComputerState.On;
        }
        return ComputerState.Off;
    }

    @SideOnly(value=Side.CLIENT)
    public int getLightState(@Nonnull ItemStack stack) {
        NBTTagCompound computerNBT;
        ClientComputer computer = this.getClientComputer(stack);
        if (computer != null && computer.isOn() && (computerNBT = computer.getUserData()) != null && computerNBT.func_150297_b("modemLight", 99)) {
            return computerNBT.func_74762_e("modemLight");
        }
        return -1;
    }

    public IPocketUpgrade getUpgrade(@Nonnull ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            int id;
            if (compound.func_150297_b("upgrade", 8)) {
                String name = compound.func_74779_i("upgrade");
                return ComputerCraft.getPocketUpgrade(name);
            }
            if (compound.func_150297_b("upgrade", 99) && (id = compound.func_74762_e("upgrade")) == 1) {
                return ComputerCraft.getPocketUpgrade("computercraft:wireless_modem");
            }
        }
        return null;
    }

    public void setUpgrade(@Nonnull ItemStack stack, IPocketUpgrade upgrade) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            stack.func_77982_d(compound);
        }
        if (upgrade == null) {
            compound.func_82580_o("upgrade");
        } else {
            compound.func_74778_a("upgrade", upgrade.getUpgradeID().toString());
        }
        compound.func_82580_o("upgrade_info");
    }

    public NBTTagCompound getUpgradeInfo(@Nonnull ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        if (tag.func_150297_b("upgrade_info", 10)) {
            return tag.func_74775_l("upgrade_info");
        }
        NBTTagCompound sub = new NBTTagCompound();
        tag.func_74782_a("upgrade_info", (NBTBase)sub);
        return sub;
    }

    @Override
    public int getColour(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null && tag.func_150297_b("colour", 99) ? tag.func_74762_e("colour") : -1;
    }

    @Override
    public ItemStack setColour(ItemStack stack, int colour) {
        ItemStack copy = stack.func_77946_l();
        this.setColourDirect(copy, colour);
        return copy;
    }

    public void setColourDirect(ItemStack stack, int colour) {
        NBTTagCompound tag = stack.func_77978_p();
        if (colour == -1) {
            if (tag != null) {
                tag.func_82580_o("colour");
            }
        } else {
            if (tag == null) {
                tag = new NBTTagCompound();
                stack.func_77982_d(tag);
            }
            tag.func_74768_a("colour", colour);
        }
    }
}

