/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.apis;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.ILuaTask;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.core.apis.ILuaAPI;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class PocketAPI
implements ILuaAPI {
    private final PocketServerComputer m_computer;

    public PocketAPI(PocketServerComputer computer) {
        this.m_computer = computer;
    }

    @Override
    public String[] getNames() {
        return new String[]{"pocket"};
    }

    @Override
    public void startup() {
    }

    @Override
    public void advance(double dt) {
    }

    @Override
    public void shutdown() {
    }

    @Override
    @Nonnull
    public String[] getMethodNames() {
        return new String[]{"equipBack", "unequipBack"};
    }

    @Override
    public Object[] callMethod(@Nonnull ILuaContext context, int method, @Nonnull Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                return context.executeMainThreadTask(new ILuaTask(){

                    @Override
                    public Object[] execute() throws LuaException {
                        ItemStack stack;
                        if (!(PocketAPI.this.m_computer.getEntity() instanceof EntityPlayer)) {
                            throw new LuaException("Cannot find player");
                        }
                        EntityPlayer player = (EntityPlayer)PocketAPI.this.m_computer.getEntity();
                        InventoryPlayer inventory = player.field_71071_by;
                        IPocketUpgrade previousUpgrade = PocketAPI.this.m_computer.getUpgrade();
                        IPocketUpgrade newUpgrade = PocketAPI.findUpgrade((NonNullList<ItemStack>)inventory.field_70462_a, inventory.field_70461_c, previousUpgrade);
                        if (newUpgrade == null) {
                            newUpgrade = PocketAPI.findUpgrade((NonNullList<ItemStack>)inventory.field_184439_c, 0, previousUpgrade);
                        }
                        if (newUpgrade == null) {
                            throw new LuaException("Cannot find a valid upgrade");
                        }
                        if (previousUpgrade != null && !(stack = previousUpgrade.getCraftingItem()).func_190926_b() && !(stack = InventoryUtil.storeItems(stack, (IItemHandler)new PlayerMainInvWrapper(inventory), inventory.field_70461_c)).func_190926_b()) {
                            WorldUtil.dropItemStack(stack, player.func_130014_f_(), player.field_70165_t, player.field_70163_u, player.field_70161_v);
                        }
                        PocketAPI.this.m_computer.setUpgrade(newUpgrade);
                        return null;
                    }
                });
            }
            case 1: {
                return context.executeMainThreadTask(new ILuaTask(){

                    @Override
                    public Object[] execute() throws LuaException {
                        if (!(PocketAPI.this.m_computer.getEntity() instanceof EntityPlayer)) {
                            throw new LuaException("Cannot find player");
                        }
                        EntityPlayer player = (EntityPlayer)PocketAPI.this.m_computer.getEntity();
                        InventoryPlayer inventory = player.field_71071_by;
                        IPocketUpgrade previousUpgrade = PocketAPI.this.m_computer.getUpgrade();
                        if (previousUpgrade == null) {
                            throw new LuaException("Nothing to unequip");
                        }
                        PocketAPI.this.m_computer.setUpgrade(null);
                        ItemStack stack = previousUpgrade.getCraftingItem();
                        if (!stack.func_190926_b() && (stack = InventoryUtil.storeItems(stack, (IItemHandler)new PlayerMainInvWrapper(inventory), inventory.field_70461_c)).func_190926_b()) {
                            WorldUtil.dropItemStack(stack, player.func_130014_f_(), player.field_70165_t, player.field_70163_u, player.field_70161_v);
                        }
                        return null;
                    }
                });
            }
        }
        return null;
    }

    private static IPocketUpgrade findUpgrade(NonNullList<ItemStack> inv, int start, IPocketUpgrade previous) {
        for (int i = 0; i < inv.size(); ++i) {
            IPocketUpgrade newUpgrade;
            ItemStack invStack = (ItemStack)inv.get((i + start) % inv.size());
            if (invStack.func_190926_b() || (newUpgrade = ComputerCraft.getPocketUpgrade(invStack)) == null || newUpgrade == previous) continue;
            invStack = invStack.func_77946_l();
            invStack.func_190918_g(1);
            inv.set((i + start) % inv.size(), (Object)(invStack.func_190926_b() ? ItemStack.field_190927_a : invStack));
            return newUpgrade;
        }
        return null;
    }
}

