/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.speaker;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.ILuaTask;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.apis.ArgumentHelper;
import dan200.computercraft.shared.peripheral.speaker.TileSpeaker;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpeakerPeripheral
implements IPeripheral {
    private TileSpeaker m_speaker;
    private long m_clock = 0L;
    private long m_lastPlayTime = 0L;
    private int m_notesThisTick = 0;

    public SpeakerPeripheral() {
    }

    SpeakerPeripheral(TileSpeaker speaker) {
        this();
        this.m_speaker = speaker;
    }

    public synchronized void update() {
        ++this.m_clock;
        this.m_notesThisTick = 0;
    }

    public World getWorld() {
        return this.m_speaker.func_145831_w();
    }

    public BlockPos getPos() {
        return this.m_speaker.func_174877_v();
    }

    @Override
    public boolean equals(IPeripheral other) {
        if (other != null && other instanceof SpeakerPeripheral) {
            SpeakerPeripheral otherSpeaker = (SpeakerPeripheral)other;
            return otherSpeaker.m_speaker == this.m_speaker;
        }
        return false;
    }

    @Override
    public void attach(@Nonnull IComputerAccess computerAccess) {
    }

    @Override
    public void detach(@Nonnull IComputerAccess computerAccess) {
    }

    @Override
    @Nonnull
    public String getType() {
        return "speaker";
    }

    @Override
    @Nonnull
    public String[] getMethodNames() {
        return new String[]{"playSound", "playNote"};
    }

    @Override
    public Object[] callMethod(@Nonnull IComputerAccess computerAccess, @Nonnull ILuaContext context, int methodIndex, @Nonnull Object[] args) throws LuaException {
        switch (methodIndex) {
            case 0: {
                return this.playSound(args, context, false);
            }
            case 1: {
                return this.playNote(args, context);
            }
        }
        throw new LuaException("Method index out of range!");
    }

    @Nonnull
    private synchronized Object[] playNote(Object[] arguments, ILuaContext context) throws LuaException {
        String name = ArgumentHelper.getString(arguments, 0);
        float volume = (float)ArgumentHelper.optReal(arguments, 1, 1.0);
        float pitch = (float)ArgumentHelper.optReal(arguments, 2, 1.0);
        if (!SoundEvent.field_187505_a.func_148741_d((Object)new ResourceLocation("block.note." + name))) {
            throw new LuaException("Invalid instrument, \"" + arguments[0] + "\"!");
        }
        Object[] returnValue = this.playSound(new Object[]{"block.note." + name, (double)Math.min(volume, 3.0f), Math.pow(2.0, (pitch - 12.0f) / 12.0f)}, context, true);
        if (returnValue[0] instanceof Boolean && ((Boolean)returnValue[0]).booleanValue()) {
            ++this.m_notesThisTick;
        }
        return returnValue;
    }

    @Nonnull
    private synchronized Object[] playSound(Object[] arguments, ILuaContext context, boolean isNote) throws LuaException {
        String name = ArgumentHelper.getString(arguments, 0);
        float volume = (float)ArgumentHelper.optReal(arguments, 1, 1.0);
        float pitch = (float)ArgumentHelper.optReal(arguments, 2, 1.0);
        ResourceLocation resourceName = new ResourceLocation(name);
        if (this.m_clock - this.m_lastPlayTime >= 1L || this.m_clock - this.m_lastPlayTime == 0L && this.m_notesThisTick < ComputerCraft.maxNotesPerTick && isNote) {
            if (SoundEvent.field_187505_a.func_148741_d((Object)resourceName)) {
                final World world = this.getWorld();
                final BlockPos pos = this.getPos();
                final ResourceLocation resource = resourceName;
                final float vol = volume;
                final float soundPitch = pitch;
                context.issueMainThreadTask(new ILuaTask(){

                    @Override
                    @Nullable
                    public Object[] execute() throws LuaException {
                        world.func_184133_a(null, pos, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)resource), SoundCategory.RECORDS, Math.min(vol, 3.0f), soundPitch);
                        return null;
                    }
                });
                this.m_lastPlayTime = this.m_clock;
                return new Object[]{true};
            }
            return new Object[]{false};
        }
        return new Object[]{false};
    }
}

