/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.printer;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.media.items.ItemPrintout;
import dan200.computercraft.shared.peripheral.PeripheralType;
import dan200.computercraft.shared.peripheral.common.TilePeripheralBase;
import dan200.computercraft.shared.peripheral.printer.PrinterPeripheral;
import dan200.computercraft.shared.util.InventoryUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TilePrinter
extends TilePeripheralBase
implements IInventory,
ISidedInventory {
    private static final int[] bottomSlots = new int[]{7, 8, 9, 10, 11, 12};
    private static final int[] topSlots = new int[]{1, 2, 3, 4, 5, 6};
    private static final int[] sideSlots = new int[]{0};
    private final NonNullList<ItemStack> m_inventory;
    private final IItemHandlerModifiable m_itemHandlerAll = new InvWrapper((IInventory)this);
    private IItemHandlerModifiable[] m_itemHandlerSides;
    private final Terminal m_page;
    private String m_pageTitle = "";
    private boolean m_printing = false;

    public TilePrinter() {
        this.m_inventory = NonNullList.func_191197_a((int)13, (Object)ItemStack.field_190927_a);
        this.m_page = new Terminal(25, 21);
    }

    @Override
    public void destroy() {
        this.ejectContents();
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            if (!this.func_145831_w().field_72995_K) {
                ComputerCraft.openPrinterGUI(player, this);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NonNullList<ItemStack> nonNullList = this.m_page;
        synchronized (nonNullList) {
            this.m_printing = nbttagcompound.func_74767_n("printing");
            this.m_pageTitle = nbttagcompound.func_74779_i("pageTitle");
            this.m_page.readFromNBT(nbttagcompound);
        }
        nonNullList = this.m_inventory;
        synchronized (nonNullList) {
            NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound itemTag = nbttaglist.func_150305_b(i);
                int j = itemTag.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= this.m_inventory.size()) continue;
                this.m_inventory.set(j, (Object)new ItemStack(itemTag));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        NonNullList<ItemStack> nonNullList = this.m_page;
        synchronized (nonNullList) {
            nbttagcompound.func_74757_a("printing", this.m_printing);
            nbttagcompound.func_74778_a("pageTitle", this.m_pageTitle);
            this.m_page.writeToNBT(nbttagcompound);
        }
        nonNullList = this.m_inventory;
        synchronized (nonNullList) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.m_inventory.size(); ++i) {
                if (((ItemStack)this.m_inventory.get(i)).func_190926_b()) continue;
                NBTTagCompound itemtag = new NBTTagCompound();
                itemtag.func_74774_a("Slot", (byte)i);
                ((ItemStack)this.m_inventory.get(i)).func_77955_b(itemtag);
                nbttaglist.func_74742_a((NBTBase)itemtag);
            }
            nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
        return nbttagcompound;
    }

    @Override
    public final void readDescription(@Nonnull NBTTagCompound nbttagcompound) {
        super.readDescription(nbttagcompound);
        this.updateBlock();
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
        return super.shouldRefresh(world, pos, oldState, newState) || ComputerCraft.Blocks.peripheral.getPeripheralType(newState) != PeripheralType.Printer;
    }

    public boolean isPrinting() {
        return this.m_printing;
    }

    public int func_70302_i_() {
        return this.m_inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.m_inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ItemStack func_70301_a(int i) {
        NonNullList<ItemStack> nonNullList = this.m_inventory;
        synchronized (nonNullList) {
            return (ItemStack)this.m_inventory.get(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ItemStack func_70304_b(int i) {
        NonNullList<ItemStack> nonNullList = this.m_inventory;
        synchronized (nonNullList) {
            ItemStack result = (ItemStack)this.m_inventory.get(i);
            this.m_inventory.set(i, (Object)ItemStack.field_190927_a);
            this.updateAnim();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ItemStack func_70298_a(int i, int j) {
        NonNullList<ItemStack> nonNullList = this.m_inventory;
        synchronized (nonNullList) {
            if (((ItemStack)this.m_inventory.get(i)).func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (((ItemStack)this.m_inventory.get(i)).func_190916_E() <= j) {
                ItemStack itemstack = (ItemStack)this.m_inventory.get(i);
                this.m_inventory.set(i, (Object)ItemStack.field_190927_a);
                this.func_70296_d();
                this.updateAnim();
                return itemstack;
            }
            ItemStack part = ((ItemStack)this.m_inventory.get(i)).func_77979_a(j);
            if (((ItemStack)this.m_inventory.get(i)).func_190926_b()) {
                this.m_inventory.set(i, (Object)ItemStack.field_190927_a);
                this.updateAnim();
            }
            this.func_70296_d();
            return part;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_70299_a(int i, @Nonnull ItemStack stack) {
        NonNullList<ItemStack> nonNullList = this.m_inventory;
        synchronized (nonNullList) {
            this.m_inventory.set(i, (Object)stack);
            this.func_70296_d();
            this.updateAnim();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_174888_l() {
        NonNullList<ItemStack> nonNullList = this.m_inventory;
        synchronized (nonNullList) {
            for (int i = 0; i < this.m_inventory.size(); ++i) {
                this.m_inventory.set(i, (Object)ItemStack.field_190927_a);
            }
            this.func_70296_d();
            this.updateAnim();
        }
    }

    public boolean func_145818_k_() {
        return this.getLabel() != null;
    }

    @Nonnull
    public String func_70005_c_() {
        String label = this.getLabel();
        if (label != null) {
            return label;
        }
        return "tile.computercraft:printer.name";
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        if (this.func_145818_k_()) {
            return new TextComponentString(this.func_70005_c_());
        }
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack itemstack) {
        return true;
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return this.isUsable(player, false);
    }

    public int func_174890_g() {
        return 0;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        switch (side) {
            case DOWN: {
                return bottomSlots;
            }
            case UP: {
                return topSlots;
            }
        }
        return sideSlots;
    }

    public boolean func_180462_a(int slot, @Nonnull ItemStack itemstack, @Nonnull EnumFacing face) {
        return this.func_94041_b(slot, itemstack);
    }

    public boolean func_180461_b(int slot, @Nonnull ItemStack itemstack, @Nonnull EnumFacing face) {
        return true;
    }

    @Override
    public IPeripheral getPeripheral(EnumFacing side) {
        return new PrinterPeripheral(this);
    }

    public Terminal getCurrentPage() {
        if (this.m_printing) {
            return this.m_page;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startNewPage() {
        NonNullList<ItemStack> nonNullList = this.m_inventory;
        synchronized (nonNullList) {
            if (this.canInputPage()) {
                if (this.m_printing && !this.outputPage()) {
                    return false;
                }
                if (this.inputPage()) {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean endCurrentPage() {
        NonNullList<ItemStack> nonNullList = this.m_inventory;
        synchronized (nonNullList) {
            if (this.m_printing && this.outputPage()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInkLevel() {
        NonNullList<ItemStack> nonNullList = this.m_inventory;
        synchronized (nonNullList) {
            ItemStack inkStack = (ItemStack)this.m_inventory.get(0);
            if (!inkStack.func_190926_b() && this.isInk(inkStack)) {
                return inkStack.func_190916_E();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPaperLevel() {
        int count = 0;
        NonNullList<ItemStack> nonNullList = this.m_inventory;
        synchronized (nonNullList) {
            for (int i = 1; i < 7; ++i) {
                ItemStack paperStack = (ItemStack)this.m_inventory.get(i);
                if (paperStack.func_190926_b() || !this.isPaper(paperStack)) continue;
                count += paperStack.func_190916_E();
            }
        }
        return count;
    }

    public void setPageTitle(String title) {
        if (this.m_printing) {
            this.m_pageTitle = title;
        }
    }

    private boolean isInk(@Nonnull ItemStack stack) {
        return stack.func_77973_b() == Items.field_151100_aR;
    }

    private boolean isPaper(@Nonnull ItemStack stack) {
        Item item = stack.func_77973_b();
        return item == Items.field_151121_aF || item instanceof ItemPrintout && ItemPrintout.getType(stack) == ItemPrintout.Type.Single;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canInputPage() {
        NonNullList<ItemStack> nonNullList = this.m_inventory;
        synchronized (nonNullList) {
            ItemStack inkStack = (ItemStack)this.m_inventory.get(0);
            return !inkStack.func_190926_b() && this.isInk(inkStack) && this.getPaperLevel() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean inputPage() {
        NonNullList<ItemStack> nonNullList = this.m_inventory;
        synchronized (nonNullList) {
            ItemStack inkStack = (ItemStack)this.m_inventory.get(0);
            if (inkStack.func_190926_b() || !this.isInk(inkStack)) {
                return false;
            }
            for (int i = 1; i < 7; ++i) {
                int colour;
                ItemStack paperStack = (ItemStack)this.m_inventory.get(i);
                if (paperStack.func_190926_b() || !this.isPaper(paperStack)) continue;
                inkStack.func_190918_g(1);
                if (inkStack.func_190926_b()) {
                    this.m_inventory.set(0, (Object)ItemStack.field_190927_a);
                }
                paperStack.func_190918_g(1);
                if (paperStack.func_190926_b()) {
                    this.m_inventory.set(i, (Object)ItemStack.field_190927_a);
                    this.updateAnim();
                }
                if ((colour = inkStack.func_77952_i()) >= 0 && colour < 16) {
                    this.m_page.setTextColour(15 - colour);
                } else {
                    this.m_page.setTextColour(15);
                }
                this.m_page.clear();
                if (paperStack.func_77973_b() instanceof ItemPrintout) {
                    this.m_pageTitle = ItemPrintout.getTitle(paperStack);
                    String[] text = ItemPrintout.getText(paperStack);
                    String[] textColour = ItemPrintout.getColours(paperStack);
                    for (int y = 0; y < this.m_page.getHeight(); ++y) {
                        this.m_page.setLine(y, text[y], textColour[y], "");
                    }
                } else {
                    this.m_pageTitle = "";
                }
                this.m_page.setCursorPos(0, 0);
                this.func_70296_d();
                this.m_printing = true;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean outputPage() {
        Terminal terminal = this.m_page;
        synchronized (terminal) {
            int height = this.m_page.getHeight();
            String[] lines = new String[height];
            String[] colours = new String[height];
            for (int i = 0; i < height; ++i) {
                lines[i] = this.m_page.getLine(i).toString();
                colours[i] = this.m_page.getTextColourLine(i).toString();
            }
            ItemStack stack = ItemPrintout.createSingleFromTitleAndText(this.m_pageTitle, lines, colours);
            NonNullList<ItemStack> nonNullList = this.m_inventory;
            synchronized (nonNullList) {
                ItemStack remainder = InventoryUtil.storeItems(stack, (IItemHandler)this.m_itemHandlerAll, 7, 6, 7);
                if (remainder.func_190926_b()) {
                    this.m_printing = false;
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ejectContents() {
        NonNullList<ItemStack> nonNullList = this.m_inventory;
        synchronized (nonNullList) {
            for (int i = 0; i < 13; ++i) {
                ItemStack stack = (ItemStack)this.m_inventory.get(i);
                if (stack.func_190926_b()) continue;
                this.func_70299_a(i, ItemStack.field_190927_a);
                BlockPos pos = this.func_174877_v();
                double x = (double)pos.func_177958_n() + 0.5;
                double y = (double)pos.func_177956_o() + 0.75;
                double z = (double)pos.func_177952_p() + 0.5;
                EntityItem entityitem = new EntityItem(this.func_145831_w(), x, y, z, stack);
                entityitem.field_70159_w = (double)this.func_145831_w().field_73012_v.nextFloat() * 0.2 - 0.1;
                entityitem.field_70181_x = (double)this.func_145831_w().field_73012_v.nextFloat() * 0.2 - 0.1;
                entityitem.field_70179_y = (double)this.func_145831_w().field_73012_v.nextFloat() * 0.2 - 0.1;
                this.func_145831_w().func_72838_d((Entity)entityitem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAnim() {
        NonNullList<ItemStack> nonNullList = this.m_inventory;
        synchronized (nonNullList) {
            ItemStack stack;
            int i;
            int anim = 0;
            for (i = 1; i < 7; ++i) {
                stack = (ItemStack)this.m_inventory.get(i);
                if (stack.func_190926_b() || !this.isPaper(stack)) continue;
                ++anim;
                break;
            }
            for (i = 7; i < 13; ++i) {
                stack = (ItemStack)this.m_inventory.get(i);
                if (stack.func_190926_b() || !this.isPaper(stack)) continue;
                anim += 2;
                break;
            }
            this.setAnim(anim);
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            int i;
            IItemHandlerModifiable handler;
            if (facing == null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.m_itemHandlerAll);
            }
            IItemHandlerModifiable[] handlers = this.m_itemHandlerSides;
            if (handlers == null) {
                handlers = this.m_itemHandlerSides = new IItemHandlerModifiable[6];
            }
            if ((handler = handlers[i = facing.ordinal()]) == null) {
                handler = handlers[i] = new SidedInvWrapper((ISidedInventory)this, facing);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)handler);
        }
        return (T)super.getCapability(capability, facing);
    }
}

