/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.common.ClientTerminal;
import dan200.computercraft.shared.common.ITerminal;
import dan200.computercraft.shared.common.ITerminalTile;
import dan200.computercraft.shared.common.ServerTerminal;
import dan200.computercraft.shared.peripheral.PeripheralType;
import dan200.computercraft.shared.peripheral.common.TilePeripheralBase;
import dan200.computercraft.shared.peripheral.monitor.MonitorPeripheral;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileMonitor
extends TilePeripheralBase
implements ITerminalTile {
    public static final double RENDER_BORDER = 0.125;
    public static final double RENDER_MARGIN = 0.03125;
    public static final double RENDER_PIXEL_SCALE = 0.015625;
    private static final int MAX_WIDTH = 8;
    private static final int MAX_HEIGHT = 6;
    private ServerTerminal m_serverTerminal;
    private ClientTerminal m_clientTerminal;
    private final Set<IComputerAccess> m_computers = new HashSet<IComputerAccess>();
    public long m_lastRenderFrame = -1L;
    public int m_renderDisplayList = -1;
    private boolean m_destroyed = false;
    private boolean m_ignoreMe = false;
    private boolean m_changed = false;
    private int m_textScale = 2;
    private int m_width = 1;
    private int m_height = 1;
    private int m_xIndex = 0;
    private int m_yIndex = 0;
    private int m_dir = 2;
    private boolean m_sizeChangedQueued;

    @Override
    public void destroy() {
        if (!this.m_destroyed) {
            this.m_destroyed = true;
            if (!this.func_145831_w().field_72995_K) {
                this.contractNeighbours();
            }
        }
        if (this.m_renderDisplayList >= 0) {
            ComputerCraft.deleteDisplayLists(this.m_renderDisplayList, 3);
            this.m_renderDisplayList = -1;
        }
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af() && this.getFront() == side) {
            if (!this.func_145831_w().field_72995_K) {
                this.monitorTouched(hitX, hitY, hitZ);
            }
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("xIndex", this.m_xIndex);
        nbttagcompound.func_74768_a("yIndex", this.m_yIndex);
        nbttagcompound.func_74768_a("width", this.m_width);
        nbttagcompound.func_74768_a("height", this.m_height);
        nbttagcompound.func_74768_a("dir", this.m_dir);
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.m_xIndex = nbttagcompound.func_74762_e("xIndex");
        this.m_yIndex = nbttagcompound.func_74762_e("yIndex");
        this.m_width = nbttagcompound.func_74762_e("width");
        this.m_height = nbttagcompound.func_74762_e("height");
        this.m_dir = nbttagcompound.func_74762_e("dir");
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            if (this.m_sizeChangedQueued) {
                for (IComputerAccess computer : this.m_computers) {
                    computer.queueEvent("monitor_resize", new Object[]{computer.getAttachmentName()});
                }
                this.m_sizeChangedQueued = false;
            }
            if (this.m_serverTerminal != null) {
                this.m_serverTerminal.update();
                if (this.m_serverTerminal.hasTerminalChanged()) {
                    this.updateBlock();
                }
            }
            if (this.m_clientTerminal != null) {
                this.m_clientTerminal.update();
            }
        }
    }

    public boolean pollChanged() {
        if (this.m_changed) {
            this.m_changed = false;
            return true;
        }
        return false;
    }

    @Override
    public IPeripheral getPeripheral(EnumFacing side) {
        return new MonitorPeripheral(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextScale(int scale) {
        TileMonitor origin = this.getOrigin();
        if (origin != null) {
            TileMonitor tileMonitor = origin;
            synchronized (tileMonitor) {
                if (origin.m_textScale != scale) {
                    origin.m_textScale = scale;
                    origin.rebuildTerminal();
                    origin.updateBlock();
                }
            }
        }
    }

    @Override
    public void writeDescription(@Nonnull NBTTagCompound nbttagcompound) {
        super.writeDescription(nbttagcompound);
        nbttagcompound.func_74768_a("xIndex", this.m_xIndex);
        nbttagcompound.func_74768_a("yIndex", this.m_yIndex);
        nbttagcompound.func_74768_a("width", this.m_width);
        nbttagcompound.func_74768_a("height", this.m_height);
        nbttagcompound.func_74768_a("textScale", this.m_textScale);
        nbttagcompound.func_74768_a("monitorDir", this.m_dir);
        ((ServerTerminal)this.getLocalTerminal()).writeDescription(nbttagcompound);
    }

    @Override
    public final void readDescription(@Nonnull NBTTagCompound nbttagcompound) {
        super.readDescription(nbttagcompound);
        int oldXIndex = this.m_xIndex;
        int oldYIndex = this.m_yIndex;
        int oldWidth = this.m_width;
        int oldHeight = this.m_height;
        int oldTextScale = this.m_textScale;
        int oldDir = this.m_dir;
        this.m_xIndex = nbttagcompound.func_74762_e("xIndex");
        this.m_yIndex = nbttagcompound.func_74762_e("yIndex");
        this.m_width = nbttagcompound.func_74762_e("width");
        this.m_height = nbttagcompound.func_74762_e("height");
        this.m_textScale = nbttagcompound.func_74762_e("textScale");
        this.m_dir = nbttagcompound.func_74762_e("monitorDir");
        ((ClientTerminal)this.getLocalTerminal()).readDescription(nbttagcompound);
        this.m_changed = true;
        if (oldXIndex != this.m_xIndex || oldYIndex != this.m_yIndex || oldWidth != this.m_width || oldHeight != this.m_height || oldTextScale != this.m_textScale || oldDir != this.m_dir) {
            this.updateBlock();
        }
    }

    @Override
    public ITerminal getTerminal() {
        TileMonitor origin = this.getOrigin();
        if (origin != null) {
            return origin.getLocalTerminal();
        }
        return null;
    }

    private ITerminal getLocalTerminal() {
        if (!this.func_145831_w().field_72995_K) {
            if (this.m_serverTerminal == null) {
                this.m_serverTerminal = new ServerTerminal(this.getPeripheralType() == PeripheralType.AdvancedMonitor);
            }
            return this.m_serverTerminal;
        }
        if (this.m_clientTerminal == null) {
            this.m_clientTerminal = new ClientTerminal(this.getPeripheralType() == PeripheralType.AdvancedMonitor);
        }
        return this.m_clientTerminal;
    }

    public double getTextScale() {
        return (double)this.m_textScale * 0.5;
    }

    private void rebuildTerminal() {
        Terminal oldTerm = this.getTerminal().getTerminal();
        int oldWidth = oldTerm != null ? oldTerm.getWidth() : -1;
        int oldHeight = oldTerm != null ? oldTerm.getHeight() : -1;
        double textScale = this.getTextScale();
        int termWidth = (int)Math.max((double)Math.round(((double)this.m_width - 0.3125) / (textScale * 6.0 * 0.015625)), 1.0);
        int termHeight = (int)Math.max((double)Math.round(((double)this.m_height - 0.3125) / (textScale * 9.0 * 0.015625)), 1.0);
        ((ServerTerminal)this.getLocalTerminal()).resize(termWidth, termHeight);
        if (oldWidth != termWidth || oldHeight != termHeight) {
            this.getLocalTerminal().getTerminal().clear();
            for (int y = 0; y < this.m_height; ++y) {
                for (int x = 0; x < this.m_width; ++x) {
                    TileMonitor monitor = this.getNeighbour(x, y);
                    if (monitor == null) continue;
                    monitor.queueSizeChangedEvent();
                }
            }
        }
    }

    private void destroyTerminal() {
        ((ServerTerminal)this.getLocalTerminal()).delete();
    }

    @Override
    public EnumFacing getDirection() {
        int dir = this.getDir() % 6;
        switch (dir) {
            case 2: {
                return EnumFacing.NORTH;
            }
            case 3: {
                return EnumFacing.SOUTH;
            }
            case 4: {
                return EnumFacing.WEST;
            }
            case 5: {
                return EnumFacing.EAST;
            }
        }
        return EnumFacing.NORTH;
    }

    public int getDir() {
        return this.m_dir;
    }

    public void setDir(int dir) {
        this.m_dir = dir;
        this.m_changed = true;
        this.func_70296_d();
    }

    public EnumFacing getFront() {
        return this.m_dir <= 5 ? EnumFacing.func_82600_a((int)this.m_dir) : (this.m_dir <= 11 ? EnumFacing.DOWN : EnumFacing.UP);
    }

    public EnumFacing getRight() {
        int dir = this.getDir() % 6;
        switch (dir) {
            case 2: {
                return EnumFacing.WEST;
            }
            case 3: {
                return EnumFacing.EAST;
            }
            case 4: {
                return EnumFacing.SOUTH;
            }
            case 5: {
                return EnumFacing.NORTH;
            }
        }
        return EnumFacing.WEST;
    }

    private EnumFacing getDown() {
        int dir = this.getDir();
        if (dir <= 5) {
            return EnumFacing.UP;
        }
        switch (dir) {
            case 8: {
                return EnumFacing.NORTH;
            }
            case 9: {
                return EnumFacing.SOUTH;
            }
            case 10: {
                return EnumFacing.WEST;
            }
            case 11: {
                return EnumFacing.EAST;
            }
            case 14: {
                return EnumFacing.SOUTH;
            }
            case 15: {
                return EnumFacing.NORTH;
            }
            case 16: {
                return EnumFacing.EAST;
            }
            case 17: {
                return EnumFacing.WEST;
            }
        }
        return EnumFacing.NORTH;
    }

    public int getWidth() {
        return this.m_width;
    }

    public int getHeight() {
        return this.m_height;
    }

    public int getXIndex() {
        return this.m_xIndex;
    }

    public int getYIndex() {
        return this.m_yIndex;
    }

    private TileMonitor getSimilarMonitorAt(BlockPos pos) {
        TileMonitor monitor;
        TileEntity tile;
        if (pos.equals((Object)this.func_174877_v())) {
            return this;
        }
        int y = pos.func_177956_o();
        World world = this.func_145831_w();
        if (world != null && y >= 0 && y < world.func_72800_K() && world.func_175667_e(pos) && (tile = world.func_175625_s(pos)) != null && tile instanceof TileMonitor && (monitor = (TileMonitor)tile).getDir() == this.getDir() && monitor.getLocalTerminal().isColour() == this.getLocalTerminal().isColour() && !monitor.m_destroyed && !monitor.m_ignoreMe) {
            return monitor;
        }
        return null;
    }

    private TileMonitor getNeighbour(int x, int y) {
        BlockPos pos = this.func_174877_v();
        EnumFacing right = this.getRight();
        EnumFacing down = this.getDown();
        int xOffset = -this.m_xIndex + x;
        int yOffset = -this.m_yIndex + y;
        return this.getSimilarMonitorAt(pos.func_177967_a(right, xOffset).func_177967_a(down, yOffset));
    }

    public TileMonitor getOrigin() {
        return this.getNeighbour(0, 0);
    }

    private void resize(int width, int height) {
        BlockPos pos = this.func_174877_v();
        EnumFacing right = this.getRight();
        EnumFacing down = this.getDown();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                TileMonitor monitor = this.getSimilarMonitorAt(pos.func_177967_a(right, x).func_177967_a(down, y));
                if (monitor == null) continue;
                monitor.m_xIndex = x;
                monitor.m_yIndex = y;
                monitor.m_width = width;
                monitor.m_height = height;
                monitor.updateBlock();
                if (x == 0 && y == 0) continue;
                monitor.destroyTerminal();
            }
        }
        this.rebuildTerminal();
    }

    private boolean mergeLeft() {
        int width;
        TileMonitor left = this.getNeighbour(-1, 0);
        if (left != null && left.m_yIndex == 0 && left.m_height == this.m_height && (width = left.m_width + this.m_width) <= 8) {
            TileMonitor origin = left.getOrigin();
            if (origin != null) {
                origin.resize(width, this.m_height);
            }
            left.expand();
            return true;
        }
        return false;
    }

    private boolean mergeRight() {
        int width;
        TileMonitor right = this.getNeighbour(this.m_width, 0);
        if (right != null && right.m_yIndex == 0 && right.m_height == this.m_height && (width = this.m_width + right.m_width) <= 8) {
            TileMonitor origin = this.getOrigin();
            if (origin != null) {
                origin.resize(width, this.m_height);
            }
            this.expand();
            return true;
        }
        return false;
    }

    private boolean mergeUp() {
        int height;
        TileMonitor above = this.getNeighbour(0, this.m_height);
        if (above != null && above.m_xIndex == 0 && above.m_width == this.m_width && (height = above.m_height + this.m_height) <= 6) {
            TileMonitor origin = this.getOrigin();
            if (origin != null) {
                origin.resize(this.m_width, height);
            }
            this.expand();
            return true;
        }
        return false;
    }

    private boolean mergeDown() {
        int height;
        TileMonitor below = this.getNeighbour(0, -1);
        if (below != null && below.m_xIndex == 0 && below.m_width == this.m_width && (height = this.m_height + below.m_height) <= 6) {
            TileMonitor origin = below.getOrigin();
            if (origin != null) {
                origin.resize(this.m_width, height);
            }
            below.expand();
            return true;
        }
        return false;
    }

    public void expand() {
        while (this.mergeLeft() || this.mergeRight() || this.mergeUp() || this.mergeDown()) {
        }
    }

    public void contractNeighbours() {
        TileMonitor above;
        TileMonitor below;
        TileMonitor right;
        TileMonitor left;
        this.m_ignoreMe = true;
        if (this.m_xIndex > 0 && (left = this.getNeighbour(this.m_xIndex - 1, this.m_yIndex)) != null) {
            left.contract();
        }
        if (this.m_xIndex + 1 < this.m_width && (right = this.getNeighbour(this.m_xIndex + 1, this.m_yIndex)) != null) {
            right.contract();
        }
        if (this.m_yIndex > 0 && (below = this.getNeighbour(this.m_xIndex, this.m_yIndex - 1)) != null) {
            below.contract();
        }
        if (this.m_yIndex + 1 < this.m_height && (above = this.getNeighbour(this.m_xIndex, this.m_yIndex + 1)) != null) {
            above.contract();
        }
        this.m_ignoreMe = false;
    }

    public void contract() {
        int height = this.m_height;
        int width = this.m_width;
        TileMonitor origin = this.getOrigin();
        if (origin == null) {
            TileMonitor right = null;
            TileMonitor below = null;
            if (width > 1) {
                right = this.getNeighbour(1, 0);
            }
            if (height > 1) {
                below = this.getNeighbour(0, 1);
            }
            if (right != null) {
                right.resize(width - 1, 1);
            }
            if (below != null) {
                below.resize(width, height - 1);
            }
            if (right != null) {
                right.expand();
            }
            if (below != null) {
                below.expand();
            }
            return;
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                TileMonitor monitor = origin.getNeighbour(x, y);
                if (monitor != null) continue;
                TileMonitor above = null;
                TileMonitor left = null;
                TileMonitor right = null;
                TileMonitor below = null;
                if (y > 0) {
                    above = origin;
                    above.resize(width, y);
                }
                if (x > 0) {
                    left = origin.getNeighbour(0, y);
                    left.resize(x, 1);
                }
                if (x + 1 < width) {
                    right = origin.getNeighbour(x + 1, y);
                    right.resize(width - (x + 1), 1);
                }
                if (y + 1 < height) {
                    below = origin.getNeighbour(0, y + 1);
                    below.resize(width, height - (y + 1));
                }
                if (above != null) {
                    above.expand();
                }
                if (left != null) {
                    left.expand();
                }
                if (right != null) {
                    right.expand();
                }
                if (below != null) {
                    below.expand();
                }
                return;
            }
        }
    }

    public void monitorTouched(float xPos, float yPos, float zPos) {
        int side = this.getDir();
        XYPair pair = this.convertToXY(xPos, yPos, zPos, side);
        pair = new XYPair(pair.x + (float)this.m_xIndex, pair.y + (float)this.m_height - (float)this.m_yIndex - 1.0f);
        if ((double)pair.x > (double)this.m_width - 0.125 || (double)pair.y > (double)this.m_height - 0.125 || (double)pair.x < 0.125 || (double)pair.y < 0.125) {
            return;
        }
        Terminal originTerminal = this.getTerminal().getTerminal();
        if (originTerminal == null) {
            return;
        }
        if (!this.getTerminal().isColour()) {
            return;
        }
        double xCharWidth = ((double)this.m_width - 0.3125) / (double)originTerminal.getWidth();
        double yCharHeight = ((double)this.m_height - 0.3125) / (double)originTerminal.getHeight();
        int xCharPos = (int)Math.min((double)originTerminal.getWidth(), Math.max(((double)pair.x - 0.125 - 0.03125) / xCharWidth + 1.0, 1.0));
        int yCharPos = (int)Math.min((double)originTerminal.getHeight(), Math.max(((double)pair.y - 0.125 - 0.03125) / yCharHeight + 1.0, 1.0));
        for (int y = 0; y < this.m_height; ++y) {
            for (int x = 0; x < this.m_width; ++x) {
                TileMonitor monitor = this.getNeighbour(x, y);
                if (monitor == null) continue;
                monitor.queueTouchEvent(xCharPos, yCharPos);
            }
        }
    }

    private void queueTouchEvent(int xCharPos, int yCharPos) {
        for (IComputerAccess computer : this.m_computers) {
            computer.queueEvent("monitor_touch", new Object[]{computer.getAttachmentName(), xCharPos, yCharPos});
        }
    }

    private void queueSizeChangedEvent() {
        this.m_sizeChangedQueued = true;
    }

    private XYPair convertToXY(float xPos, float yPos, float zPos, int side) {
        switch (side) {
            case 2: {
                return new XYPair(1.0f - xPos, 1.0f - yPos);
            }
            case 3: {
                return new XYPair(xPos, 1.0f - yPos);
            }
            case 4: {
                return new XYPair(zPos, 1.0f - yPos);
            }
            case 5: {
                return new XYPair(1.0f - zPos, 1.0f - yPos);
            }
            case 8: {
                return new XYPair(1.0f - xPos, zPos);
            }
            case 9: {
                return new XYPair(xPos, 1.0f - zPos);
            }
            case 10: {
                return new XYPair(zPos, xPos);
            }
            case 11: {
                return new XYPair(1.0f - zPos, 1.0f - xPos);
            }
            case 14: {
                return new XYPair(1.0f - xPos, 1.0f - zPos);
            }
            case 15: {
                return new XYPair(xPos, zPos);
            }
            case 16: {
                return new XYPair(zPos, 1.0f - xPos);
            }
            case 17: {
                return new XYPair(1.0f - zPos, xPos);
            }
        }
        return new XYPair(xPos, zPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComputer(IComputerAccess computer) {
        TileMonitor tileMonitor = this;
        synchronized (tileMonitor) {
            TileMonitor origin;
            if (this.m_computers.size() == 0 && (origin = this.getOrigin()) != null) {
                origin.rebuildTerminal();
            }
            if (!this.m_computers.contains(computer)) {
                this.m_computers.add(computer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeComputer(IComputerAccess computer) {
        TileMonitor tileMonitor = this;
        synchronized (tileMonitor) {
            if (this.m_computers.contains(computer)) {
                this.m_computers.remove(computer);
            }
        }
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        TileMonitor start = this.getNeighbour(0, 0);
        TileMonitor end = this.getNeighbour(this.m_width - 1, this.m_height - 1);
        if (start != null && end != null) {
            BlockPos startPos = start.func_174877_v();
            BlockPos endPos = end.func_174877_v();
            int minX = Math.min(startPos.func_177958_n(), endPos.func_177958_n());
            int minY = Math.min(startPos.func_177956_o(), endPos.func_177956_o());
            int minZ = Math.min(startPos.func_177952_p(), endPos.func_177952_p());
            int maxX = Math.max(startPos.func_177958_n(), endPos.func_177958_n()) + 1;
            int maxY = Math.max(startPos.func_177956_o(), endPos.func_177956_o()) + 1;
            int maxZ = Math.max(startPos.func_177952_p(), endPos.func_177952_p()) + 1;
            return new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        }
        BlockPos pos = this.func_174877_v();
        return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1));
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
        if (super.shouldRefresh(world, pos, oldState, newState)) {
            return true;
        }
        switch (ComputerCraft.Blocks.peripheral.getPeripheralType(newState)) {
            case Monitor: 
            case AdvancedMonitor: {
                return false;
            }
        }
        return true;
    }

    public static class XYPair {
        public final float x;
        public final float y;

        private XYPair(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }
}

