/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.common;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.common.IDirectionalTile;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.peripheral.PeripheralType;
import dan200.computercraft.shared.peripheral.common.BlockPeripheralBase;
import dan200.computercraft.shared.peripheral.common.IPeripheralTile;
import dan200.computercraft.shared.peripheral.common.PeripheralItemFactory;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public abstract class TilePeripheralBase
extends TileGeneric
implements IPeripheralTile,
IDirectionalTile,
ITickable {
    private EnumFacing m_dir = EnumFacing.NORTH;
    private int m_anim = 0;
    private boolean m_changed = false;
    private String m_label = null;

    @Override
    public BlockPeripheralBase getBlock() {
        return (BlockPeripheralBase)super.getBlock();
    }

    @Override
    public void getDroppedItems(@Nonnull List<ItemStack> drops, boolean creative) {
        if (!creative) {
            drops.add(PeripheralItemFactory.create(this));
        }
    }

    @Override
    public ItemStack getPickedItem() {
        return PeripheralItemFactory.create(this);
    }

    @Override
    public final PeripheralType getPeripheralType() {
        return this.getBlock().getPeripheralType(this.getBlockState());
    }

    @Override
    public IPeripheral getPeripheral(EnumFacing side) {
        return null;
    }

    @Override
    public String getLabel() {
        if (this.m_label != null && this.m_label.length() > 0) {
            return this.m_label;
        }
        return null;
    }

    public void setLabel(String label) {
        this.m_label = label;
    }

    @Override
    public EnumFacing getDirection() {
        return this.m_dir;
    }

    @Override
    public void setDirection(EnumFacing dir) {
        if (dir != this.m_dir) {
            this.m_dir = dir;
            this.m_changed = true;
        }
    }

    public synchronized int getAnim() {
        return this.m_anim;
    }

    public synchronized void setAnim(int anim) {
        if (anim != this.m_anim) {
            this.m_anim = anim;
            this.m_changed = true;
        }
    }

    public synchronized void func_73660_a() {
        if (this.m_changed) {
            this.updateBlock();
            this.m_changed = false;
        }
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("dir")) {
            this.m_dir = EnumFacing.func_82600_a((int)nbttagcompound.func_74762_e("dir"));
        }
        if (nbttagcompound.func_74764_b("anim")) {
            this.m_anim = nbttagcompound.func_74762_e("anim");
        }
        if (nbttagcompound.func_74764_b("label")) {
            this.m_label = nbttagcompound.func_74779_i("label");
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("dir", this.m_dir.func_176745_a());
        nbttagcompound.func_74768_a("anim", this.m_anim);
        if (this.m_label != null) {
            nbttagcompound.func_74778_a("label", this.m_label);
        }
        return nbttagcompound;
    }

    @Override
    public void readDescription(@Nonnull NBTTagCompound nbttagcompound) {
        super.readDescription(nbttagcompound);
        this.m_dir = EnumFacing.func_82600_a((int)nbttagcompound.func_74762_e("dir"));
        this.m_anim = nbttagcompound.func_74762_e("anim");
        this.m_label = nbttagcompound.func_74764_b("label") ? nbttagcompound.func_74779_i("label") : null;
    }

    @Override
    public void writeDescription(@Nonnull NBTTagCompound nbttagcompound) {
        super.writeDescription(nbttagcompound);
        nbttagcompound.func_74768_a("dir", this.m_dir.func_176745_a());
        nbttagcompound.func_74768_a("anim", this.m_anim);
        if (this.m_label != null) {
            nbttagcompound.func_74778_a("label", this.m_label);
        }
    }
}

