/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.common;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.shared.peripheral.PeripheralType;
import dan200.computercraft.shared.peripheral.common.BlockCable;
import dan200.computercraft.shared.peripheral.common.BlockCableModemVariant;
import dan200.computercraft.shared.peripheral.common.ItemPeripheralBase;
import dan200.computercraft.shared.peripheral.common.PeripheralItemFactory;
import dan200.computercraft.shared.peripheral.modem.TileCable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemCable
extends ItemPeripheralBase {
    public ItemCable(Block block) {
        super(block);
        this.func_77655_b("computercraft:cable");
        this.func_77637_a(ComputerCraft.mainCreativeTab);
    }

    @Nonnull
    public ItemStack create(PeripheralType type, String label, int quantity) {
        ItemStack stack;
        switch (type) {
            case Cable: {
                stack = new ItemStack((Item)this, quantity, 0);
                break;
            }
            case WiredModem: {
                stack = new ItemStack((Item)this, quantity, 1);
                break;
            }
            default: {
                return ItemStack.field_190927_a;
            }
        }
        if (label != null) {
            stack.func_151001_c(label);
        }
        return stack;
    }

    public void func_150895_a(@Nonnull Item itemID, @Nullable CreativeTabs tabs, @Nonnull NonNullList<ItemStack> list) {
        list.add((Object)PeripheralItemFactory.create(PeripheralType.WiredModem, null, 1));
        list.add((Object)PeripheralItemFactory.create(PeripheralType.Cable, null, 1));
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float fx, float fy, float fz) {
        PeripheralType existingType;
        ItemStack stack = player.func_184586_b(hand);
        if (!this.func_179222_a(world, pos, side, player, stack)) {
            return EnumActionResult.FAIL;
        }
        PeripheralType type = this.getPeripheralType(stack);
        Block existing = world.func_180495_p(pos).func_177230_c();
        IBlockState existingState = world.func_180495_p(pos);
        if (existing == ComputerCraft.Blocks.cable && (existingType = ComputerCraft.Blocks.cable.getPeripheralType((IBlockAccess)world, pos)) == PeripheralType.WiredModem && type == PeripheralType.Cable) {
            if (!stack.func_190926_b()) {
                IBlockState newState = existingState.func_177226_a((IProperty)BlockCable.Properties.CABLE, (Comparable)Boolean.valueOf(true));
                world.func_180501_a(pos, newState, 3);
                SoundType soundType = newState.func_177230_c().getSoundType(newState, world, pos, (Entity)player);
                world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
                stack.func_190918_g(1);
                TileEntity tile = world.func_175625_s(pos);
                if (tile != null && tile instanceof TileCable) {
                    TileCable cable = (TileCable)tile;
                    cable.networkChanged();
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        if (!existing.isAir(existingState, (IBlockAccess)world, pos) && (type == PeripheralType.Cable || existing.isSideSolid(existingState, (IBlockAccess)world, pos, side))) {
            BlockPos offset = pos.func_177972_a(side);
            Block offsetExisting = world.func_180495_p(offset).func_177230_c();
            IBlockState offsetExistingState = world.func_180495_p(offset);
            if (offsetExisting == ComputerCraft.Blocks.cable) {
                PeripheralType offsetExistingType = ComputerCraft.Blocks.cable.getPeripheralType((IBlockAccess)world, offset);
                if (offsetExistingType == PeripheralType.Cable && type == PeripheralType.WiredModem) {
                    if (!stack.func_190926_b()) {
                        IBlockState newState = offsetExistingState.func_177226_a(BlockCable.Properties.MODEM, (Comparable)((Object)BlockCableModemVariant.fromFacing(side.func_176734_d())));
                        world.func_180501_a(offset, newState, 3);
                        SoundType soundType = newState.func_177230_c().getSoundType(newState, world, offset, (Entity)player);
                        world.func_184148_a(null, (double)offset.func_177958_n() + 0.5, (double)offset.func_177956_o() + 0.5, (double)offset.func_177952_p() + 0.5, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
                        stack.func_190918_g(1);
                        TileEntity tile = world.func_175625_s(offset);
                        if (tile != null && tile instanceof TileCable) {
                            TileCable cable = (TileCable)tile;
                            cable.networkChanged();
                        }
                        return EnumActionResult.SUCCESS;
                    }
                    return EnumActionResult.FAIL;
                }
                if (offsetExistingType == PeripheralType.WiredModem && type == PeripheralType.Cable) {
                    if (!stack.func_190926_b()) {
                        IBlockState newState = offsetExistingState.func_177226_a((IProperty)BlockCable.Properties.CABLE, (Comparable)Boolean.valueOf(true));
                        world.func_180501_a(offset, newState, 3);
                        SoundType soundType = newState.func_177230_c().getSoundType(newState, world, offset, (Entity)player);
                        world.func_184148_a(null, (double)offset.func_177958_n() + 0.5, (double)offset.func_177956_o() + 0.5, (double)offset.func_177952_p() + 0.5, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
                        stack.func_190918_g(1);
                        TileEntity tile = world.func_175625_s(offset);
                        if (tile != null && tile instanceof TileCable) {
                            TileCable cable = (TileCable)tile;
                            cable.networkChanged();
                        }
                        return EnumActionResult.SUCCESS;
                    }
                    return EnumActionResult.FAIL;
                }
            }
        }
        return super.func_180614_a(player, world, pos, hand, side, fx, fy, fz);
    }

    @Override
    public PeripheralType getPeripheralType(int damage) {
        switch (damage) {
            default: {
                return PeripheralType.Cable;
            }
            case 1: 
        }
        return PeripheralType.WiredModem;
    }
}

