/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.items;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.core.filesystem.SubMount;
import dan200.computercraft.shared.util.Colour;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemTreasureDisk
extends Item
implements IMedia {
    public ItemTreasureDisk() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77655_b("computercraft:treasure_disk");
    }

    public void func_150895_a(@Nonnull Item itemID, CreativeTabs tabs, NonNullList<ItemStack> list) {
    }

    public void func_77624_a(@Nonnull ItemStack stack, EntityPlayer player, List<String> list, boolean bool) {
        String label = this.getTitle(stack);
        if (label != null && label.length() > 0) {
            list.add(label);
        }
    }

    public boolean doesSneakBypassUse(@Nonnull ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    @Override
    public String getLabel(@Nonnull ItemStack stack) {
        return this.getTitle(stack);
    }

    @Override
    public boolean setLabel(@Nonnull ItemStack stack, String label) {
        return false;
    }

    @Override
    public String getAudioTitle(@Nonnull ItemStack stack) {
        return null;
    }

    @Override
    public SoundEvent getAudio(@Nonnull ItemStack stack) {
        return null;
    }

    @Override
    public IMount createDataMount(@Nonnull ItemStack stack, @Nonnull World world) {
        IMount rootTreasure = ItemTreasureDisk.getTreasureMount();
        String subPath = this.getSubPath(stack);
        try {
            if (rootTreasure.exists(subPath)) {
                return new SubMount(rootTreasure, subPath);
            }
            if (rootTreasure.exists("deprecated/" + subPath)) {
                return new SubMount(rootTreasure, "deprecated/" + subPath);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static ItemStack create(String subPath, int colourIndex) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("subPath", subPath);
        int slash = subPath.indexOf("/");
        if (slash >= 0) {
            String author = subPath.substring(0, slash);
            String title = subPath.substring(slash + 1);
            nbt.func_74778_a("title", "\"" + title + "\" by " + author);
        } else {
            nbt.func_74778_a("title", "untitled");
        }
        nbt.func_74768_a("colour", Colour.values()[colourIndex].getHex());
        ItemStack result = new ItemStack((Item)ComputerCraft.Items.treasureDisk, 1, 0);
        result.func_77982_d(nbt);
        return result;
    }

    private static IMount getTreasureMount() {
        return ComputerCraft.createResourceMount(ComputerCraft.class, "computercraft", "lua/treasure");
    }

    public String getTitle(@Nonnull ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("title")) {
            return nbt.func_74779_i("title");
        }
        return "'alongtimeago' by dan200";
    }

    public String getSubPath(@Nonnull ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("subPath")) {
            return nbt.func_74779_i("subPath");
        }
        return "dan200/alongtimeago";
    }

    public int getColour(@Nonnull ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("colour")) {
            return nbt.func_74762_e("colour");
        }
        return Colour.Blue.getHex();
    }
}

