/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import dan200.computercraft.shared.common.BlockDirectional;
import dan200.computercraft.shared.computer.blocks.TileComputerBase;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.items.ItemComputerBase;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockComputerBase
extends BlockDirectional {
    public BlockComputerBase(Material material) {
        super(material);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.updateInput((IBlockAccess)world, pos);
    }

    @Override
    public void setDirection(World world, BlockPos pos, EnumFacing dir) {
        super.setDirection(world, pos, dir);
        this.updateInput((IBlockAccess)world, pos);
    }

    protected abstract IBlockState getDefaultBlockState(ComputerFamily var1, EnumFacing var2);

    protected abstract ComputerFamily getFamily(int var1);

    protected abstract ComputerFamily getFamily(IBlockState var1);

    protected abstract TileComputerBase createTile(ComputerFamily var1);

    @Override
    protected final IBlockState getDefaultBlockState(int damage, EnumFacing placedSide) {
        ItemComputerBase item = (ItemComputerBase)Item.func_150898_a((Block)this);
        return this.getDefaultBlockState(item.getFamily(damage), placedSide);
    }

    @Override
    public final TileComputerBase createTile(IBlockState state) {
        return this.createTile(this.getFamily(state));
    }

    @Override
    public final TileComputerBase createTile(int damage) {
        return this.createTile(this.getFamily(damage));
    }

    public final ComputerFamily getFamily(IBlockAccess world, BlockPos pos) {
        return this.getFamily(world.func_180495_p(pos));
    }

    protected void updateInput(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileComputerBase) {
            TileComputerBase computer = (TileComputerBase)tile;
            computer.updateInput();
        }
    }
}

