/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.computer;

import com.google.common.base.Objects;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.apis.BitAPI;
import dan200.computercraft.core.apis.FSAPI;
import dan200.computercraft.core.apis.HTTPAPI;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.apis.ILuaAPI;
import dan200.computercraft.core.apis.OSAPI;
import dan200.computercraft.core.apis.PeripheralAPI;
import dan200.computercraft.core.apis.RedstoneAPI;
import dan200.computercraft.core.apis.TermAPI;
import dan200.computercraft.core.computer.ComputerThread;
import dan200.computercraft.core.computer.IComputerEnvironment;
import dan200.computercraft.core.computer.ITask;
import dan200.computercraft.core.filesystem.FileSystem;
import dan200.computercraft.core.filesystem.FileSystemException;
import dan200.computercraft.core.lua.ILuaMachine;
import dan200.computercraft.core.lua.LuaJLuaMachine;
import dan200.computercraft.core.terminal.Terminal;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class Computer {
    public static final String[] s_sideNames = new String[]{"bottom", "top", "back", "front", "right", "left"};
    private static IMount s_romMount = null;
    private int m_id;
    private String m_label;
    private final IComputerEnvironment m_environment;
    private int m_ticksSinceStart;
    private boolean m_startRequested;
    private State m_state;
    private boolean m_blinking;
    private ILuaMachine m_machine;
    private final List<ILuaAPI> m_apis;
    private final APIEnvironment m_apiEnvironment;
    private final Terminal m_terminal;
    private FileSystem m_fileSystem;
    private IWritableMount m_rootMount;
    private final int[] m_internalOutput;
    private final int[] m_internalBundledOutput;
    private boolean m_internalOutputChanged;
    private final int[] m_externalOutput;
    private final int[] m_externalBundledOutput;
    private boolean m_externalOutputChanged;
    private final int[] m_input;
    private final int[] m_bundledInput;
    private boolean m_inputChanged;
    private final IPeripheral[] m_peripherals;

    public Computer(IComputerEnvironment environment, Terminal terminal, int id) {
        ComputerThread.start();
        this.m_id = id;
        this.m_label = null;
        this.m_environment = environment;
        this.m_ticksSinceStart = -1;
        this.m_startRequested = false;
        this.m_state = State.Off;
        this.m_blinking = false;
        this.m_terminal = terminal;
        this.m_fileSystem = null;
        this.m_machine = null;
        this.m_apis = new ArrayList<ILuaAPI>();
        this.m_apiEnvironment = new APIEnvironment(this);
        this.m_internalOutput = new int[6];
        this.m_internalBundledOutput = new int[6];
        this.m_internalOutputChanged = true;
        this.m_externalOutput = new int[6];
        this.m_externalBundledOutput = new int[6];
        this.m_externalOutputChanged = true;
        this.m_input = new int[6];
        this.m_bundledInput = new int[6];
        this.m_inputChanged = false;
        this.m_peripherals = new IPeripheral[6];
        for (int i = 0; i < 6; ++i) {
            this.m_peripherals[i] = null;
        }
        this.m_rootMount = null;
        this.createAPIs();
    }

    public IAPIEnvironment getAPIEnvironment() {
        return this.m_apiEnvironment;
    }

    public void turnOn() {
        if (this.m_state == State.Off) {
            this.m_startRequested = true;
        }
    }

    public void shutdown() {
        this.stopComputer(false);
    }

    public void reboot() {
        this.stopComputer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOn() {
        Computer computer = this;
        synchronized (computer) {
            return this.m_state == State.Running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(boolean hard) {
        Computer computer = this;
        synchronized (computer) {
            if (this.m_state != State.Off && this.m_machine != null) {
                if (hard) {
                    this.m_machine.hardAbort("Too long without yielding");
                } else {
                    this.m_machine.softAbort("Too long without yielding");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload() {
        Computer computer = this;
        synchronized (computer) {
            this.stopComputer(false);
        }
    }

    public int getID() {
        return this.m_id;
    }

    public int assignID() {
        if (this.m_id < 0) {
            this.m_id = this.m_environment.assignNewID();
        }
        return this.m_id;
    }

    public void setID(int id) {
        this.m_id = id;
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setLabel(String label) {
        if (!Objects.equal((Object)label, (Object)this.m_label)) {
            this.m_label = label;
            this.m_externalOutputChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void advance(double _dt) {
        boolean blinking;
        Object object = this;
        // MONITORENTER : object
        if (this.m_ticksSinceStart >= 0) {
            ++this.m_ticksSinceStart;
        }
        if (this.m_startRequested && (this.m_ticksSinceStart < 0 || this.m_ticksSinceStart > 50)) {
            this.startComputer();
            this.m_startRequested = false;
        }
        if (this.m_state == State.Running) {
            Object object2 = this.m_input;
            // MONITORENTER : this.m_input
            if (this.m_inputChanged) {
                this.queueEvent("redstone", null);
                this.m_inputChanged = false;
            }
            // MONITOREXIT : object2
            List<ILuaAPI> list = this.m_apis;
            object2 = list;
            // MONITORENTER : list
            for (ILuaAPI api : this.m_apis) {
                api.advance(_dt);
            }
            // MONITOREXIT : object2
        }
        // MONITOREXIT : object
        object = this.m_internalOutput;
        // MONITORENTER : this.m_internalOutput
        if (this.m_internalOutputChanged) {
            boolean changed = false;
            for (int i = 0; i < 6; ++i) {
                if (this.m_externalOutput[i] != this.m_internalOutput[i]) {
                    this.m_externalOutput[i] = this.m_internalOutput[i];
                    changed = true;
                }
                if (this.m_externalBundledOutput[i] == this.m_internalBundledOutput[i]) continue;
                this.m_externalBundledOutput[i] = this.m_internalBundledOutput[i];
                changed = true;
            }
            this.m_internalOutputChanged = false;
            if (changed) {
                this.m_externalOutputChanged = true;
            }
        }
        // MONITOREXIT : object
        object = this.m_terminal;
        // MONITORENTER : object
        boolean bl = blinking = this.m_terminal.getCursorBlink() && this.m_terminal.getCursorX() >= 0 && this.m_terminal.getCursorX() < this.m_terminal.getWidth() && this.m_terminal.getCursorY() >= 0 && this.m_terminal.getCursorY() < this.m_terminal.getHeight();
        if (blinking != this.m_blinking) {
            this.m_blinking = blinking;
            this.m_externalOutputChanged = true;
        }
        // MONITOREXIT : object
    }

    public boolean pollChanged() {
        return this.m_externalOutputChanged;
    }

    public void clearChanged() {
        this.m_externalOutputChanged = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlinking() {
        Terminal terminal = this.m_terminal;
        synchronized (terminal) {
            return this.isOn() && this.m_blinking;
        }
    }

    public IWritableMount getRootMount() {
        if (this.m_rootMount == null) {
            this.m_rootMount = this.m_environment.createSaveDirMount("computer/" + this.assignID(), this.m_environment.getComputerSpaceLimit());
        }
        return this.m_rootMount;
    }

    private boolean initFileSystem() {
        int id = this.assignID();
        try {
            this.m_fileSystem = new FileSystem("hdd", this.getRootMount());
            if (s_romMount == null) {
                s_romMount = this.m_environment.createResourceMount("computercraft", "lua/rom");
            }
            if (s_romMount != null) {
                this.m_fileSystem.mount("rom", "rom", s_romMount);
                return true;
            }
            return false;
        }
        catch (FileSystemException e) {
            ComputerCraft.log.error("Cannot mount rom", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRedstoneOutput(int side) {
        int[] nArray = this.m_internalOutput;
        synchronized (this.m_internalOutput) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.isOn() ? this.m_externalOutput[side] : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getInternalRedstoneOutput(int side) {
        int[] nArray = this.m_internalOutput;
        synchronized (this.m_internalOutput) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.isOn() ? this.m_internalOutput[side] : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRedstoneOutput(int side, int level) {
        int[] nArray = this.m_internalOutput;
        synchronized (this.m_internalOutput) {
            if (this.m_internalOutput[side] != level) {
                this.m_internalOutput[side] = level;
                this.m_internalOutputChanged = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRedstoneInput(int side, int level) {
        int[] nArray = this.m_input;
        synchronized (this.m_input) {
            if (this.m_input[side] != level) {
                this.m_input[side] = level;
                this.m_inputChanged = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRedstoneInput(int side) {
        int[] nArray = this.m_input;
        synchronized (this.m_input) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.m_input[side];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBundledRedstoneOutput(int side) {
        int[] nArray = this.m_internalOutput;
        synchronized (this.m_internalOutput) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.isOn() ? this.m_externalBundledOutput[side] : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getInternalBundledRedstoneOutput(int side) {
        int[] nArray = this.m_internalOutput;
        synchronized (this.m_internalOutput) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.isOn() ? this.m_internalBundledOutput[side] : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBundledRedstoneOutput(int side, int combination) {
        int[] nArray = this.m_internalOutput;
        synchronized (this.m_internalOutput) {
            if (this.m_internalBundledOutput[side] != combination) {
                this.m_internalBundledOutput[side] = combination;
                this.m_internalOutputChanged = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBundledRedstoneInput(int side, int combination) {
        int[] nArray = this.m_input;
        synchronized (this.m_input) {
            if (this.m_bundledInput[side] != combination) {
                this.m_bundledInput[side] = combination;
                this.m_inputChanged = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getBundledRedstoneInput(int side) {
        int[] nArray = this.m_input;
        synchronized (this.m_input) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.m_bundledInput[side];
        }
    }

    public void addAPI(ILuaAPI api) {
        this.m_apis.add(api);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPeripheral(int side, IPeripheral peripheral) {
        IPeripheral[] iPeripheralArray = this.m_peripherals;
        synchronized (this.m_peripherals) {
            IPeripheral existing = this.m_peripherals[side];
            if (existing == null && peripheral != null || existing != null && peripheral == null || existing != null && !existing.equals(peripheral)) {
                this.m_peripherals[side] = peripheral;
                this.m_apiEnvironment.onPeripheralChanged(side, peripheral);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPeripheral getPeripheral(int side) {
        IPeripheral[] iPeripheralArray = this.m_peripherals;
        synchronized (this.m_peripherals) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.m_peripherals[side];
        }
    }

    private void createAPIs() {
        this.m_apis.add(new TermAPI(this.m_apiEnvironment));
        this.m_apis.add(new RedstoneAPI(this.m_apiEnvironment));
        this.m_apis.add(new FSAPI(this.m_apiEnvironment));
        this.m_apis.add(new PeripheralAPI(this.m_apiEnvironment));
        this.m_apis.add(new OSAPI(this.m_apiEnvironment));
        this.m_apis.add(new BitAPI(this.m_apiEnvironment));
        if (ComputerCraft.http_enable) {
            this.m_apis.add(new HTTPAPI(this.m_apiEnvironment));
        }
    }

    private void initLua() {
        InputStream biosStream;
        LuaJLuaMachine machine = new LuaJLuaMachine(this);
        for (ILuaAPI api : this.m_apis) {
            machine.addAPI(api);
            api.startup();
        }
        try {
            biosStream = this.m_environment.createResourceFile("computercraft", "lua/bios.lua");
        }
        catch (Exception e) {
            biosStream = null;
        }
        if (biosStream != null) {
            machine.loadBios(biosStream);
            try {
                biosStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (machine.isFinished()) {
                this.m_terminal.reset();
                this.m_terminal.write("Error starting bios.lua");
                this.m_terminal.setCursorPos(0, 1);
                this.m_terminal.write("ComputerCraft may be installed incorrectly");
                machine.unload();
                this.m_machine = null;
            } else {
                this.m_machine = machine;
            }
        } else {
            this.m_terminal.reset();
            this.m_terminal.write("Error loading bios.lua");
            this.m_terminal.setCursorPos(0, 1);
            this.m_terminal.write("ComputerCraft may be installed incorrectly");
            machine.unload();
            this.m_machine = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startComputer() {
        Computer computer = this;
        synchronized (computer) {
            if (this.m_state != State.Off) {
                return;
            }
            this.m_state = State.Starting;
            this.m_ticksSinceStart = 0;
        }
        final Computer computer2 = this;
        ComputerThread.queueTask(new ITask(){

            @Override
            public Computer getOwner() {
                return computer2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (Computer.this.m_state != State.Starting) {
                        return;
                    }
                    Object object = Computer.this.m_terminal;
                    synchronized (object) {
                        Computer.this.m_terminal.reset();
                    }
                    if (!Computer.this.initFileSystem()) {
                        Computer.this.m_terminal.reset();
                        Computer.this.m_terminal.write("Error mounting lua/rom");
                        Computer.this.m_terminal.setCursorPos(0, 1);
                        Computer.this.m_terminal.write("ComputerCraft may be installed incorrectly");
                        Computer.this.m_state = State.Running;
                        Computer.this.stopComputer(false);
                        return;
                    }
                    Computer.this.initLua();
                    if (Computer.this.m_machine == null) {
                        Computer.this.m_terminal.reset();
                        Computer.this.m_terminal.write("Error loading bios.lua");
                        Computer.this.m_terminal.setCursorPos(0, 1);
                        Computer.this.m_terminal.write("ComputerCraft may be installed incorrectly");
                        Computer.this.m_state = State.Running;
                        Computer.this.stopComputer(false);
                        return;
                    }
                    Computer.this.m_state = State.Running;
                    object = Computer.this.m_machine;
                    synchronized (object) {
                        Computer.this.m_machine.handleEvent(null, null);
                    }
                }
            }
        }, computer2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopComputer(final boolean reboot) {
        Computer computer = this;
        synchronized (computer) {
            if (this.m_state != State.Running) {
                return;
            }
            this.m_state = State.Stopping;
        }
        final Computer computer2 = this;
        ComputerThread.queueTask(new ITask(){

            @Override
            public Computer getOwner() {
                return computer2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    if (Computer.this.m_state != State.Stopping) {
                        return;
                    }
                    Object object = Computer.this.m_apis;
                    synchronized (object) {
                        for (ILuaAPI api : Computer.this.m_apis) {
                            api.shutdown();
                        }
                    }
                    if (Computer.this.m_fileSystem != null) {
                        Computer.this.m_fileSystem.unload();
                        Computer.this.m_fileSystem = null;
                    }
                    if (Computer.this.m_machine != null) {
                        object = Computer.this.m_terminal;
                        synchronized (object) {
                            Computer.this.m_terminal.reset();
                        }
                        object = Computer.this.m_machine;
                        synchronized (object) {
                            Computer.this.m_machine.unload();
                            Computer.this.m_machine = null;
                        }
                    }
                    int[] nArray = Computer.this.m_internalOutput;
                    object = nArray;
                    synchronized (nArray) {
                        for (int i = 0; i < 6; ++i) {
                            ((Computer)Computer.this).m_internalOutput[i] = 0;
                            ((Computer)Computer.this).m_internalBundledOutput[i] = 0;
                        }
                        Computer.this.m_internalOutputChanged = true;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        Computer.this.m_state = State.Off;
                        if (reboot) {
                            Computer.this.m_startRequested = true;
                        }
                    }
                }
            }
        }, computer2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueEvent(final String event, final Object[] arguments) {
        Computer computer = this;
        synchronized (computer) {
            if (this.m_state != State.Running) {
                return;
            }
        }
        final Computer computer2 = this;
        ITask task = new ITask(){

            @Override
            public Computer getOwner() {
                return computer2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                Object object = this;
                synchronized (object) {
                    if (Computer.this.m_state != State.Running) {
                        return;
                    }
                }
                object = Computer.this.m_machine;
                synchronized (object) {
                    Computer.this.m_machine.handleEvent(event, arguments);
                    if (Computer.this.m_machine.isFinished()) {
                        Computer.this.m_terminal.reset();
                        Computer.this.m_terminal.write("Error resuming bios.lua");
                        Computer.this.m_terminal.setCursorPos(0, 1);
                        Computer.this.m_terminal.write("ComputerCraft may be installed incorrectly");
                        Computer.this.stopComputer(false);
                    }
                }
            }
        };
        ComputerThread.queueTask(task, computer2);
    }

    private static class APIEnvironment
    implements IAPIEnvironment {
        private Computer m_computer;
        private IAPIEnvironment.IPeripheralChangeListener m_peripheralListener;

        public APIEnvironment(Computer computer) {
            this.m_computer = computer;
            this.m_peripheralListener = null;
        }

        @Override
        public Computer getComputer() {
            return this.m_computer;
        }

        @Override
        public int getComputerID() {
            return this.m_computer.assignID();
        }

        @Override
        public IComputerEnvironment getComputerEnvironment() {
            return this.m_computer.m_environment;
        }

        @Override
        public Terminal getTerminal() {
            return this.m_computer.m_terminal;
        }

        @Override
        public FileSystem getFileSystem() {
            return this.m_computer.m_fileSystem;
        }

        @Override
        public void shutdown() {
            this.m_computer.shutdown();
        }

        @Override
        public void reboot() {
            this.m_computer.reboot();
        }

        @Override
        public void queueEvent(String event, Object[] args) {
            this.m_computer.queueEvent(event, args);
        }

        @Override
        public void setOutput(int side, int output) {
            this.m_computer.setRedstoneOutput(side, output);
        }

        @Override
        public int getOutput(int side) {
            return this.m_computer.getInternalRedstoneOutput(side);
        }

        @Override
        public int getInput(int side) {
            return this.m_computer.getRedstoneInput(side);
        }

        @Override
        public void setBundledOutput(int side, int output) {
            this.m_computer.setBundledRedstoneOutput(side, output);
        }

        @Override
        public int getBundledOutput(int side) {
            return this.m_computer.getInternalBundledRedstoneOutput(side);
        }

        @Override
        public int getBundledInput(int side) {
            return this.m_computer.getBundledRedstoneInput(side);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IPeripheral getPeripheral(int side) {
            IPeripheral[] iPeripheralArray = this.m_computer.m_peripherals;
            synchronized (iPeripheralArray) {
                return this.m_computer.m_peripherals[side];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setPeripheralChangeListener(IAPIEnvironment.IPeripheralChangeListener listener) {
            IPeripheral[] iPeripheralArray = this.m_computer.m_peripherals;
            synchronized (iPeripheralArray) {
                this.m_peripheralListener = listener;
            }
        }

        @Override
        public String getLabel() {
            return this.m_computer.getLabel();
        }

        @Override
        public void setLabel(String label) {
            this.m_computer.setLabel(label);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPeripheralChanged(int side, IPeripheral peripheral) {
            IPeripheral[] iPeripheralArray = this.m_computer.m_peripherals;
            synchronized (iPeripheralArray) {
                if (this.m_peripheralListener != null) {
                    this.m_peripheralListener.onPeripheralChanged(side, peripheral);
                }
            }
        }
    }

    private static enum State {
        Off,
        Starting,
        Running,
        Stopping;

    }
}

