/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.ArgumentHelper;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.apis.ILuaAPI;
import dan200.computercraft.core.computer.IComputerEnvironment;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.util.Palette;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ArrayUtils;

public class TermAPI
implements ILuaAPI {
    private final Terminal m_terminal;
    private final IComputerEnvironment m_environment;

    public TermAPI(IAPIEnvironment _environment) {
        this.m_terminal = _environment.getTerminal();
        this.m_environment = _environment.getComputerEnvironment();
    }

    @Override
    public String[] getNames() {
        return new String[]{"term"};
    }

    @Override
    public void startup() {
    }

    @Override
    public void advance(double _dt) {
    }

    @Override
    public void shutdown() {
    }

    @Override
    @Nonnull
    public String[] getMethodNames() {
        return new String[]{"write", "scroll", "setCursorPos", "setCursorBlink", "getCursorPos", "getSize", "clear", "clearLine", "setTextColour", "setTextColor", "setBackgroundColour", "setBackgroundColor", "isColour", "isColor", "getTextColour", "getTextColor", "getBackgroundColour", "getBackgroundColor", "blit", "setPaletteColour", "setPaletteColor", "getPaletteColour", "getPaletteColor"};
    }

    public static int parseColour(Object[] args) throws LuaException {
        int colour = ArgumentHelper.getInt(args, 0);
        if (colour <= 0) {
            throw new LuaException("Colour out of range");
        }
        if ((colour = TermAPI.getHighestBit(colour) - 1) < 0 || colour > 15) {
            throw new LuaException("Colour out of range");
        }
        return colour;
    }

    public static Object[] encodeColour(int colour) throws LuaException {
        return new Object[]{1 << colour};
    }

    public static void setColour(Terminal terminal, int colour, double r, double g, double b) {
        if (terminal.getPalette() != null) {
            terminal.getPalette().setColour(colour, r, g, b);
            terminal.setChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] callMethod(@Nonnull ILuaContext context, int method, @Nonnull Object[] args) throws LuaException {
        switch (method) {
            case 0: {
                String text = args.length > 0 && args[0] != null ? args[0].toString() : "";
                Terminal terminal = this.m_terminal;
                synchronized (terminal) {
                    this.m_terminal.write(text);
                    this.m_terminal.setCursorPos(this.m_terminal.getCursorX() + text.length(), this.m_terminal.getCursorY());
                }
                return null;
            }
            case 1: {
                int y = ArgumentHelper.getInt(args, 0);
                Terminal terminal = this.m_terminal;
                synchronized (terminal) {
                    this.m_terminal.scroll(y);
                }
                return null;
            }
            case 2: {
                int x = ArgumentHelper.getInt(args, 0) - 1;
                int y = ArgumentHelper.getInt(args, 1) - 1;
                Terminal terminal = this.m_terminal;
                synchronized (terminal) {
                    this.m_terminal.setCursorPos(x, y);
                }
                return null;
            }
            case 3: {
                boolean b = ArgumentHelper.getBoolean(args, 0);
                Terminal y = this.m_terminal;
                synchronized (y) {
                    this.m_terminal.setCursorBlink(b);
                }
                return null;
            }
            case 4: {
                int y;
                int x;
                Terminal terminal = this.m_terminal;
                synchronized (terminal) {
                    x = this.m_terminal.getCursorX();
                    y = this.m_terminal.getCursorY();
                }
                return new Object[]{x + 1, y + 1};
            }
            case 5: {
                int height;
                int width;
                Terminal terminal = this.m_terminal;
                synchronized (terminal) {
                    width = this.m_terminal.getWidth();
                    height = this.m_terminal.getHeight();
                }
                return new Object[]{width, height};
            }
            case 6: {
                Terminal width = this.m_terminal;
                synchronized (width) {
                    this.m_terminal.clear();
                }
                return null;
            }
            case 7: {
                Terminal width = this.m_terminal;
                synchronized (width) {
                    this.m_terminal.clearLine();
                }
                return null;
            }
            case 8: 
            case 9: {
                int colour = TermAPI.parseColour(args);
                Terminal height = this.m_terminal;
                synchronized (height) {
                    this.m_terminal.setTextColour(colour);
                }
                return null;
            }
            case 10: 
            case 11: {
                int colour = TermAPI.parseColour(args);
                Terminal height = this.m_terminal;
                synchronized (height) {
                    this.m_terminal.setBackgroundColour(colour);
                }
                return null;
            }
            case 12: 
            case 13: {
                return new Object[]{this.m_environment.isColour()};
            }
            case 14: 
            case 15: {
                return TermAPI.encodeColour(this.m_terminal.getTextColour());
            }
            case 16: 
            case 17: {
                return TermAPI.encodeColour(this.m_terminal.getBackgroundColour());
            }
            case 18: {
                String text = ArgumentHelper.getString(args, 0);
                String textColour = ArgumentHelper.getString(args, 1);
                String backgroundColour = ArgumentHelper.getString(args, 2);
                if (textColour.length() != text.length() || backgroundColour.length() != text.length()) {
                    throw new LuaException("Arguments must be the same length");
                }
                Terminal terminal = this.m_terminal;
                synchronized (terminal) {
                    this.m_terminal.blit(text, textColour, backgroundColour);
                    this.m_terminal.setCursorPos(this.m_terminal.getCursorX() + text.length(), this.m_terminal.getCursorY());
                }
                return null;
            }
            case 19: 
            case 20: {
                int colour = 15 - TermAPI.parseColour(args);
                if (args.length == 2) {
                    int hex = ArgumentHelper.getInt(args, 1);
                    double[] rgb = Palette.decodeRGB8(hex);
                    TermAPI.setColour(this.m_terminal, colour, rgb[0], rgb[1], rgb[2]);
                } else {
                    double r = ArgumentHelper.getReal(args, 1);
                    double g = ArgumentHelper.getReal(args, 2);
                    double b = ArgumentHelper.getReal(args, 3);
                    TermAPI.setColour(this.m_terminal, colour, r, g, b);
                }
                return null;
            }
            case 21: 
            case 22: {
                int colour = 15 - TermAPI.parseColour(args);
                Terminal terminal = this.m_terminal;
                synchronized (terminal) {
                    if (this.m_terminal.getPalette() != null) {
                        return ArrayUtils.toObject((double[])this.m_terminal.getPalette().getColour(colour));
                    }
                }
                return null;
            }
        }
        return null;
    }

    private static int getHighestBit(int group) {
        int bit = 0;
        while (group > 0) {
            group >>= 1;
            ++bit;
        }
        return bit;
    }
}

