/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.ArgumentHelper;
import dan200.computercraft.core.apis.HTTPRequestException;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.apis.ILuaAPI;
import dan200.computercraft.core.apis.http.HTTPCheck;
import dan200.computercraft.core.apis.http.HTTPRequest;
import dan200.computercraft.core.apis.http.HTTPTask;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class HTTPAPI
implements ILuaAPI {
    private final IAPIEnvironment m_apiEnvironment;
    private final List<HTTPTask> m_httpTasks;

    public HTTPAPI(IAPIEnvironment environment) {
        this.m_apiEnvironment = environment;
        this.m_httpTasks = new ArrayList<HTTPTask>();
    }

    @Override
    public String[] getNames() {
        return new String[]{"http"};
    }

    @Override
    public void startup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void advance(double _dt) {
        List<HTTPTask> list = this.m_httpTasks;
        synchronized (list) {
            Iterator<HTTPTask> it = this.m_httpTasks.iterator();
            while (it.hasNext()) {
                HTTPTask h = it.next();
                if (!h.isFinished()) continue;
                h.whenFinished(this.m_apiEnvironment);
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        List<HTTPTask> list = this.m_httpTasks;
        synchronized (list) {
            for (HTTPTask r : this.m_httpTasks) {
                r.cancel();
            }
            this.m_httpTasks.clear();
        }
    }

    @Override
    @Nonnull
    public String[] getMethodNames() {
        return new String[]{"request", "checkURL"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] callMethod(@Nonnull ILuaContext context, int method, @Nonnull Object[] args) throws LuaException {
        switch (method) {
            case 0: {
                String urlString = ArgumentHelper.getString(args, 0);
                String postString = ArgumentHelper.optString(args, 1, null);
                HashMap<String, String> headers = null;
                Map<Object, Object> table = ArgumentHelper.optTable(args, 2, null);
                if (table != null) {
                    headers = new HashMap<String, String>(table.size());
                    for (Object key : table.keySet()) {
                        Object value = table.get(key);
                        if (!(key instanceof String) || !(value instanceof String)) continue;
                        headers.put((String)key, (String)value);
                    }
                }
                boolean binary = false;
                if (args.length >= 4) {
                    binary = args[3] != null && !args[3].equals(Boolean.FALSE);
                }
                try {
                    URL url = HTTPRequest.checkURL(urlString);
                    HTTPRequest request = new HTTPRequest(urlString, url, postString, headers, binary);
                    List<HTTPTask> list = this.m_httpTasks;
                    synchronized (list) {
                        this.m_httpTasks.add(HTTPTask.submit(request));
                    }
                    return new Object[]{true};
                }
                catch (HTTPRequestException e) {
                    return new Object[]{false, e.getMessage()};
                }
            }
            case 1: {
                String urlString = ArgumentHelper.getString(args, 0);
                try {
                    URL url = HTTPRequest.checkURL(urlString);
                    HTTPCheck check = new HTTPCheck(urlString, url);
                    List<HTTPTask> list = this.m_httpTasks;
                    synchronized (list) {
                        this.m_httpTasks.add(HTTPTask.submit(check));
                    }
                    return new Object[]{true};
                }
                catch (HTTPRequestException e) {
                    return new Object[]{false, e.getMessage()};
                }
            }
        }
        return null;
    }
}

