/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.ArgumentHelper;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.apis.ILuaAPI;
import dan200.computercraft.core.apis.handles.BinaryInputHandle;
import dan200.computercraft.core.apis.handles.BinaryOutputHandle;
import dan200.computercraft.core.apis.handles.EncodedInputHandle;
import dan200.computercraft.core.apis.handles.EncodedOutputHandle;
import dan200.computercraft.core.filesystem.FileSystem;
import dan200.computercraft.core.filesystem.FileSystemException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.annotation.Nonnull;

public class FSAPI
implements ILuaAPI {
    private IAPIEnvironment m_env;
    private FileSystem m_fileSystem;

    public FSAPI(IAPIEnvironment _env) {
        this.m_env = _env;
        this.m_fileSystem = null;
    }

    @Override
    public String[] getNames() {
        return new String[]{"fs"};
    }

    @Override
    public void startup() {
        this.m_fileSystem = this.m_env.getFileSystem();
    }

    @Override
    public void advance(double _dt) {
    }

    @Override
    public void shutdown() {
        this.m_fileSystem = null;
    }

    @Override
    @Nonnull
    public String[] getMethodNames() {
        return new String[]{"list", "combine", "getName", "getSize", "exists", "isDir", "isReadOnly", "makeDir", "move", "copy", "delete", "open", "getDrive", "getFreeSpace", "find", "getDir"};
    }

    @Override
    public Object[] callMethod(@Nonnull ILuaContext context, int method, @Nonnull Object[] args) throws LuaException {
        switch (method) {
            case 0: {
                String path = ArgumentHelper.getString(args, 0);
                try {
                    String[] results = this.m_fileSystem.list(path);
                    HashMap<Integer, String> table = new HashMap<Integer, String>();
                    for (int i = 0; i < results.length; ++i) {
                        table.put(i + 1, results[i]);
                    }
                    return new Object[]{table};
                }
                catch (FileSystemException e) {
                    throw new LuaException(e.getMessage());
                }
            }
            case 1: {
                String pathA = ArgumentHelper.getString(args, 0);
                String pathB = ArgumentHelper.getString(args, 1);
                return new Object[]{this.m_fileSystem.combine(pathA, pathB)};
            }
            case 2: {
                String path = ArgumentHelper.getString(args, 0);
                return new Object[]{FileSystem.getName(path)};
            }
            case 3: {
                String path = ArgumentHelper.getString(args, 0);
                try {
                    return new Object[]{this.m_fileSystem.getSize(path)};
                }
                catch (FileSystemException e) {
                    throw new LuaException(e.getMessage());
                }
            }
            case 4: {
                String path = ArgumentHelper.getString(args, 0);
                try {
                    return new Object[]{this.m_fileSystem.exists(path)};
                }
                catch (FileSystemException e) {
                    return new Object[]{false};
                }
            }
            case 5: {
                String path = ArgumentHelper.getString(args, 0);
                try {
                    return new Object[]{this.m_fileSystem.isDir(path)};
                }
                catch (FileSystemException e) {
                    return new Object[]{false};
                }
            }
            case 6: {
                String path = ArgumentHelper.getString(args, 0);
                try {
                    return new Object[]{this.m_fileSystem.isReadOnly(path)};
                }
                catch (FileSystemException e) {
                    return new Object[]{false};
                }
            }
            case 7: {
                String path = ArgumentHelper.getString(args, 0);
                try {
                    this.m_fileSystem.makeDir(path);
                    return null;
                }
                catch (FileSystemException e) {
                    throw new LuaException(e.getMessage());
                }
            }
            case 8: {
                String path = ArgumentHelper.getString(args, 0);
                String dest = ArgumentHelper.getString(args, 1);
                try {
                    this.m_fileSystem.move(path, dest);
                    return null;
                }
                catch (FileSystemException e) {
                    throw new LuaException(e.getMessage());
                }
            }
            case 9: {
                String path = ArgumentHelper.getString(args, 0);
                String dest = ArgumentHelper.getString(args, 1);
                try {
                    this.m_fileSystem.copy(path, dest);
                    return null;
                }
                catch (FileSystemException e) {
                    throw new LuaException(e.getMessage());
                }
            }
            case 10: {
                String path = ArgumentHelper.getString(args, 0);
                try {
                    this.m_fileSystem.delete(path);
                    return null;
                }
                catch (FileSystemException e) {
                    throw new LuaException(e.getMessage());
                }
            }
            case 11: {
                String path = ArgumentHelper.getString(args, 0);
                String mode = ArgumentHelper.getString(args, 1);
                try {
                    if (mode.equals("r")) {
                        InputStream reader = this.m_fileSystem.openForRead(path);
                        return new Object[]{new EncodedInputHandle(reader)};
                    }
                    if (mode.equals("w")) {
                        OutputStream writer = this.m_fileSystem.openForWrite(path, false);
                        return new Object[]{new EncodedOutputHandle(writer)};
                    }
                    if (mode.equals("a")) {
                        OutputStream writer = this.m_fileSystem.openForWrite(path, true);
                        return new Object[]{new EncodedOutputHandle(writer)};
                    }
                    if (mode.equals("rb")) {
                        InputStream reader = this.m_fileSystem.openForRead(path);
                        return new Object[]{new BinaryInputHandle(reader)};
                    }
                    if (mode.equals("wb")) {
                        OutputStream writer = this.m_fileSystem.openForWrite(path, false);
                        return new Object[]{new BinaryOutputHandle(writer)};
                    }
                    if (mode.equals("ab")) {
                        OutputStream writer = this.m_fileSystem.openForWrite(path, true);
                        return new Object[]{new BinaryOutputHandle(writer)};
                    }
                    throw new LuaException("Unsupported mode");
                }
                catch (FileSystemException e) {
                    return new Object[]{null, e.getMessage()};
                }
            }
            case 12: {
                String path = ArgumentHelper.getString(args, 0);
                try {
                    if (!this.m_fileSystem.exists(path)) {
                        return null;
                    }
                    return new Object[]{this.m_fileSystem.getMountLabel(path)};
                }
                catch (FileSystemException e) {
                    throw new LuaException(e.getMessage());
                }
            }
            case 13: {
                String path = ArgumentHelper.getString(args, 0);
                try {
                    long freeSpace = this.m_fileSystem.getFreeSpace(path);
                    if (freeSpace >= 0L) {
                        return new Object[]{freeSpace};
                    }
                    return new Object[]{"unlimited"};
                }
                catch (FileSystemException e) {
                    throw new LuaException(e.getMessage());
                }
            }
            case 14: {
                String path = ArgumentHelper.getString(args, 0);
                try {
                    String[] results = this.m_fileSystem.find(path);
                    HashMap<Integer, String> table = new HashMap<Integer, String>();
                    for (int i = 0; i < results.length; ++i) {
                        table.put(i + 1, results[i]);
                    }
                    return new Object[]{table};
                }
                catch (FileSystemException e) {
                    throw new LuaException(e.getMessage());
                }
            }
            case 15: {
                String path = ArgumentHelper.getString(args, 0);
                return new Object[]{FileSystem.getDirectory(path)};
            }
        }
        assert (false);
        return null;
    }
}

