/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import com.google.common.net.InetAddresses;
import dan200.computercraft.ComputerCraft;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class AddressPredicate {
    private final List<Pattern> wildcards = new ArrayList<Pattern>();
    private final List<HostRange> ranges;

    public AddressPredicate(String ... filters) {
        ArrayList<Pattern> wildcards = this.wildcards;
        this.ranges = new ArrayList<HostRange>();
        ArrayList<HostRange> ranges = this.ranges;
        for (String filter : filters) {
            int cidr = filter.indexOf(47);
            if (cidr >= 0) {
                InetAddress address;
                int prefixSize;
                String addressStr = filter.substring(0, cidr);
                String prefixSizeStr = filter.substring(cidr + 1);
                try {
                    prefixSize = Integer.parseInt(prefixSizeStr);
                }
                catch (NumberFormatException e) {
                    ComputerCraft.log.warn("Cannot parse CIDR size from {} ({})", new Object[]{filter, prefixSizeStr});
                    continue;
                }
                try {
                    address = InetAddresses.forString((String)addressStr);
                }
                catch (IllegalArgumentException e) {
                    ComputerCraft.log.warn("Cannot parse IP address from {} ({})", new Object[]{filter, addressStr});
                    continue;
                }
                byte[] minBytes = address.getAddress();
                byte[] maxBytes = address.getAddress();
                int size = prefixSize;
                for (int i = 0; i < minBytes.length; ++i) {
                    if (size <= 0) {
                        int n = i;
                        minBytes[n] = (byte)(minBytes[n] & 0);
                        int n2 = i;
                        maxBytes[n2] = (byte)(maxBytes[n2] | 0xFF);
                    } else if (size < 8) {
                        int n = i;
                        minBytes[n] = (byte)(minBytes[n] & 255 << 8 - size);
                        int n3 = i;
                        maxBytes[n3] = (byte)(maxBytes[n3] | ~(255 << 8 - size));
                    }
                    size -= 8;
                }
                ranges.add(new HostRange(minBytes, maxBytes));
                continue;
            }
            wildcards.add(Pattern.compile("^\\Q" + filter.replaceAll("\\*", "\\\\E.*\\\\Q") + "\\E$"));
        }
    }

    public boolean matches(String domain) {
        for (Pattern domainPattern : this.wildcards) {
            if (!domainPattern.matcher(domain).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean matchesAddress(InetAddress address) {
        String addressString = address.getHostAddress();
        for (Pattern domainPattern : this.wildcards) {
            if (!domainPattern.matcher(addressString).matches()) continue;
            return true;
        }
        for (HostRange range : this.ranges) {
            if (!range.contains(address)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(InetAddress address) {
        String host = address.getHostName();
        if (host != null && this.matches(host)) {
            return true;
        }
        if (this.matchesAddress(address)) {
            return true;
        }
        return address instanceof Inet6Address && InetAddresses.is6to4Address((Inet6Address)((Inet6Address)address)) && this.matchesAddress(InetAddresses.get6to4IPv4Address((Inet6Address)((Inet6Address)address)));
    }

    private static class HostRange {
        private final byte[] min;
        private final byte[] max;

        private HostRange(byte[] min, byte[] max) {
            this.min = min;
            this.max = max;
        }

        public boolean contains(InetAddress address) {
            byte[] entry = address.getAddress();
            if (entry.length != this.min.length) {
                return false;
            }
            for (int i = 0; i < entry.length; ++i) {
                int value = 0xFF & entry[i];
                if (value >= (0xFF & this.min[i]) && value <= (0xFF & this.max[i])) continue;
                return false;
            }
            return true;
        }
    }
}

