/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.entity.TurtleVisionCamera;
import dan200.computercraft.shared.util.Holiday;
import dan200.computercraft.shared.util.HolidayUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.LightUtil;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityTurtleRenderer
extends TileEntitySpecialRenderer<TileTurtle> {
    private static ModelResourceLocation NORMAL_TURTLE_MODEL = new ModelResourceLocation("computercraft:turtle", "inventory");
    private static ModelResourceLocation ADVANCED_TURTLE_MODEL = new ModelResourceLocation("computercraft:turtle_advanced", "inventory");
    private static ModelResourceLocation COLOUR_TURTLE_MODEL = new ModelResourceLocation("computercraft:turtle_white", "inventory");
    private static ModelResourceLocation BEGINNER_TURTLE_MODEL = new ModelResourceLocation("computercraftedu:CC-TurtleJunior", "inventory");
    private static ModelResourceLocation BEGINNER_TURTLE_COLOUR_MODEL = new ModelResourceLocation("computercraftedu:turtleJunior_white", "inventory");
    private static ModelResourceLocation ELF_OVERLAY_MODEL = new ModelResourceLocation("computercraft:turtle_elf_overlay", "inventory");

    public void renderTileEntityAt(@Nonnull TileTurtle tileEntity, double posX, double posY, double posZ, float f, int i) {
        if (tileEntity != null) {
            TurtleVisionCamera camera;
            Entity viewEntity = Minecraft.func_71410_x().func_175606_aa();
            if (viewEntity != null && viewEntity instanceof TurtleVisionCamera && (camera = (TurtleVisionCamera)viewEntity).getTurtle() == tileEntity.getAccess()) {
                return;
            }
            this.renderTurtleAt(tileEntity, posX, posY, posZ, f, i);
        }
    }

    public static ModelResourceLocation getTurtleModel(ComputerFamily family, boolean coloured) {
        switch (family) {
            default: {
                return coloured ? COLOUR_TURTLE_MODEL : NORMAL_TURTLE_MODEL;
            }
            case Advanced: {
                return coloured ? COLOUR_TURTLE_MODEL : ADVANCED_TURTLE_MODEL;
            }
            case Beginners: 
        }
        return coloured ? BEGINNER_TURTLE_COLOUR_MODEL : BEGINNER_TURTLE_MODEL;
    }

    public static ModelResourceLocation getTurtleOverlayModel(ComputerFamily family, ResourceLocation overlay, boolean christmas) {
        if (overlay != null) {
            return new ModelResourceLocation(overlay, "inventory");
        }
        if (christmas && family != ComputerFamily.Beginners) {
            return ELF_OVERLAY_MODEL;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderTurtleAt(TileTurtle turtle, double posX, double posY, double posZ, float f, int i) {
        IBlockState state = turtle.func_145831_w().func_180495_p(turtle.func_174877_v());
        GlStateManager.func_179094_E();
        try {
            int[] nArray;
            ResourceLocation overlay;
            ComputerFamily family;
            int colour;
            String label;
            float yaw;
            Vec3d offset;
            if (turtle != null) {
                offset = turtle.getRenderOffset(f);
                yaw = turtle.getRenderYaw(f);
            } else {
                offset = new Vec3d(0.0, 0.0, 0.0);
                yaw = 0.0f;
            }
            GlStateManager.func_179137_b((double)(posX + offset.field_72450_a), (double)(posY + offset.field_72448_b), (double)(posZ + offset.field_72449_c));
            IComputer computer = turtle != null ? turtle.getComputer() : null;
            String string = label = computer != null ? computer.getLabel() : null;
            if (label != null) {
                this.renderLabel(turtle.getAccess().getPosition(), label);
            }
            GlStateManager.func_179109_b((float)0.5f, (float)0.0f, (float)0.5f);
            GlStateManager.func_179114_b((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)-0.5f, (float)0.0f, (float)-0.5f);
            if (turtle != null) {
                colour = turtle.getColour();
                family = turtle.getFamily();
                overlay = turtle.getOverlay();
            } else {
                colour = -1;
                family = ComputerFamily.Normal;
                overlay = null;
            }
            ModelResourceLocation modelResourceLocation = TileEntityTurtleRenderer.getTurtleModel(family, colour != -1);
            if (colour == -1) {
                nArray = null;
            } else {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = colour;
            }
            this.renderModel(state, modelResourceLocation, nArray);
            ModelResourceLocation overlayModel = TileEntityTurtleRenderer.getTurtleOverlayModel(family, overlay, HolidayUtil.getCurrentHoliday() == Holiday.Christmas);
            if (overlayModel != null) {
                GlStateManager.func_179129_p();
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                try {
                    this.renderModel(state, overlayModel, null);
                }
                finally {
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179089_o();
                }
            }
            if (turtle != null) {
                this.renderUpgrade(state, turtle, TurtleSide.Left, f);
                this.renderUpgrade(state, turtle, TurtleSide.Right, f);
            }
        }
        finally {
            GlStateManager.func_179121_F();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderUpgrade(IBlockState state, TileTurtle turtle, TurtleSide side, float f) {
        ITurtleUpgrade upgrade = turtle.getUpgrade(side);
        if (upgrade != null) {
            GlStateManager.func_179094_E();
            try {
                float toolAngle = turtle.getToolRenderAngle(side, f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.5f);
                GlStateManager.func_179114_b((float)(-toolAngle), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)-0.5f, (float)-0.5f);
                Pair<IBakedModel, Matrix4f> pair = upgrade.getModel(turtle.getAccess(), side);
                if (pair != null) {
                    if (pair.getRight() != null) {
                        ForgeHooksClient.multiplyCurrentGlMatrix((Matrix4f)((Matrix4f)pair.getRight()));
                    }
                    if (pair.getLeft() != null) {
                        this.renderModel(state, (IBakedModel)pair.getLeft(), null);
                    }
                }
            }
            finally {
                GlStateManager.func_179121_F();
            }
        }
    }

    private void renderModel(IBlockState state, ModelResourceLocation modelLocation, int[] tints) {
        Minecraft mc = Minecraft.func_71410_x();
        ModelManager modelManager = mc.func_175599_af().func_175037_a().func_178083_a();
        this.renderModel(state, modelManager.func_174953_a(modelLocation), tints);
    }

    private void renderModel(IBlockState state, IBakedModel model, int[] tints) {
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        this.renderQuads(tessellator, model.func_188616_a(state, null, 0L), tints);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.renderQuads(tessellator, model.func_188616_a(state, facing, 0L), tints);
        }
    }

    private void renderQuads(Tessellator tessellator, List<BakedQuad> quads, int[] tints) {
        VertexBuffer buffer = tessellator.func_178180_c();
        VertexFormat format = DefaultVertexFormats.field_176599_b;
        buffer.func_181668_a(7, format);
        for (BakedQuad quad : quads) {
            int index;
            VertexFormat quadFormat = quad.getFormat();
            if (quadFormat != format) {
                tessellator.func_78381_a();
                format = quadFormat;
                buffer.func_181668_a(7, format);
            }
            int colour = -1;
            if (quad.func_178212_b() && tints != null && (index = quad.func_178211_c()) >= 0 && index < tints.length) {
                colour = tints[index] | 0xFF000000;
            }
            LightUtil.renderQuadColor((VertexBuffer)buffer, (BakedQuad)quad, (int)colour);
        }
        tessellator.func_78381_a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderLabel(BlockPos position, String label) {
        Minecraft mc = Minecraft.func_71410_x();
        RayTraceResult mop = mc.field_71476_x;
        if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK && mop.func_178782_a().equals((Object)position)) {
            RenderManager renderManager = mc.func_175598_ae();
            FontRenderer fontrenderer = renderManager.func_78716_a();
            float scale = 0.02666667f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            try {
                GlStateManager.func_179109_b((float)0.5f, (float)1.25f, (float)0.5f);
                GlStateManager.func_179114_b((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)(-scale), (float)(-scale), (float)scale);
                int yOffset = 0;
                int xOffset = fontrenderer.func_78256_a(label) / 2;
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179097_i();
                try {
                    GlStateManager.func_179090_x();
                    try {
                        Tessellator tessellator = Tessellator.func_178181_a();
                        VertexBuffer renderer = tessellator.func_178180_c();
                        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                        renderer.func_181662_b((double)(-xOffset - 1), (double)(-1 + yOffset), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
                        renderer.func_181662_b((double)(-xOffset - 1), (double)(8 + yOffset), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
                        renderer.func_181662_b((double)(xOffset + 1), (double)(8 + yOffset), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
                        renderer.func_181662_b((double)(xOffset + 1), (double)(-1 + yOffset), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
                        tessellator.func_78381_a();
                    }
                    finally {
                        GlStateManager.func_179098_w();
                    }
                    fontrenderer.func_78276_b(label, -fontrenderer.func_78256_a(label) / 2, yOffset, 0x20FFFFFF);
                }
                finally {
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179132_a((boolean)true);
                }
                fontrenderer.func_78276_b(label, -fontrenderer.func_78256_a(label) / 2, yOffset, -1);
            }
            finally {
                GlStateManager.func_179084_k();
                GlStateManager.func_179145_e();
                GlStateManager.func_179121_F();
            }
        }
    }
}

