/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.client.gui.FixedWidthFontRenderer;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.shared.common.ClientTerminal;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.Palette;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class TileEntityMonitorRenderer
extends TileEntitySpecialRenderer<TileMonitor> {
    public void renderTileEntityAt(@Nonnull TileMonitor tileEntity, double posX, double posY, double posZ, float f, int i) {
        if (tileEntity != null) {
            this.renderMonitorAt(tileEntity, posX, posY, posZ, f, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderMonitorAt(TileMonitor monitor, double posX, double posY, double posZ, float f, int i) {
        TileMonitor origin = monitor.getOrigin();
        if (origin == null) {
            return;
        }
        long renderFrame = ComputerCraft.getRenderFrame();
        if (origin.m_lastRenderFrame == renderFrame) {
            return;
        }
        origin.m_lastRenderFrame = renderFrame;
        boolean redraw = origin.pollChanged();
        BlockPos monitorPos = monitor.func_174877_v();
        BlockPos originPos = origin.func_174877_v();
        posX += (double)(originPos.func_177958_n() - monitorPos.func_177958_n());
        posY += (double)(originPos.func_177956_o() - monitorPos.func_177956_o());
        posZ += (double)(originPos.func_177952_p() - monitorPos.func_177952_p());
        EnumFacing dir = origin.getDirection();
        EnumFacing front = origin.getFront();
        float yaw = DirectionUtil.toYawAngle(dir);
        float pitch = DirectionUtil.toPitchAngle(front);
        GlStateManager.func_179094_E();
        try {
            VertexBuffer renderer;
            Tessellator tessellator;
            Minecraft mc;
            double ySize;
            double xSize;
            block39: {
                GlStateManager.func_179137_b((double)(posX + 0.5), (double)(posY + 0.5), (double)(posZ + 0.5));
                GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)-0.34375, (double)((double)origin.getHeight() - 0.5 - 0.15625), (double)0.5);
                xSize = (double)origin.getWidth() - 0.3125;
                ySize = (double)origin.getHeight() - 0.3125;
                mc = Minecraft.func_71410_x();
                tessellator = Tessellator.func_178181_a();
                renderer = tessellator.func_178180_c();
                ClientTerminal clientTerminal = (ClientTerminal)origin.getTerminal();
                Terminal terminal = clientTerminal != null ? clientTerminal.getTerminal() : null;
                redraw = redraw || clientTerminal != null && clientTerminal.hasTerminalChanged();
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179140_f();
                mc.field_71460_t.func_175072_h();
                try {
                    if (terminal != null) {
                        Palette palette = terminal.getPalette();
                        if (origin.m_renderDisplayList < 0) {
                            origin.m_renderDisplayList = GlStateManager.func_187442_t((int)3);
                            redraw = true;
                        }
                        boolean greyscale = !clientTerminal.isColour();
                        int width = terminal.getWidth();
                        int height = terminal.getHeight();
                        int cursorX = terminal.getCursorX();
                        int cursorY = terminal.getCursorY();
                        FixedWidthFontRenderer fontRenderer = (FixedWidthFontRenderer)ComputerCraft.getFixedWidthFontRenderer();
                        GlStateManager.func_179094_E();
                        try {
                            double xScale = xSize / (double)(width * FixedWidthFontRenderer.FONT_WIDTH);
                            double yScale = ySize / (double)(height * FixedWidthFontRenderer.FONT_HEIGHT);
                            GlStateManager.func_179139_a((double)xScale, (double)(-yScale), (double)1.0);
                            mc.func_110434_K().func_110577_a(FixedWidthFontRenderer.background);
                            if (redraw) {
                                GlStateManager.func_187423_f((int)origin.m_renderDisplayList, (int)4864);
                                try {
                                    double marginXSize = 0.03125 / xScale;
                                    double marginYSize = 0.03125 / yScale;
                                    double marginSquash = marginYSize / (double)FixedWidthFontRenderer.FONT_HEIGHT;
                                    GlStateManager.func_179094_E();
                                    try {
                                        GlStateManager.func_179139_a((double)1.0, (double)marginSquash, (double)1.0);
                                        GlStateManager.func_179137_b((double)0.0, (double)(-marginYSize / marginSquash), (double)0.0);
                                        fontRenderer.drawStringBackgroundPart(0, 0, terminal.getBackgroundColourLine(0), marginXSize, marginXSize, greyscale, palette);
                                        GlStateManager.func_179137_b((double)0.0, (double)((marginYSize + (double)(height * FixedWidthFontRenderer.FONT_HEIGHT)) / marginSquash), (double)0.0);
                                        fontRenderer.drawStringBackgroundPart(0, 0, terminal.getBackgroundColourLine(height - 1), marginXSize, marginXSize, greyscale, palette);
                                    }
                                    finally {
                                        GlStateManager.func_179121_F();
                                    }
                                    for (int y = 0; y < height; ++y) {
                                        fontRenderer.drawStringBackgroundPart(0, FixedWidthFontRenderer.FONT_HEIGHT * y, terminal.getBackgroundColourLine(y), marginXSize, marginXSize, greyscale, palette);
                                    }
                                }
                                finally {
                                    GlStateManager.func_187415_K();
                                }
                            }
                            GlStateManager.func_179148_o((int)origin.m_renderDisplayList);
                            GlStateManager.func_179117_G();
                            fontRenderer.bindFont();
                            if (redraw) {
                                GlStateManager.func_187423_f((int)(origin.m_renderDisplayList + 1), (int)4864);
                                try {
                                    for (int y = 0; y < height; ++y) {
                                        fontRenderer.drawStringTextPart(0, FixedWidthFontRenderer.FONT_HEIGHT * y, terminal.getLine(y), terminal.getTextColourLine(y), greyscale, palette);
                                    }
                                }
                                finally {
                                    GlStateManager.func_187415_K();
                                }
                            }
                            GlStateManager.func_179148_o((int)(origin.m_renderDisplayList + 1));
                            GlStateManager.func_179117_G();
                            fontRenderer.bindFont();
                            if (redraw) {
                                GlStateManager.func_187423_f((int)(origin.m_renderDisplayList + 2), (int)4864);
                                try {
                                    if (terminal.getCursorBlink() && cursorX >= 0 && cursorX < width && cursorY >= 0 && cursorY < height) {
                                        TextBuffer cursor = new TextBuffer("_");
                                        TextBuffer cursorColour = new TextBuffer("0123456789abcdef".charAt(terminal.getTextColour()), 1);
                                        fontRenderer.drawString(cursor, FixedWidthFontRenderer.FONT_WIDTH * cursorX, FixedWidthFontRenderer.FONT_HEIGHT * cursorY, cursorColour, null, 0.0, 0.0, greyscale, palette);
                                    }
                                }
                                finally {
                                    GlStateManager.func_187415_K();
                                }
                            }
                            if (ComputerCraft.getGlobalCursorBlink()) {
                                GlStateManager.func_179148_o((int)(origin.m_renderDisplayList + 2));
                                GlStateManager.func_179117_G();
                            }
                            break block39;
                        }
                        finally {
                            GlStateManager.func_179121_F();
                        }
                    }
                    mc.func_110434_K().func_110577_a(FixedWidthFontRenderer.background);
                    Colour colour = Colour.Black;
                    float r = colour.getR();
                    float g = colour.getG();
                    float b = colour.getB();
                    renderer.func_181668_a(5, DefaultVertexFormats.field_181709_i);
                    renderer.func_181662_b(-0.03125, 0.03125, 0.0).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
                    renderer.func_181662_b(-0.03125, -ySize - 0.03125, 0.0).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
                    renderer.func_181662_b(xSize + 0.03125, 0.03125, 0.0).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
                    renderer.func_181662_b(xSize + 0.03125, -ySize - 0.03125, 0.0).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
                    tessellator.func_78381_a();
                }
                finally {
                    GlStateManager.func_179132_a((boolean)true);
                    mc.field_71460_t.func_180436_i();
                    GlStateManager.func_179145_e();
                }
            }
            GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            try {
                mc.func_110434_K().func_110577_a(FixedWidthFontRenderer.background);
                renderer.func_181668_a(5, DefaultVertexFormats.field_181705_e);
                renderer.func_181662_b(-0.03125, 0.03125, 0.0).func_181675_d();
                renderer.func_181662_b(-0.03125, -ySize - 0.03125, 0.0).func_181675_d();
                renderer.func_181662_b(xSize + 0.03125, 0.03125, 0.0).func_181675_d();
                renderer.func_181662_b(xSize + 0.03125, -ySize - 0.03125, 0.0).func_181675_d();
                tessellator.func_78381_a();
            }
            finally {
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
        }
        finally {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
    }
}

