/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.proxy;

import com.google.common.base.Function;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.client.render.TileEntityTurtleRenderer;
import dan200.computercraft.client.render.TurtleSmartItemModel;
import dan200.computercraft.shared.proxy.CCTurtleProxyCommon;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.turtle.items.ItemTurtleBase;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class CCTurtleProxyClient
extends CCTurtleProxyCommon {
    @Override
    public void preInit() {
        super.preInit();
        ItemMeshDefinition turtleMeshDefinition = new ItemMeshDefinition(){
            private ModelResourceLocation turtle_dynamic = new ModelResourceLocation("computercraft:turtle_dynamic", "inventory");

            @Nonnull
            public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
                return this.turtle_dynamic;
            }
        };
        String[] turtleModelNames = new String[]{"turtle_dynamic", "turtle", "turtle_advanced", "turtle_white", "turtle_elf_overlay"};
        this.registerItemModel(ComputerCraft.Blocks.turtle, turtleMeshDefinition, turtleModelNames);
        this.registerItemModel(ComputerCraft.Blocks.turtleExpanded, turtleMeshDefinition, turtleModelNames);
        this.registerItemModel(ComputerCraft.Blocks.turtleAdvanced, turtleMeshDefinition, turtleModelNames);
        this.registerForgeHandlers();
    }

    @Override
    public void init() {
        super.init();
        Minecraft.func_71410_x().getItemColors().func_186731_a((IItemColor)new TurtleItemColour(), new Block[]{ComputerCraft.Blocks.turtle, ComputerCraft.Blocks.turtleExpanded, ComputerCraft.Blocks.turtleAdvanced});
        ClientRegistry.bindTileEntitySpecialRenderer(TileTurtle.class, (TileEntitySpecialRenderer)new TileEntityTurtleRenderer());
    }

    private void registerItemModel(Block block, ItemMeshDefinition definition, String[] names) {
        this.registerItemModel(Item.func_150898_a((Block)block), definition, names);
    }

    private void registerItemModel(Item item, ItemMeshDefinition definition, String[] names) {
        ResourceLocation[] resources = new ResourceLocation[names.length];
        for (int i = 0; i < names.length; ++i) {
            resources[i] = new ResourceLocation("computercraft:" + names[i]);
        }
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])resources);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)definition);
    }

    private void registerForgeHandlers() {
        ForgeHandlers handlers = new ForgeHandlers();
        MinecraftForge.EVENT_BUS.register((Object)handlers);
    }

    private static class TurtleItemColour
    implements IItemColor {
        private TurtleItemColour() {
        }

        public int func_186726_a(@Nonnull ItemStack stack, int tintIndex) {
            ItemTurtleBase turtle;
            int colour;
            if (tintIndex == 0 && (colour = (turtle = (ItemTurtleBase)stack.func_77973_b()).getColour(stack)) != -1) {
                return colour;
            }
            return 0xFFFFFF;
        }
    }

    public class ForgeHandlers {
        private TurtleSmartItemModel m_turtleSmartItemModel = new TurtleSmartItemModel();

        public ForgeHandlers() {
            IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
            if (resourceManager instanceof SimpleReloadableResourceManager) {
                SimpleReloadableResourceManager reloadableResourceManager = (SimpleReloadableResourceManager)resourceManager;
                reloadableResourceManager.func_110542_a((IResourceManagerReloadListener)this.m_turtleSmartItemModel);
            }
        }

        @SubscribeEvent
        public void onTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                TurtleBrain.cleanupBrains();
            }
        }

        @SubscribeEvent
        public void onTextureStitchEvent(TextureStitchEvent.Pre event) {
            event.getMap().func_174942_a(new ResourceLocation("computercraft", "blocks/crafty_upgrade"));
        }

        @SubscribeEvent
        public void onModelBakeEvent(ModelBakeEvent event) {
            this.loadModel(event, "turtle_modem_off_left");
            this.loadModel(event, "turtle_modem_on_left");
            this.loadModel(event, "turtle_modem_off_right");
            this.loadModel(event, "turtle_modem_on_right");
            this.loadModel(event, "turtle_crafting_table_left");
            this.loadModel(event, "turtle_crafting_table_right");
            this.loadModel(event, "advanced_turtle_modem_off_left");
            this.loadModel(event, "advanced_turtle_modem_on_left");
            this.loadModel(event, "advanced_turtle_modem_off_right");
            this.loadModel(event, "advanced_turtle_modem_on_right");
            this.loadModel(event, "turtle_speaker_upgrade_left");
            this.loadModel(event, "turtle_speaker_upgrade_right");
            this.loadSmartModel(event, "turtle_dynamic", this.m_turtleSmartItemModel);
        }

        private void loadModel(ModelBakeEvent event, String name) {
            IModel model = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)new ResourceLocation("computercraft", "block/" + name));
            IBakedModel bakedModel = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, (Function)new Function<ResourceLocation, TextureAtlasSprite>(){

                public TextureAtlasSprite apply(ResourceLocation location) {
                    return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                }
            });
            event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("computercraft:" + name, "inventory"), (Object)bakedModel);
        }

        private void loadSmartModel(ModelBakeEvent event, String name, IBakedModel smartModel) {
            event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("computercraft:" + name, "inventory"), (Object)smartModel);
        }
    }
}

