/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.manager;

import codechicken.chunkloader.ChickenChunks;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.apache.commons.io.IOUtils;

@Mod.EventBusSubscriber
public class PlayerLoginTracker {
    private static final String SAVED_DATA_NAME = "ChickenChunksLoginTimes";

    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ILoginTracker tracker = PlayerLoginTracker.getTracker(event.player.field_70170_p);
        tracker.updateLoginTime(event.player.func_70005_c_());
    }

    public static ILoginTracker getTracker(World world) {
        WorldSavedData data = world.func_175693_T().func_75742_a(SavedData.class, SAVED_DATA_NAME);
        if (data == null) {
            data = new SavedData(SAVED_DATA_NAME);
            world.func_175693_T().func_75745_a(SAVED_DATA_NAME, data);
        }
        return (ILoginTracker)data;
    }

    public static class SavedData
    extends WorldSavedData
    implements ILoginTracker {
        private Map<String, Long> loginTimes = new HashMap<String, Long>();

        public SavedData(String name) {
            super(name);
        }

        public void func_76184_a(NBTTagCompound nbt) {
            NBTTagList list = nbt.func_150295_c("loginTimes", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                String name = compound.func_74779_i("player");
                long time = compound.func_74763_f("time");
                this.loginTimes.put(name, time);
            }
        }

        public NBTTagCompound func_189551_b(NBTTagCompound tag) {
            NBTTagList list = new NBTTagList();
            for (Map.Entry<String, Long> entry : this.loginTimes.entrySet()) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74778_a("player", entry.getKey());
                compound.func_74772_a("time", entry.getValue().longValue());
                list.func_74742_a((NBTBase)compound);
            }
            tag.func_74782_a("loginTimes", (NBTBase)list);
            return tag;
        }

        @Override
        public long getLoginTime(String player) {
            return this.loginTimes.computeIfAbsent(player, p -> {
                this.func_76185_a();
                return System.currentTimeMillis();
            });
        }

        @Override
        public void updateLoginTime(String player) {
            this.loginTimes.put(player, System.currentTimeMillis());
            this.func_76185_a();
        }

        @Override
        public void forceSave(World world) {
            if (this.func_76188_b()) {
                world.func_175693_T().func_75747_a((WorldSavedData)this);
                this.func_76186_a(false);
            }
        }

        @Override
        @Deprecated
        public void loadLegacyData(File folder) {
            File saveFile = new File(folder, "loginTimes.dat");
            if (!saveFile.exists()) {
                return;
            }
            ChickenChunks.logger.info("Found old loginTimes.data file. Attempting conversion...");
            try {
                DataInputStream dataIn = new DataInputStream(new FileInputStream(saveFile));
                int entries = dataIn.readInt();
                for (int i = 0; i < entries; ++i) {
                    this.func_76185_a();
                    this.loginTimes.put(dataIn.readUTF(), dataIn.readLong());
                }
                IOUtils.closeQuietly((InputStream)dataIn);
            }
            catch (Throwable e) {
                ChickenChunks.logger.warn("Exception thrown whilst converting old loginTimes.data! Some login data may be lost..", e);
            }
            ChickenChunks.logger.info("Conversion Finished!");
            saveFile.delete();
        }
    }

    public static interface ILoginTracker {
        public long getLoginTime(String var1);

        public void updateLoginTime(String var1);

        public void forceSave(World var1);

        @Deprecated
        public void loadLegacyData(File var1);
    }
}

