/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.manager;

import codechicken.chunkloader.ChickenChunks;
import codechicken.chunkloader.manager.ChunkLoaderManager;
import codechicken.lib.util.CommonUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.apache.commons.io.IOUtils;

@Mod.EventBusSubscriber
public class OrganiserStorage {
    private static final String SAVED_DATA_NAME = "ChickenChunksOrganisers";

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        OrganiserStorage.getStorage(event.player.field_70170_p).onPlayerLogin(event.player);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedOutEvent event) {
        OrganiserStorage.getStorage(event.player.field_70170_p).onPlayerLogout(event.player);
    }

    public static IOrganiserStorage getStorage(World world) {
        WorldSavedData data = world.func_175693_T().func_75742_a(SavedData.class, SAVED_DATA_NAME);
        if (data == null) {
            data = new SavedData(SAVED_DATA_NAME);
            world.func_175693_T().func_75745_a(SAVED_DATA_NAME, data);
        }
        return (IOrganiserStorage)data;
    }

    public static class SavedData
    extends WorldSavedData
    implements IOrganiserStorage {
        private Map<String, ChunkLoaderManager.PlayerOrganiser> playerOrganisers = new HashMap<String, ChunkLoaderManager.PlayerOrganiser>();
        private Map<Object, ChunkLoaderManager.ModOrganiser> modOrganisers = new HashMap<Object, ChunkLoaderManager.ModOrganiser>();

        public SavedData(String name) {
            super(name);
        }

        public void func_76184_a(NBTTagCompound nbt) {
            NBTTagList playerOrganisers = nbt.func_150295_c("playerOrganisers", 10);
            for (int i = 0; i < playerOrganisers.func_74745_c(); ++i) {
                NBTTagCompound tagCompound = playerOrganisers.func_150305_b(i);
                String username = tagCompound.func_74779_i("player");
                ChunkLoaderManager.PlayerOrganiser organiser = this.getPlayerOrganiser(username);
                organiser.setDormant();
                organiser.readFromNBT(tagCompound.func_74775_l("organiser"));
            }
            NBTTagList modOrganisers = nbt.func_150295_c("modOrganisers", 10);
            for (int i = 0; i < modOrganisers.func_74745_c(); ++i) {
                NBTTagCompound tagCompound = modOrganisers.func_150305_b(i);
                String modId = tagCompound.func_74779_i("modId");
                Object modObject = SavedData.lookupMod(modId);
                if (modObject != null) {
                    ChunkLoaderManager.ModOrganiser organiser = this.getModOrganiser(modObject);
                    organiser.readFromNBT(tagCompound.func_74775_l("organiser"));
                    continue;
                }
                ChickenChunks.logger.warn("Unable to get ModObject for modId: \"{}\" Assuming mod removed, Dropping data..", new Object[]{modId});
            }
        }

        public NBTTagCompound func_189551_b(NBTTagCompound compound) {
            NBTTagList playerOrganisers = new NBTTagList();
            for (ChunkLoaderManager.PlayerOrganiser organiser : this.playerOrganisers.values()) {
                NBTTagCompound organiserTag = new NBTTagCompound();
                organiserTag.func_74778_a("player", organiser.username);
                organiserTag.func_74782_a("organiser", (NBTBase)organiser.saveToNBT(new NBTTagCompound()));
                playerOrganisers.func_74742_a((NBTBase)organiserTag);
            }
            compound.func_74782_a("playerOrganisers", (NBTBase)playerOrganisers);
            NBTTagList modOrganisers = new NBTTagList();
            for (ChunkLoaderManager.ModOrganiser organiser : this.modOrganisers.values()) {
                NBTTagCompound organiserTag = new NBTTagCompound();
                organiserTag.func_74778_a("modId", organiser.container.getModId());
                organiserTag.func_74782_a("organiser", (NBTBase)organiser.saveToNBT(new NBTTagCompound()));
                modOrganisers.func_74742_a((NBTBase)organiserTag);
            }
            compound.func_74782_a("modOrganisers", (NBTBase)modOrganisers);
            return compound;
        }

        public boolean func_76188_b() {
            boolean superDirty = super.func_76188_b();
            boolean localDirty = false;
            localDirty |= ChunkLoaderManager.PlayerOrganiser.dirty;
            for (ChunkLoaderManager.ModOrganiser organiser : this.modOrganisers.values()) {
                localDirty |= organiser.dirty;
            }
            return superDirty || localDirty;
        }

        public void func_76186_a(boolean isDirty) {
            if (!isDirty) {
                ChunkLoaderManager.PlayerOrganiser.dirty = false;
                for (ChunkLoaderManager.ModOrganiser organiser : this.modOrganisers.values()) {
                    organiser.dirty = false;
                }
            }
            super.func_76186_a(isDirty);
        }

        @Override
        public ChunkLoaderManager.PlayerOrganiser getPlayerOrganiser(String player) {
            return this.playerOrganisers.computeIfAbsent(player, ChunkLoaderManager.PlayerOrganiser::new);
        }

        @Override
        public ChunkLoaderManager.ModOrganiser getModOrganiser(Object object) {
            ChunkLoaderManager.ModOrganiser organiser = this.modOrganisers.get(object);
            if (organiser == null) {
                ModContainer container = (ModContainer)ChunkLoaderManager.getHandledMods().get(object);
                if (container == null) {
                    throw new NullPointerException("Mod not registered with chickenchunks: " + object);
                }
                organiser = new ChunkLoaderManager.ModOrganiser(object, container);
                this.modOrganisers.put(object, organiser);
            }
            return organiser;
        }

        @Override
        public void load(World world) {
            for (Map.Entry<String, ChunkLoaderManager.PlayerOrganiser> entry : this.playerOrganisers.entrySet()) {
                if (!ChunkLoaderManager.allowOffline(entry.getKey()) || !ChunkLoaderManager.loggedInRecently(world, entry.getKey())) continue;
                ChunkLoaderManager.ReviveChange.PlayerRevive.list.add(entry.getValue());
            }
            ChunkLoaderManager.ReviveChange.ModRevive.list.addAll(this.modOrganisers.values());
        }

        @Override
        public void queDormantUnloads(World world) {
            for (ChunkLoaderManager.PlayerOrganiser organiser : this.playerOrganisers.values()) {
                if (organiser.isDormant() || ChunkLoaderManager.loggedInRecently(world, organiser.username)) continue;
                ChunkLoaderManager.ReviveChange.PlayerDevive.list.add(organiser);
            }
        }

        @Override
        public void tickUnloads() {
            for (Map.Entry<String, ChunkLoaderManager.PlayerOrganiser> entry : this.playerOrganisers.entrySet()) {
                entry.getValue().tickDownUnloads();
            }
            for (Map.Entry<Object, ChunkLoaderManager.ChunkLoaderOrganiser> entry : this.modOrganisers.entrySet()) {
                ((ChunkLoaderManager.ModOrganiser)entry.getValue()).tickDownUnloads();
            }
        }

        @Override
        public void onDimensionRevive(World world) {
            for (ChunkLoaderManager.PlayerOrganiser organiser : this.playerOrganisers.values()) {
                organiser.revive(world);
            }
        }

        @Override
        public void onPlayerLogin(EntityPlayer player) {
            ChunkLoaderManager.ReviveChange.PlayerRevive.list.add(this.getPlayerOrganiser(player.func_70005_c_()));
        }

        @Override
        public void onPlayerLogout(EntityPlayer player) {
            if (!ChunkLoaderManager.allowOffline(player.func_70005_c_())) {
                ChunkLoaderManager.ReviveChange.PlayerDevive.list.add(this.getPlayerOrganiser(player.func_70005_c_()));
            }
        }

        @Override
        public void onDimensionUnload(World world) {
            int dim = CommonUtils.getDimension((World)world);
            for (ChunkLoaderManager.TicketManager ticketManager : this.playerOrganisers.values()) {
                ticketManager.unloadDimension(dim);
            }
            for (ChunkLoaderManager.TicketManager ticketManager : this.modOrganisers.values()) {
                ticketManager.unloadDimension(dim);
            }
        }

        @Override
        public void forceSave(World world) {
            if (this.func_76188_b()) {
                world.func_175693_T().func_75747_a((WorldSavedData)this);
                this.func_76186_a(false);
            }
        }

        private static Object lookupMod(String modId) {
            for (Map.Entry entry : ChunkLoaderManager.getHandledMods().entrySet()) {
                if (!Objects.equals(((ModContainer)entry.getValue()).getModId(), modId)) continue;
                return entry.getKey();
            }
            return null;
        }

        @Override
        @Deprecated
        public void loadLegacyData(File folder) {
            ChunkLoaderManager.ChunkLoaderOrganiser organiser;
            File playerFile = new File(folder, "players.dat");
            if (playerFile.exists()) {
                ChickenChunks.logger.info("Found old players.dat file. Attempting conversion...");
                try {
                    DataInputStream dataIn = new DataInputStream(new FileInputStream(playerFile));
                    int organisers = dataIn.readInt();
                    for (int i = 0; i < organisers; ++i) {
                        String username = dataIn.readUTF();
                        organiser = this.getPlayerOrganiser(username);
                        ((ChunkLoaderManager.PlayerOrganiser)organiser).setDormant();
                        ((ChunkLoaderManager.PlayerOrganiser)organiser).loadLegacyData(dataIn);
                    }
                    IOUtils.closeQuietly((InputStream)dataIn);
                }
                catch (Throwable e) {
                    ChickenChunks.logger.warn("Exception thrown whilst converting old players.dat file! This is probably a bad thing.. At most some players loaders wont work until manually chunk loaded.");
                }
                ChickenChunks.logger.info("Conversion Finished!");
                playerFile.delete();
            }
            for (Map.Entry entry : ChunkLoaderManager.getHandledMods().entrySet()) {
                File saveFile = new File(folder, ((ModContainer)entry.getValue()).getModId() + ".dat");
                if (!saveFile.exists()) continue;
                ChickenChunks.logger.info("Found old {}.dat file. Attempting conversion...", new Object[]{((ModContainer)entry.getValue()).getModId()});
                try {
                    DataInputStream dataIn = new DataInputStream(new FileInputStream(saveFile));
                    organiser = this.getModOrganiser(entry.getKey());
                    ((ChunkLoaderManager.ModOrganiser)organiser).loadLegacyData(dataIn);
                    IOUtils.closeQuietly((InputStream)dataIn);
                }
                catch (Throwable e) {
                    ChickenChunks.logger.warn("Exception thrown whilst converting old {}.dat file! This is probably a bad thing.. At most, some loaders wont work until manually chunk loaded.", new Object[]{((ModContainer)entry.getValue()).getModId()});
                }
                ChickenChunks.logger.info("Conversion Finished!");
                saveFile.delete();
            }
        }
    }

    public static interface IOrganiserStorage {
        public ChunkLoaderManager.PlayerOrganiser getPlayerOrganiser(String var1);

        public ChunkLoaderManager.ModOrganiser getModOrganiser(Object var1);

        public void load(World var1);

        public void queDormantUnloads(World var1);

        public void tickUnloads();

        public void onDimensionRevive(World var1);

        public void onPlayerLogin(EntityPlayer var1);

        public void onPlayerLogout(EntityPlayer var1);

        public void onDimensionUnload(World var1);

        public void forceSave(World var1);

        @Deprecated
        public void loadLegacyData(File var1);
    }
}

