/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.block;

import codechicken.chunkloader.manager.ChunkLoaderManager;
import codechicken.chunkloader.network.ChunkLoaderSPH;
import codechicken.chunkloader.tile.TileChunkLoader;
import codechicken.chunkloader.tile.TileChunkLoaderBase;
import codechicken.chunkloader.tile.TileSpotLoader;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.util.ServerUtils;
import codechicken.lib.vec.Cuboid6;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockChunkLoader
extends Block
implements ITileEntityProvider {
    public static final PropertyEnum<Type> TYPE = PropertyEnum.func_177709_a((String)"type", Type.class);

    public BlockChunkLoader() {
        super(Material.field_151576_e);
        this.func_149711_c(20.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)Type.BLOCK)));
        this.func_149752_b(100.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        Type type = (Type)((Object)state.func_177229_b(TYPE));
        return type.getBounds().aabb();
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return !((Type)((Object)world.func_180495_p(pos).func_177229_b(TYPE))).equals((Object)Type.SPOT) && side == EnumFacing.DOWN;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        Type type = (Type)((Object)state.func_177229_b(TYPE));
        if (type == Type.SPOT || player.func_70093_af()) {
            return false;
        }
        if (!world.field_72995_K) {
            TileChunkLoader tile = (TileChunkLoader)world.func_175625_s(pos);
            if (tile.owner == null || tile.owner.equals(player.func_70005_c_()) || ChunkLoaderManager.canOpInteract() && ServerUtils.isPlayerOP((String)player.func_70005_c_())) {
                PacketCustom packet = new PacketCustom((Object)ChunkLoaderSPH.channel, 12);
                packet.writePos(pos);
                packet.sendToPlayer(player);
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("chickenchunks.accessdenied", new Object[0]));
            }
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        TileChunkLoaderBase loader = (TileChunkLoaderBase)world.func_175625_s(pos);
        loader.onBlockPlacedBy(placer);
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta == 0) {
            return new TileChunkLoader();
        }
        if (meta == 1) {
            return new TileSpotLoader();
        }
        return null;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTab, NonNullList<ItemStack> list) {
        for (Type type : Type.VALUES) {
            list.add((Object)new ItemStack((Block)this, 1, type.getMetadata()));
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(TYPE))).getMetadata();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)Type.byMetadata(meta)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public static enum Type implements IStringSerializable
    {
        BLOCK(0, "block_loader", new Cuboid6(0.0, 0.0, 0.0, 1.0, 0.75, 1.0)),
        SPOT(1, "spot_loader", new Cuboid6(0.25, 0.0, 0.25, 0.75, 0.4375, 0.75));

        public static final Type[] VALUES;
        private final int metadata;
        private final String name;
        private final Cuboid6 bounds;

        private Type(int meta, String name, Cuboid6 bounds) {
            this.metadata = meta;
            this.name = name;
            this.bounds = bounds;
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String func_176610_l() {
            return this.name;
        }

        public Cuboid6 getBounds() {
            return this.bounds;
        }

        public static Type byMetadata(int metadata) {
            if (metadata < 0 || metadata >= VALUES.length) {
                metadata = 0;
            }
            return VALUES[metadata];
        }

        static {
            VALUES = new Type[Type.values().length];
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type;
                Type.VALUES[type.getMetadata()] = type = typeArray[i];
            }
        }
    }
}

