/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.wire;

import buildcraft.api.transport.EnumWirePart;
import buildcraft.api.transport.IWireManager;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.transport.wire.EnumWireBetween;
import buildcraft.transport.wire.WireSystem;
import buildcraft.transport.wire.WorldSavedDataWireSystems;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WireManager
implements IWireManager {
    private final IPipeHolder holder;
    public final Map<EnumWirePart, EnumDyeColor> parts = new EnumMap<EnumWirePart, EnumDyeColor>(EnumWirePart.class);
    public final Set<EnumWirePart> poweredClient = EnumSet.noneOf(EnumWirePart.class);
    public final Map<EnumWireBetween, EnumDyeColor> betweens = new EnumMap<EnumWireBetween, EnumDyeColor>(EnumWireBetween.class);
    public boolean inited = false;

    public WireManager(IPipeHolder holder) {
        this.holder = holder;
    }

    public WorldSavedDataWireSystems getWireSystems() {
        return WorldSavedDataWireSystems.get(this.holder.getPipeWorld());
    }

    @Override
    public IPipeHolder getHolder() {
        return this.holder;
    }

    @Override
    public boolean addPart(EnumWirePart part, EnumDyeColor colour) {
        if (this.getColorOfPart(part) == null) {
            this.parts.put(part, colour);
            if (!this.holder.getPipeWorld().field_72995_K) {
                this.getWireSystems().buildAndAddWireSystem(new WireSystem.WireElement(this.holder.getPipePos(), part));
                this.holder.getPipeTile().func_70296_d();
            }
            this.updateBetweens(false);
            return true;
        }
        return false;
    }

    @Override
    public EnumDyeColor removePart(EnumWirePart part) {
        EnumDyeColor color = this.getColorOfPart(part);
        if (color == null) {
            return null;
        }
        this.parts.remove((Object)part);
        if (!this.holder.getPipeWorld().field_72995_K) {
            WireSystem.WireElement element = new WireSystem.WireElement(this.holder.getPipePos(), part);
            WireSystem.getConnectedElementsOfElement(this.holder, element).forEach(this.getWireSystems()::buildAndAddWireSystem);
            this.getWireSystems().getWireSystemsWithElement(element).forEach(this.getWireSystems()::removeWireSystem);
            this.holder.getPipeTile().func_70296_d();
        }
        this.updateBetweens(false);
        return color;
    }

    public void removeParts(Collection<EnumWirePart> toRemove) {
        toRemove.forEach(this.parts::remove);
        if (!this.holder.getPipeWorld().field_72995_K) {
            toRemove.stream().map(part -> new WireSystem.WireElement(this.holder.getPipePos(), (EnumWirePart)((Object)part))).flatMap(element -> WireSystem.getConnectedElementsOfElement(this.holder, element).stream()).distinct().forEach(this.getWireSystems()::buildAndAddWireSystem);
            toRemove.stream().map(part -> new WireSystem.WireElement(this.holder.getPipePos(), (EnumWirePart)((Object)part))).flatMap(element -> this.getWireSystems().getWireSystemsWithElement((WireSystem.WireElement)element).stream()).forEach(this.getWireSystems()::removeWireSystem);
            this.holder.getPipeTile().func_70296_d();
        }
        this.updateBetweens(false);
    }

    @Override
    public void updateBetweens(boolean recursive) {
        this.betweens.clear();
        this.parts.forEach((part, color) -> {
            for (EnumWireBetween between : EnumWireBetween.VALUES) {
                IPipe pipe;
                EnumWirePart[] betweenParts = between.parts;
                if (between.to == null) {
                    if ((betweenParts[0] != part || this.getColorOfPart(betweenParts[1]) != color) && (betweenParts[1] != part || this.getColorOfPart(betweenParts[0]) != color)) continue;
                    this.betweens.put(between, (EnumDyeColor)color);
                    continue;
                }
                if (!WireSystem.canWireConnect(this.holder, between.to) || (pipe = this.holder.getNeighbourPipe(between.to)) == null) continue;
                IWireManager wireManager = pipe.getHolder().getWireManager();
                if (betweenParts[0] != part || wireManager.getColorOfPart(betweenParts[1]) != color) continue;
                this.betweens.put(between, (EnumDyeColor)color);
            }
        });
        if (!recursive) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                TileEntity tile = this.holder.getPipeWorld().func_175625_s(this.holder.getPipePos().func_177972_a(side));
                if (!(tile instanceof IPipeHolder)) continue;
                ((IPipeHolder)tile).getWireManager().updateBetweens(true);
            }
        }
    }

    @Override
    public EnumDyeColor getColorOfPart(EnumWirePart part) {
        return this.parts.get((Object)part);
    }

    @Override
    public boolean hasPartOfColor(EnumDyeColor color) {
        return this.parts.values().contains(color);
    }

    @Override
    public boolean isPowered(EnumWirePart part) {
        if (this.holder.getPipeWorld().field_72995_K) {
            return this.poweredClient.contains((Object)part);
        }
        return this.getWireSystems().getWireSystemsWithElement(new WireSystem.WireElement(this.holder.getPipePos(), part)).stream().map(wireSystem -> this.getWireSystems().wireSystems.get(wireSystem)).filter(Objects::nonNull).reduce(Boolean::logicalOr).orElse(false);
    }

    @Override
    public boolean isAnyPowered(EnumDyeColor color) {
        return this.parts.entrySet().stream().filter(partColor -> partColor.getValue() == color).anyMatch(partColor -> this.isPowered((EnumWirePart)((Object)((Object)partColor.getKey()))));
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = new NBTTagCompound();
        int[] wiresArray = new int[this.parts.size() * 2];
        int[] i = new int[]{0};
        this.parts.forEach((part, color) -> {
            wiresArray[i[0]] = part.ordinal();
            wiresArray[i[0] + 1] = color.func_176765_a();
            i[0] = i[0] + 2;
        });
        nbt.func_74783_a("parts", wiresArray);
        return nbt;
    }

    public void readFromNbt(NBTTagCompound nbt) {
        this.parts.clear();
        int[] wiresArray = nbt.func_74759_k("parts");
        for (int i = 0; i < wiresArray.length; i += 2) {
            this.parts.put(EnumWirePart.VALUES[wiresArray[i]], EnumDyeColor.func_176764_b((int)wiresArray[i + 1]));
        }
    }

    public void writePayload(PacketBufferBC buffer, Side side) {
        if (side == Side.SERVER) {
            buffer.writeInt(this.parts.size());
            for (Map.Entry<EnumWirePart, EnumDyeColor> entry : this.parts.entrySet()) {
                buffer.writeEnumValue(entry.getKey());
                buffer.writeEnumValue((Enum)entry.getValue());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void readPayload(PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        if (side == Side.CLIENT) {
            this.parts.clear();
            int count = buffer.readInt();
            for (int i = 0; i < count; ++i) {
                EnumWirePart part = buffer.func_179257_a(EnumWirePart.class);
                EnumDyeColor colour = buffer.func_179257_a(EnumDyeColor.class);
                this.parts.put(part, colour);
            }
            this.updateBetweens(false);
        }
    }
}

