/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.statements;

import buildcraft.api.gates.IGate;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.StackUtil;
import buildcraft.transport.BCTransportSprites;
import buildcraft.transport.statements.TriggerPipeSignal;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TriggerParameterSignal
implements IStatementParameter {
    public boolean active = false;
    public EnumDyeColor colour = null;

    public TriggerParameterSignal() {
    }

    public TriggerParameterSignal(boolean active, EnumDyeColor colour) {
        this.active = active;
        this.colour = colour;
    }

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        return StackUtil.EMPTY;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getGuiSprite() {
        if (this.colour == null) {
            return null;
        }
        return BCTransportSprites.getPipeSignal(this.active, this.colour).getSprite();
    }

    @Override
    public boolean onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("active", this.active);
        if (this.colour != null) {
            nbt.func_74774_a("color", (byte)this.colour.func_176765_a());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.active = nbt.func_74767_n("active");
        if (nbt.func_74764_b("color")) {
            this.colour = EnumDyeColor.func_176764_b((int)nbt.func_74771_c("color"));
        }
    }

    @Override
    public String getDescription() {
        if (this.colour == null) {
            return null;
        }
        return String.format(LocaleUtil.localize("gate.trigger.pipe.wire." + (this.active ? "active" : "inactive")), ColourUtil.getTextFullTooltip(this.colour));
    }

    @Override
    public String getUniqueTag() {
        return "buildcraft:pipeWireTrigger";
    }

    @Override
    public IStatementParameter rotateLeft() {
        return this;
    }

    public TriggerParameterSignal[] getPossible(IStatementContainer source, IStatement stmt) {
        if (!(source instanceof IGate)) {
            return null;
        }
        IGate gate = (IGate)source;
        ArrayList<TriggerParameterSignal> poss = new ArrayList<TriggerParameterSignal>(ColourUtil.COLOURS.length * 2 + 1);
        poss.add(new TriggerParameterSignal());
        for (EnumDyeColor c : ColourUtil.COLOURS) {
            if (!TriggerPipeSignal.doesGateHaveColour(gate, c)) continue;
            poss.add(new TriggerParameterSignal(true, c));
            poss.add(new TriggerParameterSignal(false, c));
        }
        return poss.toArray(new TriggerParameterSignal[poss.size()]);
    }
}

