/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.statements;

import buildcraft.api.gates.IGate;
import buildcraft.api.statements.IActionInternalSided;
import buildcraft.api.statements.IActionSingle;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.statements.BCStatement;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.transport.BCTransportSprites;
import buildcraft.transport.BCTransportStatements;
import buildcraft.transport.plug.PluggablePulsar;
import net.minecraft.util.EnumFacing;

public class ActionPowerPulsar
extends BCStatement
implements IActionInternalSided,
IActionSingle {
    public final boolean constant;

    public ActionPowerPulsar(boolean constant) {
        super("buildcraft:pulsar." + (constant ? "constant" : "single"), "buildcraft.pulsar.constant" + (constant ? "constant" : "single"));
        this.constant = constant;
    }

    @Override
    public String getDescription() {
        return LocaleUtil.localize(this.constant ? "gate.action.pulsar.constant" : "gate.action.pulsar.single");
    }

    @Override
    public void actionActivate(EnumFacing side, IStatementContainer source, IStatementParameter[] parameters) {
        IGate gate;
        IPipeHolder pipe;
        PipePluggable plug;
        if (source instanceof IGate && (plug = (pipe = (gate = (IGate)source).getPipeHolder()).getPluggable(side)) instanceof PluggablePulsar) {
            PluggablePulsar pulsar = (PluggablePulsar)plug;
            if (this.constant) {
                pulsar.enablePulsar();
            } else {
                pulsar.addSinglePulse();
            }
        }
    }

    @Override
    public boolean singleActionTick() {
        return !this.constant;
    }

    @Override
    public SpriteHolderRegistry.SpriteHolder getSpriteHolder() {
        return this.constant ? BCTransportSprites.ACTION_PULSAR_CONSTANT : BCTransportSprites.ACTION_PULSAR_SINGLE;
    }

    @Override
    public IStatement[] getPossible() {
        return BCTransportStatements.ACTION_PULSAR;
    }
}

