/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.statements;

import buildcraft.api.gates.IGate;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.StackUtil;
import buildcraft.transport.BCTransportSprites;
import buildcraft.transport.statements.TriggerPipeSignal;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ActionParameterSignal
implements IStatementParameter {
    @Nullable
    private EnumDyeColor colour = null;

    public ActionParameterSignal() {
    }

    public ActionParameterSignal(@Nullable EnumDyeColor colour) {
        this.colour = colour;
    }

    @Nullable
    public EnumDyeColor getColor() {
        return this.colour;
    }

    @Override
    public TextureAtlasSprite getGuiSprite() {
        EnumDyeColor c = this.colour;
        if (c == null) {
            return null;
        }
        return BCTransportSprites.getPipeSignal(true, c).getSprite();
    }

    @Override
    public boolean onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        EnumDyeColor c = this.colour;
        if (c != null) {
            nbt.func_74774_a("color", (byte)c.func_176765_a());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("color")) {
            this.colour = EnumDyeColor.func_176764_b((int)nbt.func_74771_c("color"));
        }
    }

    public boolean equals(Object object) {
        if (object instanceof ActionParameterSignal) {
            ActionParameterSignal param = (ActionParameterSignal)object;
            return param.getColor() == this.getColor();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getColor());
    }

    @Override
    public String getDescription() {
        EnumDyeColor c = this.colour;
        if (c == null) {
            return null;
        }
        String format = LocaleUtil.localize("gate.action.pipe.wire");
        Object[] args = new Object[]{ColourUtil.getTextFullTooltip(c)};
        return String.format(format, args);
    }

    @Override
    public String getUniqueTag() {
        return "buildcraft:pipeWireAction";
    }

    @Override
    public IStatementParameter rotateLeft() {
        return this;
    }

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        return StackUtil.EMPTY;
    }

    @Override
    public IStatementParameter[] getPossible(IStatementContainer source, IStatement stmt) {
        if (!(source instanceof IGate)) {
            return null;
        }
        IGate gate = (IGate)source;
        ArrayList<ActionParameterSignal> poss = new ArrayList<ActionParameterSignal>(1 + ColourUtil.COLOURS.length);
        poss.add(new ActionParameterSignal());
        for (EnumDyeColor c : ColourUtil.COLOURS) {
            if (!TriggerPipeSignal.doesGateHaveColour(gate, c)) continue;
            poss.add(new ActionParameterSignal(c));
        }
        return poss.toArray(new IStatementParameter[poss.size()]);
    }
}

