/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.recipe;

import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.api.recipes.IAssemblyRecipeProvider;
import buildcraft.api.recipes.StackDefinition;
import buildcraft.lib.inventory.filter.ArrayStackFilter;
import buildcraft.lib.misc.ItemStackKey;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.recipe.ChangingItemStack;
import buildcraft.lib.recipe.ChangingObject;
import buildcraft.lib.recipe.IRecipeViewable;
import buildcraft.transport.BCTransportItems;
import buildcraft.transport.plug.FacadeBlockStateInfo;
import buildcraft.transport.plug.FacadeInstance;
import buildcraft.transport.plug.FacadeStateManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public enum FacadeAssemblyRecipes implements IAssemblyRecipeProvider,
IRecipeViewable.IRecipePowered
{
    INSTANCE;

    private static final int TIME_GAP = 500;
    private static final long MJ_COST = 64000000L;
    private static final ChangingObject<Long> MJ_COSTS;

    @Override
    @Nonnull
    public List<AssemblyRecipe> getRecipesFor(@Nonnull NonNullList<ItemStack> possible) {
        if (!StackUtil.contains(new ItemStack((Item)BCTransportItems.pipeStructure, 3), possible)) {
            return ImmutableList.of();
        }
        ArrayList<AssemblyRecipe> recipes = new ArrayList<AssemblyRecipe>();
        for (ItemStack stack : possible) {
            stack = stack.func_77946_l();
            stack.func_190920_e(1);
            List<FacadeBlockStateInfo> infos = FacadeStateManager.stackFacades.get(new ItemStackKey(stack));
            if (infos == null || infos.isEmpty()) continue;
            for (FacadeBlockStateInfo info : infos) {
                FacadeAssemblyRecipes.addRecipe(recipes, stack, info);
            }
        }
        return recipes;
    }

    private static void addRecipe(List<AssemblyRecipe> recipes, ItemStack from, FacadeBlockStateInfo info) {
        ImmutableSet stacks = ImmutableSet.of((Object)ArrayStackFilter.definition(from), (Object)ArrayStackFilter.definition(3, new Item[]{BCTransportItems.pipeStructure}));
        NBTTagCompound recipeTag = new NBTTagCompound();
        recipeTag.func_74782_a("stack", (NBTBase)from.serializeNBT());
        String name = String.format("facade-normal-%s", info.state);
        recipes.add(new AssemblyRecipe(new ResourceLocation("buildcrafttransport", name), 64000000L, (Set<StackDefinition>)stacks, FacadeAssemblyRecipes.createFacadeStack(info, false), recipeTag));
        name = String.format("facade-hollow-%s", info.state);
        recipes.add(new AssemblyRecipe(new ResourceLocation("buildcrafttransport", name), 64000000L, (Set<StackDefinition>)stacks, FacadeAssemblyRecipes.createFacadeStack(info, true), recipeTag));
    }

    public static ItemStack createFacadeStack(FacadeBlockStateInfo info, boolean isHollow) {
        ItemStack stack = BCTransportItems.plugFacade.createItemStack(FacadeInstance.createSingle(info, isHollow));
        stack.func_190920_e(6);
        return stack;
    }

    @Override
    public ChangingItemStack[] getRecipeInputs() {
        ChangingItemStack[] inputs = new ChangingItemStack[2];
        inputs[0] = ChangingItemStack.create(new ItemStack((Item)BCTransportItems.pipeStructure, 3));
        NonNullList list = NonNullList.func_191196_a();
        for (FacadeBlockStateInfo info : FacadeStateManager.validFacadeStates.values()) {
            if (!info.isVisible) continue;
            list.add((Object)info.requiredStack);
            list.add((Object)info.requiredStack);
        }
        inputs[1] = new ChangingItemStack((NonNullList<ItemStack>)list);
        inputs[1].setTimeGap(500);
        return inputs;
    }

    @Override
    public ChangingItemStack getRecipeOutputs() {
        NonNullList list = NonNullList.func_191196_a();
        for (FacadeBlockStateInfo info : FacadeStateManager.validFacadeStates.values()) {
            if (!info.isVisible) continue;
            list.add((Object)FacadeAssemblyRecipes.createFacadeStack(info, false));
            list.add((Object)FacadeAssemblyRecipes.createFacadeStack(info, true));
        }
        ChangingItemStack changing = new ChangingItemStack((NonNullList<ItemStack>)list);
        changing.setTimeGap(500);
        return changing;
    }

    @Override
    public ChangingObject<Long> getMjCost() {
        return MJ_COSTS;
    }

    @Override
    public Optional<AssemblyRecipe> getRecipe(@Nonnull ResourceLocation name, @Nullable NBTTagCompound recipeTag) {
        if (!(name.func_110624_b().equals("buildcrafttransport") && name.func_110623_a().startsWith("facade-") && recipeTag != null && recipeTag.func_74764_b("stack"))) {
            return Optional.empty();
        }
        ItemStack stack = new ItemStack(recipeTag.func_74775_l("stack"));
        List<FacadeBlockStateInfo> infos = FacadeStateManager.stackFacades.get(new ItemStackKey(stack));
        if (infos == null || infos.isEmpty()) {
            return Optional.empty();
        }
        for (FacadeBlockStateInfo info : infos) {
            ArrayList<AssemblyRecipe> recipes = new ArrayList<AssemblyRecipe>();
            FacadeAssemblyRecipes.addRecipe(recipes, stack, info);
            Optional<AssemblyRecipe> recipe = recipes.stream().filter(r -> name.equals((Object)r.name)).findFirst();
            if (!recipe.isPresent()) continue;
            return recipe;
        }
        return Optional.empty();
    }

    static {
        MJ_COSTS = new ChangingObject<Long>(new Long[]{64000000L});
    }
}

