/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.plug;

import buildcraft.api.mj.IMjRedstoneReceiver;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.api.transport.pluggable.PluggableDefinition;
import buildcraft.api.transport.pluggable.PluggableModelKey;
import buildcraft.lib.expression.DefaultContexts;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.info.ContextInfo;
import buildcraft.lib.expression.info.VariableInfo;
import buildcraft.lib.expression.node.value.NodeVariableBoolean;
import buildcraft.lib.expression.node.value.NodeVariableDouble;
import buildcraft.lib.expression.node.value.NodeVariableString;
import buildcraft.lib.misc.MathUtil;
import buildcraft.lib.misc.SoundUtil;
import buildcraft.lib.misc.data.ModelVariableData;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.transport.BCTransportItems;
import buildcraft.transport.client.model.key.KeyPlugPulsar;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PluggablePulsar
extends PipePluggable {
    public static final FunctionContext MODEL_FUNC_CTX;
    private static final NodeVariableString MODEL_SIDE;
    private static final NodeVariableDouble MODEL_STAGE;
    private static final NodeVariableBoolean MODEL_ON;
    private static final NodeVariableBoolean MODEL_AUTO;
    private static final NodeVariableBoolean MODEL_MANUAL;
    public static final ContextInfo MODEL_VAR_INFO;
    private static final int PULSE_STAGE = 20;
    private static final AxisAlignedBB[] BOXES;
    public final ModelVariableData clientModelData = new ModelVariableData();
    private boolean manuallyEnabled = false;
    private int pulseStage = 0;
    private int gateEnabledTicks;
    private int gateSinglePulses;
    private boolean lastPulsing = false;
    private boolean isPulsing = false;
    private boolean autoEnabled = false;

    public PluggablePulsar(PluggableDefinition definition, IPipeHolder holder, EnumFacing side) {
        super(definition, holder, side);
    }

    public PluggablePulsar(PluggableDefinition definition, IPipeHolder holder, EnumFacing side, NBTTagCompound nbt) {
        super(definition, holder, side);
        this.manuallyEnabled = nbt.func_74767_n("manuallyEnabled");
        this.gateEnabledTicks = nbt.func_74762_e("gateEnabledTicks");
        this.gateSinglePulses = nbt.func_74762_e("gateSinglePulses");
        this.pulseStage = MathUtil.clamp(nbt.func_74762_e("pulseStage"), 0, 20);
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        nbt.func_74757_a("manuallyEnabled", this.manuallyEnabled);
        nbt.func_74768_a("gateEnabledTicks", this.gateEnabledTicks);
        nbt.func_74768_a("gateSinglePulses", this.gateSinglePulses);
        nbt.func_74768_a("pulseStage", this.pulseStage);
        return nbt;
    }

    public PluggablePulsar(PluggableDefinition definition, IPipeHolder holder, EnumFacing side, PacketBuffer buffer) {
        super(definition, holder, side);
        this.readData(buffer);
    }

    @Override
    public void writeCreationPayload(PacketBuffer buffer) {
        super.writeCreationPayload(buffer);
        this.writeData(buffer);
    }

    @Override
    public void readPayload(PacketBuffer buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(buffer, side, ctx);
        if (side == Side.CLIENT) {
            this.readData(buffer);
        }
    }

    @Override
    public void writePayload(PacketBuffer buffer, Side side) {
        super.writePayload(buffer, side);
        if (side == Side.SERVER) {
            this.writeData(buffer);
        }
    }

    private void writeData(PacketBuffer b) {
        PacketBufferBC buffer = PacketBufferBC.asPacketBufferBc((ByteBuf)b);
        buffer.writeBoolean(this.isPulsing());
        buffer.writeBoolean(this.gateEnabledTicks > 0 || this.gateSinglePulses > 0);
        buffer.writeBoolean(this.manuallyEnabled);
        buffer.writeByte(this.pulseStage);
    }

    private void readData(PacketBuffer b) {
        PacketBufferBC buffer = PacketBufferBC.asPacketBufferBc((ByteBuf)b);
        this.isPulsing = buffer.readBoolean();
        this.autoEnabled = buffer.readBoolean();
        this.manuallyEnabled = buffer.readBoolean();
        this.pulseStage = buffer.readByte();
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return BOXES[this.side.ordinal()];
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    @Override
    public ItemStack getPickStack() {
        return new ItemStack((Item)BCTransportItems.plugPulsar);
    }

    @Override
    public void onTick() {
        if (this.holder.getPipeWorld().field_72995_K) {
            if (this.isPulsing) {
                ++this.pulseStage;
                if (this.pulseStage == 20) {
                    this.pulseStage = 0;
                }
            } else {
                this.pulseStage = 0;
            }
            this.setModelVariables(1.0f);
            this.clientModelData.tick();
            return;
        }
        boolean isOn = this.isPulsing();
        this.pulseStage = isOn ? ++this.pulseStage : 0;
        if (this.gateEnabledTicks > 0) {
            --this.gateEnabledTicks;
        }
        if (this.pulseStage == 20) {
            this.pulseStage = 0;
            IMjRedstoneReceiver rsRec = (IMjRedstoneReceiver)((Object)this.holder.getPipe().getBehaviour());
            rsRec.receivePower(1000000L, false);
            if (this.gateSinglePulses > 0) {
                --this.gateSinglePulses;
            }
        }
        if (isOn != this.lastPulsing) {
            this.lastPulsing = isOn;
            this.scheduleNetworkUpdate();
        }
    }

    @Override
    public boolean onPluggableActivate(EntityPlayer player, RayTraceResult trace, float hitX, float hitY, float hitZ) {
        if (!this.holder.getPipeWorld().field_72995_K) {
            this.manuallyEnabled = !this.manuallyEnabled;
            SoundUtil.playLeverSwitch(this.holder.getPipeWorld(), this.holder.getPipePos(), this.manuallyEnabled);
            this.scheduleNetworkUpdate();
        }
        return true;
    }

    @Override
    public PluggableModelKey getModelRenderKey(BlockRenderLayer layer) {
        if (layer == BlockRenderLayer.CUTOUT) {
            return new KeyPlugPulsar(this.side);
        }
        return null;
    }

    public void enablePulsar() {
        this.gateEnabledTicks = 10;
    }

    public void addSinglePulse() {
        ++this.gateSinglePulses;
    }

    private boolean isPulsing() {
        return this.manuallyEnabled || this.gateEnabledTicks > 0 || this.gateSinglePulses > 0;
    }

    public static void setModelVariablesForItem() {
        PluggablePulsar.MODEL_STAGE.value = 0.0;
        PluggablePulsar.MODEL_AUTO.value = false;
        PluggablePulsar.MODEL_MANUAL.value = false;
        PluggablePulsar.MODEL_ON.value = false;
        PluggablePulsar.MODEL_SIDE.value = "west";
    }

    public void setModelVariables(float partialTicks) {
        PluggablePulsar.MODEL_STAGE.value = this.isPulsing ? (double)(((float)this.pulseStage + partialTicks) / 20.0f % 1.0f) : 0.0;
        PluggablePulsar.MODEL_ON.value = this.isPulsing;
        PluggablePulsar.MODEL_MANUAL.value = this.manuallyEnabled;
        PluggablePulsar.MODEL_AUTO.value = this.autoEnabled;
        PluggablePulsar.MODEL_SIDE.value = this.side.func_176610_l();
    }

    static {
        BOXES = new AxisAlignedBB[6];
        double ll = 0.125;
        double lu = 0.25;
        double ul = 0.75;
        double uu = 0.875;
        double min = 0.3125;
        double max = 0.6875;
        PluggablePulsar.BOXES[EnumFacing.DOWN.ordinal()] = new AxisAlignedBB(min, ll, min, max, lu, max);
        PluggablePulsar.BOXES[EnumFacing.UP.ordinal()] = new AxisAlignedBB(min, ul, min, max, uu, max);
        PluggablePulsar.BOXES[EnumFacing.NORTH.ordinal()] = new AxisAlignedBB(min, min, ll, max, max, lu);
        PluggablePulsar.BOXES[EnumFacing.SOUTH.ordinal()] = new AxisAlignedBB(min, min, ul, max, max, uu);
        PluggablePulsar.BOXES[EnumFacing.WEST.ordinal()] = new AxisAlignedBB(ll, min, min, lu, max, max);
        PluggablePulsar.BOXES[EnumFacing.EAST.ordinal()] = new AxisAlignedBB(ul, min, min, uu, max, max);
        MODEL_FUNC_CTX = DefaultContexts.createWithAll();
        MODEL_SIDE = MODEL_FUNC_CTX.putVariableString("side");
        MODEL_STAGE = MODEL_FUNC_CTX.putVariableDouble("stage");
        MODEL_ON = MODEL_FUNC_CTX.putVariableBoolean("on");
        MODEL_AUTO = MODEL_FUNC_CTX.putVariableBoolean("auto");
        MODEL_MANUAL = MODEL_FUNC_CTX.putVariableBoolean("manual");
        MODEL_VAR_INFO = new ContextInfo(MODEL_FUNC_CTX);
        VariableInfo.VariableInfoString infoSide = MODEL_VAR_INFO.createInfoString("side", MODEL_SIDE);
        infoSide.cacheType = VariableInfo.CacheType.ALWAYS;
        infoSide.setIsComplete = true;
        infoSide.possibleValues.addAll(Arrays.stream(EnumFacing.field_82609_l).map(EnumFacing::func_176610_l).collect(Collectors.toList()));
        VariableInfo.VariableInfoDouble infoStage = MODEL_VAR_INFO.createInfoDouble("stage", MODEL_STAGE);
        infoStage.cacheType = VariableInfo.CacheType.IN_SET;
        infoStage.setIsComplete = false;
        infoStage.possibleValues.add(0.0);
    }
}

