/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.plug;

import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.api.transport.pluggable.PluggableDefinition;
import buildcraft.api.transport.pluggable.PluggableModelKey;
import buildcraft.lib.expression.DefaultContexts;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.info.ContextInfo;
import buildcraft.lib.expression.info.VariableInfo;
import buildcraft.lib.expression.node.value.NodeVariableBoolean;
import buildcraft.lib.expression.node.value.NodeVariableString;
import buildcraft.lib.misc.data.ModelVariableData;
import buildcraft.lib.net.IPayloadWriter;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.transport.BCTransportGuis;
import buildcraft.transport.BCTransportItems;
import buildcraft.transport.client.model.key.KeyPlugGate;
import buildcraft.transport.gate.EnumGateLogic;
import buildcraft.transport.gate.EnumGateMaterial;
import buildcraft.transport.gate.EnumGateModifier;
import buildcraft.transport.gate.GateLogic;
import buildcraft.transport.gate.GateVariant;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PluggableGate
extends PipePluggable {
    public static final FunctionContext MODEL_FUNC_CTX_STATIC;
    public static final FunctionContext MODEL_FUNC_CTX_DYNAMIC;
    private static final NodeVariableString MODEL_MATERIAL;
    private static final NodeVariableString MODEL_MODIFIER;
    private static final NodeVariableString MODEL_LOGIC;
    private static final NodeVariableString MODEL_SIDE;
    private static final NodeVariableBoolean MODEL_IS_ON;
    public static final ContextInfo MODEL_VAR_INFO;
    private static final AxisAlignedBB[] BOXES;
    public final GateLogic logic;
    public final ModelVariableData clientModelData = new ModelVariableData();

    public PluggableGate(PluggableDefinition def, IPipeHolder holder, EnumFacing side, GateVariant variant) {
        super(def, holder, side);
        this.logic = new GateLogic(this, variant);
    }

    public PluggableGate(PluggableDefinition def, IPipeHolder holder, EnumFacing side, NBTTagCompound nbt) {
        super(def, holder, side);
        this.logic = new GateLogic(this, nbt.func_74775_l("data"));
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        nbt.func_74782_a("data", (NBTBase)this.logic.writeToNbt());
        return nbt;
    }

    public PluggableGate(PluggableDefinition def, IPipeHolder holder, EnumFacing side, PacketBuffer buffer) {
        super(def, holder, side);
        this.logic = new GateLogic(this, buffer);
    }

    @Override
    public void writeCreationPayload(PacketBuffer buffer) {
        this.logic.writeCreationToBuf(buffer);
    }

    public void sendMessage(int id, IPayloadWriter writer) {
        IPipeHolder.PipeMessageReceiver to = IPipeHolder.PipeMessageReceiver.PLUGGABLES[this.side.ordinal()];
        this.holder.sendMessage(to, (PacketBuffer buffer) -> {
            buffer.writeByte(1);
            buffer.writeByte(id);
            writer.write(PacketBufferBC.asPacketBufferBc((ByteBuf)buffer));
        });
    }

    public void sendGuiMessage(int id, IPayloadWriter writer) {
        IPipeHolder.PipeMessageReceiver to = IPipeHolder.PipeMessageReceiver.PLUGGABLES[this.side.ordinal()];
        this.holder.sendGuiMessage(to, (PacketBuffer buffer) -> {
            buffer.writeByte(1);
            buffer.writeByte(id);
            writer.write(PacketBufferBC.asPacketBufferBc((ByteBuf)buffer));
        });
    }

    @Override
    public void readPayload(PacketBuffer buffer, Side side, MessageContext ctx) throws IOException {
        short id = buffer.readUnsignedByte();
        this.logic.readPayload(id, buffer, side, ctx);
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return BOXES[this.side.func_176745_a()];
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    @Override
    public ItemStack getPickStack() {
        return BCTransportItems.plugGate.getStack(this.logic.variant);
    }

    @Override
    public PluggableModelKey getModelRenderKey(BlockRenderLayer layer) {
        if (layer == BlockRenderLayer.CUTOUT) {
            return new KeyPlugGate(this.side, this.logic.variant);
        }
        return null;
    }

    @Override
    public boolean onPluggableActivate(EntityPlayer player, RayTraceResult trace, float hitX, float hitY, float hitZ) {
        if (!player.field_70170_p.field_72995_K) {
            BlockPos pos = this.holder.getPipePos();
            int x = pos.func_177958_n();
            int y = pos.func_177956_o() << 3 | this.side.ordinal();
            int z = pos.func_177952_p();
            BCTransportGuis.GATE.openGui(player, x, y, z);
        }
        return true;
    }

    @Override
    public void onTick() {
        this.logic.onTick();
        if (this.holder.getPipeWorld().field_72995_K) {
            this.clientModelData.tick();
        }
    }

    @Override
    public boolean canConnectToRedstone(@Nullable EnumFacing to) {
        return true;
    }

    public static void setClientModelVariables(EnumFacing side, GateVariant variant) {
        PluggableGate.MODEL_SIDE.value = side.func_176610_l();
        PluggableGate.MODEL_MATERIAL.value = variant.material.tag;
        PluggableGate.MODEL_MODIFIER.value = variant.modifier.tag;
        PluggableGate.MODEL_LOGIC.value = variant.logic.tag;
        PluggableGate.MODEL_IS_ON.value = false;
    }

    public void setClientModelVariables() {
        PluggableGate.setClientModelVariables(this.side, this.logic.variant);
        PluggableGate.MODEL_IS_ON.value = this.logic.isOn;
    }

    static {
        BOXES = new AxisAlignedBB[6];
        double ll = 0.125;
        double lu = 0.25;
        double ul = 0.75;
        double uu = 0.875;
        double min = 0.3125;
        double max = 0.6875;
        PluggableGate.BOXES[EnumFacing.DOWN.func_176745_a()] = new AxisAlignedBB(min, ll, min, max, lu, max);
        PluggableGate.BOXES[EnumFacing.UP.func_176745_a()] = new AxisAlignedBB(min, ul, min, max, uu, max);
        PluggableGate.BOXES[EnumFacing.NORTH.func_176745_a()] = new AxisAlignedBB(min, min, ll, max, max, lu);
        PluggableGate.BOXES[EnumFacing.SOUTH.func_176745_a()] = new AxisAlignedBB(min, min, ul, max, max, uu);
        PluggableGate.BOXES[EnumFacing.WEST.func_176745_a()] = new AxisAlignedBB(ll, min, min, lu, max, max);
        PluggableGate.BOXES[EnumFacing.EAST.func_176745_a()] = new AxisAlignedBB(ul, min, min, uu, max, max);
        MODEL_FUNC_CTX_STATIC = DefaultContexts.createWithAll();
        MODEL_MATERIAL = MODEL_FUNC_CTX_STATIC.putVariableString("material");
        MODEL_MODIFIER = MODEL_FUNC_CTX_STATIC.putVariableString("modifier");
        MODEL_LOGIC = MODEL_FUNC_CTX_STATIC.putVariableString("logic");
        MODEL_SIDE = MODEL_FUNC_CTX_STATIC.putVariableString("side");
        MODEL_FUNC_CTX_DYNAMIC = new FunctionContext(MODEL_FUNC_CTX_STATIC);
        MODEL_IS_ON = MODEL_FUNC_CTX_DYNAMIC.putVariableBoolean("on");
        MODEL_VAR_INFO = new ContextInfo(MODEL_FUNC_CTX_DYNAMIC);
        VariableInfo.VariableInfoString infoMaterial = MODEL_VAR_INFO.createInfoString("material", MODEL_MATERIAL);
        infoMaterial.cacheType = VariableInfo.CacheType.ALWAYS;
        infoMaterial.setIsComplete = true;
        infoMaterial.possibleValues.addAll(Arrays.stream(EnumGateMaterial.VALUES).map(m -> m.tag).collect(Collectors.toList()));
        VariableInfo.VariableInfoString infoModifier = MODEL_VAR_INFO.createInfoString("modifier", MODEL_MODIFIER);
        infoModifier.cacheType = VariableInfo.CacheType.ALWAYS;
        infoModifier.setIsComplete = true;
        infoModifier.possibleValues.addAll(Arrays.stream(EnumGateModifier.VALUES).map(m -> m.tag).collect(Collectors.toList()));
        VariableInfo.VariableInfoString infoLogic = MODEL_VAR_INFO.createInfoString("logic", MODEL_LOGIC);
        infoLogic.cacheType = VariableInfo.CacheType.ALWAYS;
        infoLogic.setIsComplete = true;
        infoLogic.possibleValues.addAll(Arrays.stream(EnumGateLogic.VALUES).map(m -> m.tag).collect(Collectors.toList()));
        VariableInfo.VariableInfoString infoSide = MODEL_VAR_INFO.createInfoString("side", MODEL_SIDE);
        infoSide.cacheType = VariableInfo.CacheType.ALWAYS;
        infoSide.setIsComplete = true;
        infoSide.possibleValues.addAll(Arrays.stream(EnumFacing.field_82609_l).map(EnumFacing::func_176610_l).collect(Collectors.toList()));
        VariableInfo.VariableInfoBoolean infoIsOn = MODEL_VAR_INFO.createInfoBoolean("on", MODEL_IS_ON);
        infoIsOn.cacheType = VariableInfo.CacheType.ALWAYS;
        infoIsOn.setIsComplete = true;
        infoIsOn.possibleValues = VariableInfo.VariableInfoBoolean.BooleanPossibilities.FALSE_TRUE;
    }
}

