/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.plug;

import buildcraft.api.facades.FacadeType;
import buildcraft.api.facades.IFacade;
import buildcraft.api.facades.IFacadePhasedState;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.api.transport.pluggable.PluggableDefinition;
import buildcraft.api.transport.pluggable.PluggableModelKey;
import buildcraft.lib.misc.MathUtil;
import buildcraft.lib.misc.RotationUtil;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.transport.BCTransportItems;
import buildcraft.transport.client.model.key.KeyPlugBlocker;
import buildcraft.transport.client.model.key.KeyPlugFacade;
import buildcraft.transport.plug.FacadeInstance;
import buildcraft.transport.plug.FacadePhasedState;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PluggableFacade
extends PipePluggable
implements IFacade {
    public static final int SIZE = 2;
    public final FacadeInstance states;
    public final boolean isSideSolid;
    public int activeState;

    public PluggableFacade(PluggableDefinition definition, IPipeHolder holder, EnumFacing side, FacadeInstance states) {
        super(definition, holder, side);
        this.states = states;
        this.isSideSolid = states.areAllStatesSolid(side);
    }

    public PluggableFacade(PluggableDefinition def, IPipeHolder holder, EnumFacing side, NBTTagCompound nbt) {
        super(def, holder, side);
        this.states = FacadeInstance.readFromNbt(nbt, "states");
        this.activeState = MathUtil.clamp(nbt.func_74762_e("activeState"), 0, this.states.phasedStates.length - 1);
        this.isSideSolid = this.states.areAllStatesSolid(side);
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        this.states.writeToNbt(nbt, "states");
        nbt.func_74768_a("activeState", this.activeState);
        return nbt;
    }

    public PluggableFacade(PluggableDefinition def, IPipeHolder holder, EnumFacing side, PacketBuffer buffer) {
        super(def, holder, side);
        PacketBufferBC buf = PacketBufferBC.asPacketBufferBc((ByteBuf)buffer);
        this.states = FacadeInstance.readFromBuffer(buf);
        this.isSideSolid = buf.readBoolean();
    }

    @Override
    public void writeCreationPayload(PacketBuffer buffer) {
        PacketBufferBC buf = PacketBufferBC.asPacketBufferBc((ByteBuf)buffer);
        this.states.writeToBuffer(buf);
        buf.writeBoolean(this.isSideSolid);
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return RotationUtil.rotateAABB(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), this.side);
    }

    @Override
    public boolean isBlocking() {
        return !this.states.phasedStates[this.activeState].isHollow;
    }

    @Override
    public boolean canBeConnected() {
        return !this.states.phasedStates[this.activeState].isHollow;
    }

    @Override
    public boolean isSideSolid() {
        return this.isSideSolid;
    }

    @Override
    public float getExplosionResistance(@Nullable Entity exploder, Explosion explosion) {
        return this.states.phasedStates[this.activeState].stateInfo.state.func_177230_c().func_149638_a(exploder);
    }

    @Override
    public ItemStack getPickStack() {
        return BCTransportItems.plugFacade.createItemStack(this.states);
    }

    @Override
    public PluggableModelKey getModelRenderKey(BlockRenderLayer layer) {
        if (this.states.type == FacadeType.Basic) {
            FacadePhasedState facadeState = this.states.phasedStates[this.activeState];
            IBlockState blockState = facadeState.stateInfo.state;
            BlockRenderLayer targetLayer = blockState.func_177230_c().func_180664_k();
            if (targetLayer == BlockRenderLayer.TRANSLUCENT ? layer != targetLayer : layer == BlockRenderLayer.TRANSLUCENT) {
                return null;
            }
            return new KeyPlugFacade(layer, this.side, blockState, facadeState.isHollow);
        }
        if (layer == BlockRenderLayer.CUTOUT) {
            return new KeyPlugBlocker(this.side);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getBlockColor(int tintIndex) {
        FacadePhasedState state = this.states.phasedStates[this.activeState];
        return Minecraft.func_71410_x().func_184125_al().func_186724_a(state.stateInfo.state, (IBlockAccess)this.holder.getPipeWorld(), this.holder.getPipePos(), tintIndex);
    }

    @Override
    public FacadeType getType() {
        return this.states.getType();
    }

    @Override
    public IFacadePhasedState[] getPhasedStates() {
        return this.states.getPhasedStates();
    }
}

