/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.plug;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import buildcraft.api.facades.IFacade;
import buildcraft.api.facades.IFacadePhasedState;
import buildcraft.api.facades.IFacadeRegistry;
import buildcraft.api.facades.IFacadeState;
import buildcraft.lib.misc.BlockUtil;
import buildcraft.lib.misc.ItemStackKey;
import buildcraft.lib.misc.StackUtil;
import buildcraft.transport.plug.FacadeBlockStateInfo;
import buildcraft.transport.plug.FacadeInstance;
import buildcraft.transport.plug.FacadePhasedState;
import buildcraft.transport.recipe.FacadeSwapRecipe;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public enum FacadeStateManager implements IFacadeRegistry
{
    INSTANCE;

    public static final boolean DEBUG;
    public static final SortedMap<IBlockState, FacadeBlockStateInfo> validFacadeStates;
    public static final Map<ItemStackKey, List<FacadeBlockStateInfo>> stackFacades;
    public static FacadeBlockStateInfo defaultState;
    public static FacadeBlockStateInfo previewState;
    private static final String STR_SUCCESS = "success";
    private static final String STR_PASS = "pass";
    private static final Map<Block, String> disabledBlocks;
    private static final Map<IBlockState, ItemStack> customBlocks;

    public static FacadeBlockStateInfo getInfoForBlock(Block block) {
        return FacadeStateManager.getInfoForState(block.func_176223_P());
    }

    private static FacadeBlockStateInfo getInfoForState(IBlockState state) {
        return (FacadeBlockStateInfo)validFacadeStates.get(state);
    }

    public static void receiveInterModComms(FMLInterModComms.IMCMessage message) {
        String id = message.key;
        if ("facade_disable_block".equals(id)) {
            if (!message.isResourceLocationMessage()) {
                BCLog.logger.warn("[facade.imc] Received an invalid IMC message from " + message.getSender() + " - " + id + " should have a resourcelocation value, not a " + message);
                return;
            }
            ResourceLocation loc = message.getResourceLocationValue();
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)loc);
            if (block == Blocks.field_150350_a) {
                BCLog.logger.warn("[facade.imc] Received an invalid IMC message from " + message.getSender() + " - " + id + " should have a valid block target, not " + block + " (" + message + ")");
                return;
            }
            disabledBlocks.put(block, message.getSender());
        } else if ("facade_custom_map_block_item".equals(id)) {
            if (!message.isNBTMessage()) {
                BCLog.logger.warn("[facade.imc] Received an invalid IMC message from " + message.getSender() + " - " + id + " should have an nbt value, not a " + message);
                return;
            }
            NBTTagCompound nbt = message.getNBTValue();
            String regName = nbt.func_74779_i("block_registry_name");
            int meta = nbt.func_74762_e("block_meta");
            ItemStack stack = new ItemStack(nbt.func_74775_l("item_stack"));
            if (regName.isEmpty()) {
                BCLog.logger.warn("[facade.imc] Received an invalid IMC message from " + message.getSender() + " - " + id + " should have a registry name for the block, stored as " + "block_registry_name");
                return;
            }
            if (stack.func_190926_b()) {
                BCLog.logger.warn("[facade.imc] Received an invalid IMC message from " + message.getSender() + " - " + id + " should have a valid ItemStack stored in " + "item_stack");
                return;
            }
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(regName));
            if (block == Blocks.field_150350_a) {
                BCLog.logger.warn("[facade.imc] Received an invalid IMC message from " + message.getSender() + " - " + id + " should have a valid block target, not " + block + " (" + message + ")");
                return;
            }
            IBlockState state = block.func_176203_a(meta);
            customBlocks.put(state, stack);
        }
    }

    private static String isValidFacadeBlock(Block block) {
        String disablingMod = disabledBlocks.get(block);
        if (disablingMod != null) {
            return "it has been disabled by " + disablingMod;
        }
        if (block instanceof IFluidBlock || block instanceof BlockLiquid) {
            return "it is a fluid block";
        }
        if (block instanceof BlockGlass || block instanceof BlockStainedGlass) {
            return STR_SUCCESS;
        }
        return STR_PASS;
    }

    private static String isValidFacadeState(IBlockState state) {
        if (state.func_177230_c().hasTileEntity(state)) {
            return "it has a tile entity";
        }
        if (state.func_185901_i() != EnumBlockRenderType.MODEL) {
            return "it doesn't have a normal model";
        }
        if (!state.func_185917_h()) {
            return "it isn't a full cube";
        }
        return STR_SUCCESS;
    }

    @Nonnull
    private static ItemStack getRequiredStack(IBlockState state) {
        ItemStack stack = customBlocks.get(state);
        if (stack != null) {
            return stack;
        }
        Block block = state.func_177230_c();
        return new ItemStack(block, 1, block.func_180651_a(state));
    }

    public static void postInit() {
        defaultState = new FacadeBlockStateInfo(Blocks.field_150350_a.func_176223_P(), StackUtil.EMPTY, ImmutableSet.of());
        for (Block block : ForgeRegistries.BLOCKS) {
            HashMap vars;
            String result = FacadeStateManager.isValidFacadeBlock(block);
            if (result != STR_PASS && result != STR_SUCCESS) {
                if (!DEBUG) continue;
                BCLog.logger.info("[transport.facade] Disallowed block " + block.getRegistryName() + " because " + result);
                continue;
            }
            if (DEBUG && result == STR_SUCCESS) {
                BCLog.logger.info("[transport.facade] Allowed block " + block.getRegistryName());
            }
            HashSet<IBlockState> checkedStates = new HashSet<IBlockState>();
            HashMap<IBlockState, ItemStack> usedStates = new HashMap<IBlockState, ItemStack>();
            HashMap varyingProperties = new HashMap();
            for (IBlockState iBlockState : block.func_176194_O().func_177619_a()) {
                IBlockState iBlockState2 = block.func_176203_a(block.func_176201_c(iBlockState));
                if (!checkedStates.add(iBlockState2)) continue;
                if (result != STR_SUCCESS) {
                    result = FacadeStateManager.isValidFacadeState(iBlockState2);
                    if (result == STR_SUCCESS) {
                        if (DEBUG) {
                            BCLog.logger.info("[transport.facade] Allowed state " + iBlockState2);
                        }
                    } else {
                        if (!DEBUG) continue;
                        BCLog.logger.info("[transport.facade] Disallowed state " + iBlockState2 + " because " + result);
                        continue;
                    }
                }
                ItemStack stack = FacadeStateManager.getRequiredStack(iBlockState2);
                usedStates.put(iBlockState2, stack);
                ItemStackKey stackKey = new ItemStackKey(stack);
                vars = (Map)varyingProperties.get(stackKey);
                if (vars == null) {
                    vars = new HashMap();
                    vars.putAll(iBlockState2.func_177228_b());
                    varyingProperties.put(stackKey, vars);
                    continue;
                }
                for (Map.Entry entry : iBlockState2.func_177228_b().entrySet()) {
                    IProperty prop = (IProperty)entry.getKey();
                    Comparable value = (Comparable)entry.getValue();
                    if (vars.get(prop) == value) continue;
                    vars.put(prop, null);
                }
            }
            for (Map.Entry entry : usedStates.entrySet()) {
                IBlockState state = (IBlockState)entry.getKey();
                ItemStack stack = (ItemStack)entry.getValue();
                vars = (HashMap)varyingProperties.get(new ItemStackKey(stack));
                vars.values().removeIf(Objects::nonNull);
                FacadeBlockStateInfo info = new FacadeBlockStateInfo(state, stack, ImmutableSet.copyOf(vars.keySet()));
                validFacadeStates.put(state, info);
                if (info.requiredStack.func_190926_b()) continue;
                ItemStackKey stackKey = new ItemStackKey(info.requiredStack);
                stackFacades.computeIfAbsent(stackKey, k -> new ArrayList()).add(info);
            }
        }
        previewState = (FacadeBlockStateInfo)validFacadeStates.get(Blocks.field_150336_V.func_176223_P());
        FacadeSwapRecipe.genRecipes();
    }

    @Override
    public Collection<? extends IFacadeState> getValidFacades() {
        return validFacadeStates.values();
    }

    @Override
    public IFacadePhasedState createPhasedState(IFacadeState state, boolean isHollow, EnumDyeColor activeColor) {
        return new FacadePhasedState((FacadeBlockStateInfo)state, isHollow, activeColor);
    }

    @Override
    public IFacade createPhasedFacade(IFacadePhasedState[] states) {
        FacadePhasedState[] realStates = new FacadePhasedState[states.length];
        for (int i = 0; i < states.length; ++i) {
            realStates[i] = (FacadePhasedState)states[i];
        }
        return new FacadeInstance(realStates);
    }

    static {
        DEBUG = BCDebugging.shouldDebugLog("transport.facade");
        disabledBlocks = new HashMap<Block, String>();
        customBlocks = new HashMap<IBlockState, ItemStack>();
        validFacadeStates = new TreeMap<IBlockState, FacadeBlockStateInfo>(BlockUtil.blockStateComparator());
        stackFacades = new HashMap<ItemStackKey, List<FacadeBlockStateInfo>>();
    }
}

