/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.plug;

import buildcraft.api.facades.IFacadePhasedState;
import buildcraft.api.facades.IFacadeState;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.transport.plug.FacadeBlockStateInfo;
import buildcraft.transport.plug.FacadeStateManager;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;

public class FacadePhasedState
implements IFacadePhasedState {
    public final FacadeBlockStateInfo stateInfo;
    public final boolean isHollow;
    @Nullable
    public final EnumDyeColor activeColour;

    public FacadePhasedState(FacadeBlockStateInfo stateInfo, boolean isHollow, EnumDyeColor activeColour) {
        this.stateInfo = stateInfo;
        this.isHollow = isHollow;
        this.activeColour = activeColour;
    }

    public static FacadePhasedState readFromNbt(NBTTagCompound nbt) {
        FacadeBlockStateInfo stateInfo = FacadeStateManager.defaultState;
        if (nbt.func_74764_b("state")) {
            try {
                IBlockState blockState = NBTUtil.func_190008_d((NBTTagCompound)nbt.func_74775_l("state"));
                stateInfo = (FacadeBlockStateInfo)FacadeStateManager.validFacadeStates.get(blockState);
                if (stateInfo == null) {
                    stateInfo = FacadeStateManager.defaultState;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        boolean isHollow = nbt.func_74767_n("isHollow");
        EnumDyeColor colour = NBTUtilBC.readEnum(nbt.func_74781_a("activeColour"), EnumDyeColor.class);
        return new FacadePhasedState(stateInfo, isHollow, colour);
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("state", (NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)this.stateInfo.state));
        nbt.func_74757_a("isHollow", this.isHollow);
        if (this.activeColour != null) {
            nbt.func_74782_a("activeColour", NBTUtilBC.writeEnum(this.activeColour));
        }
        return nbt;
    }

    public static FacadePhasedState readFromBuffer(PacketBufferBC buf) {
        IBlockState state = MessageUtil.readBlockState(buf);
        boolean isHollow = buf.readBoolean();
        EnumDyeColor colour = MessageUtil.readEnumOrNull((ByteBuf)buf, EnumDyeColor.class);
        FacadeBlockStateInfo info = (FacadeBlockStateInfo)FacadeStateManager.validFacadeStates.get(state);
        if (info == null) {
            info = FacadeStateManager.defaultState;
        }
        return new FacadePhasedState(info, isHollow, colour);
    }

    public void writeToBuffer(PacketBufferBC buf) {
        MessageUtil.writeBlockState(buf, this.stateInfo.state);
        buf.writeBoolean(this.isHollow);
        MessageUtil.writeEnumOrNull((ByteBuf)buf, this.activeColour);
    }

    public FacadePhasedState withSwappedIsHollow() {
        return new FacadePhasedState(this.stateInfo, !this.isHollow, this.activeColour);
    }

    public FacadePhasedState withColour(EnumDyeColor colour) {
        return new FacadePhasedState(this.stateInfo, this.isHollow, colour);
    }

    public boolean isSideSolid(EnumFacing side) {
        return this.stateInfo.isSideSolid[side.ordinal()];
    }

    @Override
    public IFacadeState getState() {
        return this.stateInfo;
    }

    @Override
    public boolean isHollow() {
        return this.isHollow;
    }

    @Override
    public EnumDyeColor getActiveColor() {
        return this.activeColour;
    }
}

