/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.plug;

import buildcraft.api.facades.FacadeType;
import buildcraft.api.facades.IFacade;
import buildcraft.api.facades.IFacadePhasedState;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.transport.plug.FacadeBlockStateInfo;
import buildcraft.transport.plug.FacadePhasedState;
import buildcraft.transport.plug.FacadeStateManager;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;

public class FacadeInstance
implements IFacade {
    public final FacadePhasedState[] phasedStates;
    public final FacadeType type;

    public FacadeInstance(FacadePhasedState[] phasedStates) {
        if (phasedStates == null) {
            throw new NullPointerException("phasedStates");
        }
        if (phasedStates.length == 0) {
            throw new IllegalArgumentException("phasedStates.length was 0");
        }
        if (phasedStates.length > 17) {
            throw new IllegalArgumentException("phasedStates.length was > 17");
        }
        this.phasedStates = phasedStates;
        this.type = phasedStates.length == 1 ? FacadeType.Basic : FacadeType.Phased;
    }

    public static FacadeInstance createSingle(FacadeBlockStateInfo info, boolean isHollow) {
        return new FacadeInstance(new FacadePhasedState[]{new FacadePhasedState(info, isHollow, null)});
    }

    public static FacadeInstance readFromNbt(NBTTagCompound nbt, String subTag) {
        NBTTagList list = nbt.func_150295_c(subTag, 10);
        if (list.func_82582_d()) {
            return new FacadeInstance(new FacadePhasedState[]{new FacadePhasedState(FacadeStateManager.defaultState, false, null)});
        }
        FacadePhasedState[] states = new FacadePhasedState[list.func_74745_c()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            states[i] = FacadePhasedState.readFromNbt(list.func_150305_b(i));
        }
        return new FacadeInstance(states);
    }

    public void writeToNbt(NBTTagCompound nbt, String subTag) {
        NBTTagList list = new NBTTagList();
        for (FacadePhasedState state : this.phasedStates) {
            list.func_74742_a((NBTBase)state.writeToNbt());
        }
        nbt.func_74782_a(subTag, (NBTBase)list);
    }

    public static FacadeInstance readFromBuffer(PacketBufferBC buf) {
        int count = buf.readFixedBits(5);
        FacadePhasedState[] states = new FacadePhasedState[count];
        for (int i = 0; i < count; ++i) {
            states[i] = FacadePhasedState.readFromBuffer(buf);
        }
        return new FacadeInstance(states);
    }

    public void writeToBuffer(PacketBufferBC buf) {
        buf.writeFixedBits(this.phasedStates.length, 5);
        for (FacadePhasedState phasedState : this.phasedStates) {
            phasedState.writeToBuffer(buf);
        }
    }

    public boolean canAddColour(EnumDyeColor colour) {
        for (FacadePhasedState state : this.phasedStates) {
            if (state.activeColour != colour) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public FacadeInstance withState(FacadePhasedState state) {
        if (this.canAddColour(state.activeColour)) {
            FacadePhasedState[] newStates = Arrays.copyOf(this.phasedStates, this.phasedStates.length + 1);
            newStates[newStates.length - 1] = state;
            return new FacadeInstance(newStates);
        }
        return null;
    }

    public FacadePhasedState getCurrentStateForStack() {
        int count = this.phasedStates.length;
        if (count == 1) {
            return this.phasedStates[0];
        }
        int now = (int)(System.currentTimeMillis() % 100000L);
        return this.phasedStates[now / 500 % count];
    }

    public FacadeInstance withSwappedIsHollow() {
        FacadePhasedState[] newStates = Arrays.copyOf(this.phasedStates, this.phasedStates.length);
        for (int i = 0; i < newStates.length; ++i) {
            newStates[i] = newStates[i].withSwappedIsHollow();
        }
        return new FacadeInstance(newStates);
    }

    public boolean areAllStatesSolid(EnumFacing side) {
        for (FacadePhasedState state : this.phasedStates) {
            if (state.isSideSolid(side)) continue;
            return false;
        }
        return true;
    }

    @Override
    public FacadeType getType() {
        return this.type;
    }

    @Override
    public IFacadePhasedState[] getPhasedStates() {
        return this.phasedStates;
    }
}

