/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe.behaviour;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjRedstoneReceiver;
import buildcraft.api.mj.MjBattery;
import buildcraft.api.mj.MjCapabilityHelper;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.transport.pipe.IFlowFluid;
import buildcraft.api.transport.pipe.IFlowItems;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.PipeBehaviour;
import buildcraft.api.transport.pipe.PipeEventFluid;
import buildcraft.api.transport.pipe.PipeEventHandler;
import buildcraft.lib.inventory.filter.StackFilter;
import buildcraft.transport.BCTransportConfig;
import buildcraft.transport.pipe.behaviour.PipeBehaviourDirectional;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;

public class PipeBehaviourWood
extends PipeBehaviourDirectional
implements IMjRedstoneReceiver,
IDebuggable {
    private final MjBattery mjBattery = new MjBattery(2000000L);
    private final MjCapabilityHelper mjCaps = new MjCapabilityHelper(this);

    public PipeBehaviourWood(IPipe pipe) {
        super(pipe);
    }

    public PipeBehaviourWood(IPipe pipe, NBTTagCompound nbt) {
        super(pipe, nbt);
        this.mjBattery.deserializeNBT(nbt.func_74775_l("mjBattery"));
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        nbt.func_74782_a("mjBattery", (NBTBase)this.mjBattery.serializeNBT());
        return nbt;
    }

    @Override
    public int getTextureIndex(EnumFacing face) {
        return face != null && face == this.getCurrentDir() ? 1 : 0;
    }

    @Override
    public boolean canConnect(EnumFacing face, PipeBehaviour other) {
        return !(other instanceof PipeBehaviourWood);
    }

    @Override
    protected boolean canFaceDirection(EnumFacing dir) {
        return this.pipe.getConnectedType(dir) == IPipe.ConnectedType.TILE;
    }

    @PipeEventHandler
    public void fluidSideCheck(PipeEventFluid.SideCheck sideCheck) {
        if (this.currentDir.face != null) {
            sideCheck.disallow(this.currentDir.face);
        }
    }

    @Override
    public void onTick() {
        if (this.pipe.getHolder().getPipeWorld().field_72995_K) {
            return;
        }
        if (this.currentDir == EnumPipePart.CENTER) {
            this.advanceFacing();
        } else if (!this.canFaceDirection(this.getCurrentDir())) {
            this.currentDir = EnumPipePart.CENTER;
        }
        this.mjBattery.tick(this.pipe.getHolder().getPipeWorld(), this.pipe.getHolder().getPipePos());
        long potential = this.mjBattery.getStored();
        if (potential > 0L) {
            if (this.pipe.getFlow() instanceof IFlowItems) {
                int extracted;
                IFlowItems flow = (IFlowItems)((Object)this.pipe.getFlow());
                int maxItems = (int)(potential / BCTransportConfig.mjPerItem);
                if (maxItems > 0 && (extracted = this.extractItems(flow, this.getCurrentDir(), maxItems)) > 0) {
                    this.mjBattery.extractPower((long)extracted * BCTransportConfig.mjPerItem);
                    return;
                }
            } else if (this.pipe.getFlow() instanceof IFlowFluid) {
                FluidStack extracted;
                IFlowFluid flow = (IFlowFluid)((Object)this.pipe.getFlow());
                int maxMillibuckets = (int)(potential / BCTransportConfig.mjPerMillibucket);
                if (maxMillibuckets > 0 && (extracted = this.extractFluid(flow, this.getCurrentDir(), maxMillibuckets)) != null && extracted.amount > 0) {
                    this.mjBattery.extractPower((long)extracted.amount * BCTransportConfig.mjPerMillibucket);
                    return;
                }
            }
            this.mjBattery.extractPower(0L, 50000L);
        }
    }

    protected int extractItems(IFlowItems flow, EnumFacing dir, int count) {
        return flow.tryExtractItems(count, dir, null, StackFilter.ALL);
    }

    @Nullable
    protected FluidStack extractFluid(IFlowFluid flow, EnumFacing dir, int millibuckets) {
        return flow.tryExtractFluid(millibuckets, dir, null);
    }

    @Override
    public boolean canConnect(@Nonnull IMjConnector other) {
        return true;
    }

    @Override
    public long getPowerRequested() {
        return 1000000L;
    }

    @Override
    public long receivePower(long microJoules, boolean simulate) {
        return this.mjBattery.addPowerChecking(microJoules, simulate);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        return this.mjCaps.getCapability(capability, facing);
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("Power = " + this.mjBattery.getDebugString());
        left.add("Facing = " + (Object)((Object)this.currentDir));
    }
}

