/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe.behaviour;

import buildcraft.api.inventory.IItemTransactor;
import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjRedstoneReceiver;
import buildcraft.api.mj.MjBattery;
import buildcraft.api.mj.MjCapabilityHelper;
import buildcraft.api.transport.pipe.IFlowFluid;
import buildcraft.api.transport.pipe.IFlowItems;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.PipeBehaviour;
import buildcraft.api.transport.pipe.PipeEventHandler;
import buildcraft.api.transport.pipe.PipeEventItem;
import buildcraft.api.transport.pipe.PipeFlow;
import buildcraft.lib.inventory.ItemTransactorHelper;
import buildcraft.lib.inventory.filter.StackFilter;
import buildcraft.lib.misc.BoundingBoxUtil;
import buildcraft.lib.misc.VecUtil;
import java.util.List;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;

public class PipeBehaviourObsidian
extends PipeBehaviour
implements IMjRedstoneReceiver {
    private static final double INSERT_SPEED = 0.04;
    private static final int DROP_GAP = 20;
    private final MjBattery battery = new MjBattery(256000000L);
    private final MjCapabilityHelper mjCaps = new MjCapabilityHelper(this);
    private final WeakHashMap<EntityItem, Long> entityDropTime = new WeakHashMap();
    private int toWaitTicks = 0;

    public PipeBehaviourObsidian(IPipe pipe) {
        super(pipe);
    }

    public PipeBehaviourObsidian(IPipe pipe, NBTTagCompound nbt) {
        super(pipe, nbt);
        this.battery.deserializeNBT(nbt.func_74775_l("battery"));
        this.toWaitTicks = 20;
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        nbt.func_74782_a("battery", (NBTBase)this.battery.serializeNBT());
        return nbt;
    }

    @Override
    public void onTick() {
        if (this.pipe.getHolder().getPipeWorld().field_72995_K) {
            return;
        }
        --this.toWaitTicks;
        if (this.toWaitTicks > 0) {
            return;
        }
        this.toWaitTicks = 0;
        if (this.battery.getStored() > 0L) {
            EnumFacing openFace = this.getOpenFace();
            if (openFace != null) {
                for (int distance = 1; distance < 5; ++distance) {
                    if (!this.suckEntity(openFace, distance)) continue;
                    return;
                }
            }
            this.battery.extractPower(0L, 500000L);
        }
    }

    @Override
    public void onEntityCollide(Entity entity) {
        if (this.pipe.getHolder().getPipeWorld().field_72995_K) {
            return;
        }
        EnumFacing openFace = this.getOpenFace();
        if (openFace != null) {
            this.trySuckEntity(entity, openFace, false);
        }
    }

    private EnumFacing getOpenFace() {
        EnumFacing openFace = null;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (!this.pipe.isConnected(face)) continue;
            if (openFace == null) {
                openFace = face.func_176734_d();
                continue;
            }
            return null;
        }
        return openFace;
    }

    protected boolean suckEntity(EnumFacing openFace, int distance) {
        AxisAlignedBB aabb = this.getSuckingBox(openFace, distance);
        List discoveredEntities = this.pipe.getHolder().getPipeWorld().func_72872_a(Entity.class, aabb);
        for (Entity entity : discoveredEntities) {
            if (!this.trySuckEntity(entity, openFace, true)) continue;
            return true;
        }
        return false;
    }

    protected AxisAlignedBB getSuckingBox(EnumFacing openFace, int distance) {
        AxisAlignedBB bb = BoundingBoxUtil.makeAround(VecUtil.convertCenter((Vec3i)this.pipe.getHolder().getPipePos()), 0.4);
        switch (openFace) {
            default: {
                return bb.func_72317_d((double)(-distance), 0.0, 0.0).func_72314_b(0.5, (double)distance, (double)distance);
            }
            case EAST: {
                return bb.func_72317_d((double)distance, 0.0, 0.0).func_72314_b(0.5, (double)distance, (double)distance);
            }
            case DOWN: {
                return bb.func_72317_d(0.0, (double)(-distance), 0.0).func_72314_b((double)distance, 0.5, (double)distance);
            }
            case UP: {
                return bb.func_72317_d(0.0, (double)distance, 0.0).func_72314_b((double)distance, 0.5, (double)distance);
            }
            case NORTH: {
                return bb.func_72317_d(0.0, 0.0, (double)(-distance)).func_72314_b((double)distance, (double)distance, 0.5);
            }
            case SOUTH: 
        }
        return bb.func_72317_d(0.0, 0.0, (double)distance).func_72314_b((double)distance, (double)distance, 0.5);
    }

    protected boolean trySuckEntity(Entity entity, EnumFacing faceFrom, boolean requiresPower) {
        int max;
        ItemStack extracted;
        PipeFlow flow;
        if (entity.field_70128_L || requiresPower && this.battery.getStored() < 1000000L) {
            return false;
        }
        if (entity instanceof EntityLivingBase) {
            return false;
        }
        Long tickPickupObj = this.entityDropTime.get(entity);
        if (tickPickupObj != null) {
            long tickPickup = tickPickupObj;
            long tickNow = this.pipe.getHolder().getPipeWorld().func_82737_E();
            if (tickNow < tickPickup) {
                return false;
            }
            this.entityDropTime.remove(entity);
        }
        IFlowItems flowItem = (flow = this.pipe.getFlow()) instanceof IFlowItems ? (IFlowItems)((Object)flow) : null;
        IFlowFluid flowFluid = flow instanceof IFlowFluid ? (IFlowFluid)((Object)flow) : null;
        IItemTransactor transactor = ItemTransactorHelper.getTransactorForEntity(entity, faceFrom.func_176734_d());
        if (flowItem != null && !(extracted = transactor.extract(StackFilter.ALL, 1, max = requiresPower ? 1 : Integer.MAX_VALUE, false)).func_190926_b()) {
            flowItem.insertItemsForce(extracted, faceFrom, null, 0.04);
            this.battery.extractPower(1000000L);
            return true;
        }
        if (flowFluid != null) {
            // empty if block
        }
        return false;
    }

    @PipeEventHandler
    public void onPipeDrop(PipeEventItem.Drop drop) {
        this.entityDropTime.put(drop.getEntity(), this.pipe.getHolder().getPipeWorld().func_82737_E() + 20L);
    }

    @Override
    public boolean canConnect(@Nonnull IMjConnector other) {
        return true;
    }

    @Override
    public long getPowerRequested() {
        return 1000000L;
    }

    @Override
    public long receivePower(long microJoules, boolean simulate) {
        return this.battery.addPowerChecking(microJoules, simulate);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        T cap = this.mjCaps.getCapability(capability, facing);
        if (cap != null) {
            return cap;
        }
        return super.getCapability(capability, facing);
    }
}

