/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe;

import buildcraft.api.core.BCLog;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.api.transport.pluggable.PluggableDefinition;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.transport.tile.TilePipeHolder;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public final class PluggableHolder {
    private static final int ID_REMOVE_PLUG = 0;
    private static final int ID_UPDATE_PLUG = 1;
    private static final int ID_CREATE_PLUG = 2;
    public final TilePipeHolder holder;
    public final EnumFacing side;
    public PipePluggable pluggable;
    private boolean lastGeneralExisted = false;

    public PluggableHolder(TilePipeHolder holder, EnumFacing side) {
        this.holder = holder;
        this.side = side;
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.pluggable != null) {
            nbt.func_74778_a("id", this.pluggable.definition.identifier.toString());
            nbt.func_74782_a("data", (NBTBase)this.pluggable.writeToNbt());
        }
        return nbt;
    }

    public void readFromNbt(NBTTagCompound nbt) {
        if (nbt.func_82582_d()) {
            this.pluggable = null;
            return;
        }
        String id = nbt.func_74779_i("id");
        NBTTagCompound data = nbt.func_74775_l("data");
        ResourceLocation identifier = new ResourceLocation(id);
        PluggableDefinition def = PipeApi.pluggableRegistry.getDefinition(identifier);
        if (def == null) {
            BCLog.logger.warn("Unknown pluggable id '" + id + "'");
            throw new Error("Def was null!");
        }
        this.pluggable = def.readFromNbt(this.holder, this.side, data);
        this.holder.eventBus.registerHandler(this.pluggable);
        this.lastGeneralExisted = true;
    }

    public void writeCreationPayload(PacketBuffer buffer) {
        if (this.pluggable == null) {
            buffer.writeByte(0);
        } else {
            buffer.writeByte(2);
            buffer.func_180714_a(this.pluggable.definition.identifier.toString());
            this.pluggable.writeCreationPayload(buffer);
        }
    }

    public void readCreationPayload(PacketBuffer buffer) {
        short id = buffer.readUnsignedByte();
        if (id == 2) {
            this.readCreateInternal(buffer);
        } else {
            this.holder.eventBus.unregisterHandler(this.pluggable);
            this.pluggable = null;
        }
    }

    private void readCreateInternal(PacketBuffer buffer) {
        ResourceLocation identifier = new ResourceLocation(buffer.func_150789_c(256));
        PluggableDefinition def = PipeApi.pluggableRegistry.getDefinition(identifier);
        if (def == null) {
            throw new IllegalStateException("Unknown remote pluggable \"" + identifier + "\"");
        }
        this.pluggable = def.loadFromBuffer(this.holder, this.side, buffer);
        this.holder.eventBus.registerHandler(this.pluggable);
    }

    public void writePayload(PacketBufferBC buffer, Side netSide) {
        if (this.pluggable == null) {
            this.lastGeneralExisted = false;
            buffer.writeByte(0);
        } else if (this.lastGeneralExisted) {
            buffer.writeByte(1);
            this.pluggable.writePayload(buffer, netSide);
        } else {
            this.lastGeneralExisted = true;
            this.writeCreationPayload(buffer);
        }
    }

    public void readPayload(PacketBufferBC buffer, Side netSide, MessageContext ctx) throws IOException {
        short id = buffer.readUnsignedByte();
        if (id == 0) {
            this.holder.eventBus.unregisterHandler(this.pluggable);
            this.pluggable = null;
        } else if (id == 1) {
            this.pluggable.readPayload(buffer, netSide, ctx);
        } else if (id == 2) {
            this.readCreateInternal(buffer);
        } else {
            BCLog.logger.warn("[PluggableHolder] Unknown ID " + id);
        }
    }

    public void onTick() {
        if (this.pluggable != null) {
            this.pluggable.onTick();
        }
    }
}

