/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe;

import buildcraft.api.core.InvalidInputDataException;
import buildcraft.api.transport.pipe.IItemPipe;
import buildcraft.api.transport.pipe.IPipeRegistry;
import buildcraft.api.transport.pipe.PipeDefinition;
import buildcraft.lib.item.ItemManager;
import buildcraft.transport.item.ItemPipeHolder;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public enum PipeRegistry implements IPipeRegistry
{
    INSTANCE;

    private final Map<ResourceLocation, PipeDefinition> definitions = new HashMap<ResourceLocation, PipeDefinition>();
    private final Map<PipeDefinition, IItemPipe> pipeItems = new IdentityHashMap<PipeDefinition, IItemPipe>();

    @Override
    public ItemPipeHolder registerPipeAndItem(PipeDefinition definition) {
        this.registerPipe(definition);
        ItemPipeHolder item = new ItemPipeHolder(definition);
        ItemManager.register(item);
        this.setItemForPipe(definition, item);
        return item;
    }

    @Override
    public void registerPipe(PipeDefinition definition) {
        this.definitions.put(definition.identifier, definition);
    }

    @Override
    public void setItemForPipe(PipeDefinition definition, IItemPipe item) {
        if (definition == null) {
            throw new NullPointerException("definition");
        }
        if (item == null) {
            this.pipeItems.remove(definition);
        } else {
            this.pipeItems.put(definition, item);
        }
    }

    @Override
    public IItemPipe getItemForPipe(PipeDefinition definition) {
        return this.pipeItems.get(definition);
    }

    @Override
    @Nullable
    public PipeDefinition getDefinition(ResourceLocation identifier) {
        return this.definitions.get(identifier);
    }

    @Nonnull
    public PipeDefinition loadDefinition(String identifier) throws InvalidInputDataException {
        PipeDefinition def = this.getDefinition(new ResourceLocation(identifier));
        if (def == null) {
            throw new InvalidInputDataException("Unknown pipe definition " + identifier);
        }
        return def;
    }

    @Override
    public Iterable<PipeDefinition> getAllRegisteredPipes() {
        return ImmutableList.copyOf(this.definitions.values());
    }
}

