/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe;

import buildcraft.api.core.InvalidInputDataException;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.transport.pipe.ICustomPipeConnection;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.api.transport.pipe.PipeBehaviour;
import buildcraft.api.transport.pipe.PipeConnectionAPI;
import buildcraft.api.transport.pipe.PipeDefinition;
import buildcraft.api.transport.pipe.PipeFlow;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.transport.client.model.key.PipeModelKey;
import buildcraft.transport.pipe.DefaultPipeConnection;
import buildcraft.transport.pipe.PipeRegistry;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class Pipe
implements IPipe,
IDebuggable {
    public final IPipeHolder holder;
    public final PipeDefinition definition;
    public final PipeBehaviour behaviour;
    public final PipeFlow flow;
    private EnumDyeColor colour = null;
    private boolean updateMarked = true;
    private final EnumMap<EnumFacing, Float> connected = new EnumMap(EnumFacing.class);
    private final EnumMap<EnumFacing, Integer> textures = new EnumMap(EnumFacing.class);
    private final EnumMap<EnumFacing, IPipe.ConnectedType> types = new EnumMap(EnumFacing.class);
    @SideOnly(value=Side.CLIENT)
    private PipeModelKey lastModel;

    public Pipe(IPipeHolder holder, PipeDefinition definition) {
        this.holder = holder;
        this.definition = definition;
        this.behaviour = definition.logicConstructor.createBehaviour(this);
        this.flow = definition.flowType.creator.createFlow(this);
    }

    public Pipe(IPipeHolder holder, NBTTagCompound nbt) throws InvalidInputDataException {
        this.holder = holder;
        this.colour = NBTUtilBC.readEnum(nbt.func_74781_a("col"), EnumDyeColor.class);
        this.definition = PipeRegistry.INSTANCE.loadDefinition(nbt.func_74779_i("def"));
        this.behaviour = this.definition.logicLoader.loadBehaviour(this, nbt.func_74775_l("beh"));
        this.flow = this.definition.flowType.loader.loadFlow(this, nbt.func_74775_l("flow"));
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("col", NBTUtilBC.writeEnum(this.colour));
        nbt.func_74778_a("def", this.definition.identifier.toString());
        nbt.func_74782_a("beh", (NBTBase)this.behaviour.writeToNbt());
        nbt.func_74782_a("flow", (NBTBase)this.flow.writeToNbt());
        return nbt;
    }

    public Pipe(IPipeHolder holder, PacketBufferBC buffer, MessageContext ctx) throws IOException {
        this.holder = holder;
        try {
            this.definition = PipeRegistry.INSTANCE.loadDefinition(buffer.func_150789_c(256));
        }
        catch (InvalidInputDataException e) {
            throw new IOException(e);
        }
        this.behaviour = this.definition.logicConstructor.createBehaviour(this);
        this.readPayload(buffer, Side.CLIENT, ctx);
        this.flow = this.definition.flowType.creator.createFlow(this);
        this.flow.readPayload(0, buffer, Side.CLIENT);
    }

    public void writeCreationPayload(PacketBufferBC buffer) {
        buffer.func_180714_a(this.definition.identifier.toString());
        this.writePayload(buffer, Side.SERVER);
        this.flow.writePayload(0, buffer, Side.SERVER);
    }

    public void writePayload(PacketBufferBC buffer, Side side) {
        if (side == Side.SERVER) {
            buffer.writeByte(this.colour == null ? 0 : this.colour.func_176765_a() + 1);
            for (EnumFacing face : EnumFacing.field_82609_l) {
                Float con = this.connected.get(face);
                if (con != null && this.textures.get(face) != null) {
                    buffer.writeBoolean(true);
                    buffer.writeFloat(con.floatValue());
                    Integer tex = this.textures.get(face);
                    buffer.writeByte(tex);
                    MessageUtil.writeEnumOrNull((ByteBuf)buffer, this.types.get(face));
                    continue;
                }
                buffer.writeBoolean(false);
            }
            this.behaviour.writePayload(buffer, side);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void readPayload(PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        if (side == Side.CLIENT) {
            this.connected.clear();
            this.textures.clear();
            this.types.clear();
            short nColour = buffer.readUnsignedByte();
            this.colour = nColour == 0 ? null : EnumDyeColor.func_176764_b((int)(nColour - 1));
            for (EnumFacing face : EnumFacing.field_82609_l) {
                if (!buffer.readBoolean()) continue;
                float dist = buffer.readFloat();
                short tex = buffer.readUnsignedByte();
                this.connected.put(face, Float.valueOf(dist));
                this.textures.put(face, Integer.valueOf(tex));
                IPipe.ConnectedType type = MessageUtil.readEnumOrNull((ByteBuf)buffer, IPipe.ConnectedType.class);
                this.types.put(face, type);
            }
            this.behaviour.readPayload(buffer, side, ctx);
            PipeModelKey model = this.getModel();
            if (!model.equals(this.lastModel)) {
                this.lastModel = model;
                this.getHolder().scheduleRenderUpdate();
            }
        }
    }

    @Override
    public IPipeHolder getHolder() {
        return this.holder;
    }

    @Override
    public PipeDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public PipeBehaviour getBehaviour() {
        return this.behaviour;
    }

    @Override
    public PipeFlow getFlow() {
        return this.flow;
    }

    @Override
    public EnumDyeColor getColour() {
        return this.colour;
    }

    @Override
    public void setColour(EnumDyeColor colour) {
        this.colour = colour;
        this.markForUpdate();
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        T val = this.behaviour.getCapability(capability, facing);
        if (val != null) {
            return val;
        }
        return this.flow.getCapability(capability, facing);
    }

    public void onLoad() {
        this.updateConnections();
    }

    public void onTick() {
        this.behaviour.onTick();
        this.flow.onTick();
        if (this.updateMarked) {
            this.updateConnections();
        }
    }

    private void updateConnections() {
        IPipe oPipe;
        if (this.holder.getPipeWorld().field_72995_K) {
            return;
        }
        this.updateMarked = false;
        Object old = this.connected.clone();
        this.connected.clear();
        this.types.clear();
        this.textures.clear();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity oTile;
            PipePluggable plug = this.getHolder().getPluggable(facing);
            if (plug != null && plug.isBlocking() || (oTile = this.getHolder().getNeighbourTile(facing)) == null) continue;
            oPipe = this.getHolder().getNeighbourPipe(facing);
            if (oPipe != null) {
                PipePluggable oPlug;
                PipeBehaviour oBehaviour = oPipe.getBehaviour();
                if (oBehaviour == null || (oPlug = (PipePluggable)oTile.getCapability(PipeApi.CAP_PLUG, facing.func_176734_d())) != null && oPlug.isBlocking()) continue;
                if (Pipe.canPipesConnect(facing, this, oPipe)) {
                    this.connected.put(facing, Float.valueOf(0.25f));
                    this.types.put(facing, IPipe.ConnectedType.PIPE);
                }
            } else {
                BlockPos nPos = this.holder.getPipePos().func_177972_a(facing);
                IBlockState neighbour = this.holder.getPipeWorld().func_180495_p(nPos);
                ICustomPipeConnection cust = PipeConnectionAPI.getCustomConnection(neighbour.func_177230_c());
                if (cust == null) {
                    cust = DefaultPipeConnection.INSTANCE;
                }
                float ext = 0.25f + cust.getExtension(this.holder.getPipeWorld(), nPos, facing.func_176734_d(), neighbour);
                if (this.behaviour.canConnect(facing, oTile) & this.flow.canConnect(facing, oTile)) {
                    this.connected.put(facing, Float.valueOf(ext));
                    this.types.put(facing, IPipe.ConnectedType.TILE);
                }
            }
            if (!this.connected.containsKey(facing)) continue;
            this.textures.put(facing, this.behaviour.getTextureIndex(facing));
        }
        if (!((EnumMap)old).equals((Object)this.connected)) {
            for (EnumFacing face : EnumFacing.field_82609_l) {
                boolean n;
                boolean o = ((EnumMap)old).containsKey(face);
                if (o == (n = this.connected.containsKey(face)) || (oPipe = this.getHolder().getNeighbourPipe(face)) == null) continue;
                oPipe.markForUpdate();
            }
        }
        this.getHolder().scheduleNetworkUpdate(IPipeHolder.PipeMessageReceiver.BEHAVIOUR);
    }

    public void getDrops(NonNullList<ItemStack> toDrop) {
        Item item = (Item)PipeApi.pipeRegistry.getItemForPipe(this.definition);
        if (item != null) {
            toDrop.add((Object)new ItemStack(item, 1, this.colour == null ? 0 : 1 + this.colour.ordinal()));
        }
    }

    public static boolean canPipesConnect(EnumFacing to, IPipe one, IPipe two) {
        return Pipe.canColoursConnect(one.getColour(), two.getColour()) && Pipe.canBehavioursConnect(to, one.getBehaviour(), two.getBehaviour()) && Pipe.canFlowsConnect(to, one.getFlow(), two.getFlow());
    }

    public static boolean canColoursConnect(EnumDyeColor one, EnumDyeColor two) {
        return one == null || two == null || one == two;
    }

    public static boolean canBehavioursConnect(EnumFacing to, PipeBehaviour one, PipeBehaviour two) {
        return one.canConnect(to, two) && two.canConnect(to.func_176734_d(), one);
    }

    public static boolean canFlowsConnect(EnumFacing to, PipeFlow one, PipeFlow two) {
        return one.canConnect(to, two) && two.canConnect(to.func_176734_d(), one);
    }

    @Override
    public void markForUpdate() {
        this.updateMarked = true;
    }

    @SideOnly(value=Side.CLIENT)
    public PipeModelKey getModel() {
        int[] sides = new int[6];
        float[] mc = new float[6];
        for (EnumFacing face : EnumFacing.field_82609_l) {
            int i = face.ordinal();
            sides[i] = this.behaviour.getTextureIndex(face);
            mc[i] = this.getConnectedDist(face);
        }
        return new PipeModelKey(this.definition, this.behaviour.getTextureIndex(null), sides, mc, this.colour);
    }

    @Override
    public TileEntity getConnectedTile(EnumFacing side) {
        if (this.connected.containsKey(side)) {
            TileEntity offset = this.getHolder().getNeighbourTile(side);
            if (offset == null && !this.getHolder().getPipeWorld().field_72995_K) {
                this.markForUpdate();
            } else {
                return offset;
            }
        }
        return null;
    }

    @Override
    public IPipe getConnectedPipe(EnumFacing side) {
        if (this.connected.containsKey(side) && this.getConnectedType(side) == IPipe.ConnectedType.PIPE) {
            IPipe offset = this.getHolder().getNeighbourPipe(side);
            if (offset == null && !this.getHolder().getPipeWorld().field_72995_K) {
                this.markForUpdate();
            } else {
                return offset;
            }
        }
        return null;
    }

    @Override
    public IPipe.ConnectedType getConnectedType(EnumFacing side) {
        return this.types.get(side);
    }

    @Override
    public boolean isConnected(EnumFacing side) {
        return this.connected.containsKey(side);
    }

    public float getConnectedDist(EnumFacing face) {
        Float custom = this.connected.get(face);
        return custom == null ? 0.0f : custom.floatValue();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("Colour = " + this.colour);
        left.add("Definition = " + this.definition.identifier);
        if (this.behaviour instanceof IDebuggable) {
            left.add("Behaviour:");
            ((IDebuggable)((Object)this.behaviour)).getDebugInfo(left, right, side);
            left.add("");
        } else {
            left.add("Behaviour = " + this.behaviour.getClass());
        }
        if (this.flow instanceof IDebuggable) {
            left.add("Flow:");
            ((IDebuggable)((Object)this.flow)).getDebugInfo(left, right, side);
            left.add("");
        } else {
            left.add("Flow = " + this.flow.getClass());
        }
        for (EnumFacing face : EnumFacing.field_82609_l) {
            right.add(face + " = " + (Object)((Object)this.types.get(face)) + ", " + this.getConnectedDist(face));
        }
    }
}

