/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.item;

import buildcraft.api.facades.FacadeType;
import buildcraft.api.facades.IFacade;
import buildcraft.api.facades.IFacadeItem;
import buildcraft.api.transport.IItemPluggable;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.lib.item.ItemBC_Neptune;
import buildcraft.lib.misc.BlockUtil;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.SoundUtil;
import buildcraft.lib.misc.StackUtil;
import buildcraft.transport.BCTransportPlugs;
import buildcraft.transport.plug.FacadeBlockStateInfo;
import buildcraft.transport.plug.FacadeInstance;
import buildcraft.transport.plug.FacadePhasedState;
import buildcraft.transport.plug.FacadeStateManager;
import buildcraft.transport.plug.PluggableFacade;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPluggableFacade
extends ItemBC_Neptune
implements IItemPluggable,
IFacadeItem {
    public ItemPluggableFacade(String id) {
        super(id);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    @Nonnull
    public ItemStack createItemStack(FacadeInstance state) {
        ItemStack item = new ItemStack((Item)this);
        NBTTagCompound nbt = NBTUtilBC.getItemData(item);
        state.writeToNbt(nbt, "states");
        return item;
    }

    public static FacadeInstance getStates(@Nonnull ItemStack item) {
        NBTTagCompound nbt = NBTUtilBC.getItemData(item);
        return FacadeInstance.readFromNbt(nbt, "states");
    }

    @Override
    @Nonnull
    public ItemStack getFacadeForBlock(IBlockState state) {
        FacadeBlockStateInfo info = (FacadeBlockStateInfo)FacadeStateManager.validFacadeStates.get(state);
        if (info == null) {
            return StackUtil.EMPTY;
        }
        return this.createItemStack(FacadeInstance.createSingle(info, false));
    }

    @Override
    public PipePluggable onPlace(@Nonnull ItemStack stack, IPipeHolder holder, EnumFacing side, EntityPlayer player, EnumHand hand) {
        FacadeInstance fullState = ItemPluggableFacade.getStates(stack);
        SoundUtil.playBlockPlace(holder.getPipeWorld(), holder.getPipePos(), fullState.phasedStates[0].stateInfo.state);
        return new PluggableFacade(BCTransportPlugs.facade, holder, side, fullState);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        FacadePhasedState[] states = new FacadePhasedState[]{FacadeStateManager.getInfoForBlock(Blocks.field_150348_b).createPhased(false, null), FacadeStateManager.getInfoForBlock(Blocks.field_150344_f).createPhased(false, EnumDyeColor.RED), FacadeStateManager.getInfoForBlock(Blocks.field_150364_r).createPhased(false, EnumDyeColor.CYAN)};
        FacadeInstance inst = new FacadeInstance(states);
        subItems.add((Object)this.createItemStack(inst));
        for (FacadeBlockStateInfo info : FacadeStateManager.validFacadeStates.values()) {
            if (!info.isVisible) continue;
            subItems.add((Object)this.createItemStack(FacadeInstance.createSingle(info, false)));
            subItems.add((Object)this.createItemStack(FacadeInstance.createSingle(info, true)));
        }
    }

    public String func_77653_i(ItemStack stack) {
        FacadeInstance fullState = ItemPluggableFacade.getStates(stack);
        if (fullState.type == FacadeType.Basic) {
            String displayName = ItemPluggableFacade.getFacadeStateDisplayName(fullState.phasedStates[0]);
            return super.func_77653_i(stack) + ": " + displayName;
        }
        return LocaleUtil.localize("item.FacadePhased.name");
    }

    public static String getFacadeStateDisplayName(FacadePhasedState state) {
        ItemStack assumedStack = state.stateInfo.requiredStack;
        String s = assumedStack.func_82833_r();
        if (state.isHollow) {
            s = s + " (" + LocaleUtil.localize("item.Facade.state_hollow") + ")";
        }
        return s;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        FacadeInstance states = ItemPluggableFacade.getStates(stack);
        if (states.type == FacadeType.Phased) {
            String stateString = LocaleUtil.localize("item.FacadePhased.state");
            FacadePhasedState defaultState = null;
            for (FacadePhasedState state : states.phasedStates) {
                if (state.activeColour == null) {
                    defaultState = state;
                    continue;
                }
                tooltip.add(String.format(stateString, LocaleUtil.localizeColour(state.activeColour), ItemPluggableFacade.getFacadeStateDisplayName(state)));
            }
            if (defaultState != null) {
                tooltip.add(1, String.format(LocaleUtil.localize("item.FacadePhased.state_default"), ItemPluggableFacade.getFacadeStateDisplayName(defaultState)));
            }
        } else {
            String propertiesStart = TextFormatting.GRAY + "" + TextFormatting.ITALIC;
            FacadeBlockStateInfo info = states.phasedStates[0].stateInfo;
            BlockUtil.getPropertiesStringMap(info.state, info.varyingProperties).forEach((name, value) -> tooltip.add(propertiesStart + name + " = " + value));
        }
    }

    @Override
    public ItemStack createFacadeStack(IFacade facade) {
        return this.createItemStack((FacadeInstance)facade);
    }

    @Override
    public IFacade getFacade(ItemStack facade) {
        return ItemPluggableFacade.getStates(facade);
    }
}

