/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gui;

import buildcraft.lib.BCLibSprites;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.ledger.LedgerManager_Neptune;
import buildcraft.lib.gui.ledger.Ledger_Neptune;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.silicon.tile.TileAssemblyTable;
import buildcraft.silicon.tile.TileLaserTableBase;

public class LedgerTablePower
extends Ledger_Neptune {
    private static final int OVERLAY_COLOUR = -2855905;
    private static final int SUB_HEADER_COLOUR = -5591112;
    private static final int TEXT_COLOUR = -16777216;
    public final TileLaserTableBase tile;

    public LedgerTablePower(LedgerManager_Neptune manager, TileAssemblyTable tile) {
        super(manager);
        this.tile = tile;
        this.title = "gui.power";
        this.appendText(LocaleUtil.localize("gui.assemblyCurrentRequired") + ":", -5591112).setDropShadow(true);
        this.appendText(() -> LocaleUtil.localizeMj(tile.getTarget()), -16777216);
        this.appendText(LocaleUtil.localize("gui.stored") + ":", -5591112).setDropShadow(true);
        this.appendText(() -> LocaleUtil.localizeMj(tile.power), -16777216);
        this.appendText(LocaleUtil.localize("gui.assemblyRate") + ":", -5591112).setDropShadow(true);
        this.appendText(() -> LocaleUtil.localizeMjFlow(tile.avgPowerClient), -16777216);
        this.calculateMaxSize();
    }

    @Override
    public int getColour() {
        return -2855905;
    }

    @Override
    protected void drawIcon(int x, int y) {
        SpriteHolderRegistry.SpriteHolder sprite = this.tile.avgPowerClient > 0L ? BCLibSprites.ENGINE_ACTIVE : BCLibSprites.ENGINE_INACTIVE;
        GuiIcon.draw(sprite, x, y, x + 16, y + 16);
    }
}

