/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gui;

import buildcraft.api.core.EnumPipePart;
import buildcraft.lib.client.sprite.ISprite;
import buildcraft.lib.client.sprite.RawSprite;
import buildcraft.lib.client.sprite.SpriteNineSliced;
import buildcraft.lib.gui.GuiBC8;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.ITooltipElement;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.transport.container.ContainerGate;
import buildcraft.transport.gate.ActionWrapper;
import buildcraft.transport.gate.GateLogic;
import buildcraft.transport.gate.GateVariant;
import buildcraft.transport.gate.StatementWrapper;
import buildcraft.transport.gate.TriggerWrapper;
import buildcraft.transport.gui.ElementAction;
import buildcraft.transport.gui.ElementGuiSlot;
import buildcraft.transport.gui.ElementStatement;
import buildcraft.transport.gui.ElementStatementParam;
import buildcraft.transport.gui.ElementTrigger;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class GuiGate
extends GuiBC8<ContainerGate>
implements ITooltipElement {
    public static final ResourceLocation TEXTURE_GATE = new ResourceLocation("buildcrafttransport:textures/gui/gate_interface.png");
    public static final int GUI_WIDTH = 176;
    public static final int GUI_HEIGHT_NORM = 117;
    public static final GuiIcon ICON_BACK_TOP = new GuiIcon(TEXTURE_GATE, 0, 0, 176, 16);
    public static final GuiIcon ICON_BACK_MID = new GuiIcon(TEXTURE_GATE, 0, 23, 176, 18);
    public static final GuiIcon ICON_BACK_BOTTOM = new GuiIcon(TEXTURE_GATE, 0, 48, 176, 101);
    public static final GuiIcon ICON_SLOT_BLOCKED = new GuiIcon(TEXTURE_GATE, 176, 0, 18, 18);
    public static final GuiIcon ICON_SLOT_NOT_SET = ICON_SLOT_BLOCKED.offset(18, 0);
    public static final GuiIcon CONNECT_HORIZ_OFF = new GuiIcon(TEXTURE_GATE, 176, 18, 18, 18);
    public static final GuiIcon CONNECT_HORIZ_ON_TRIGGER = new GuiIcon(TEXTURE_GATE, 194, 18, 7, 18);
    public static final GuiIcon CONNECT_HORIZ_ON_ACTION = new GuiIcon(TEXTURE_GATE, 201, 18, 11, 18);
    public static final GuiIcon CONNECT_HORIZ_ON_FULL = CONNECT_HORIZ_OFF.offset(18, 0);
    public static final GuiIcon CONNECT_VERT_TOP_OFF = new GuiIcon(TEXTURE_GATE, 176, 36, 18, 9);
    public static final GuiIcon CONNECT_VERT_TOP_ON = CONNECT_VERT_TOP_OFF.offset(18, 0);
    public static final GuiIcon CONNECT_VERT_BOTTOM_OFF = CONNECT_VERT_TOP_OFF.offset(0, 9);
    public static final GuiIcon CONNECT_VERT_BOTTOM_ON = CONNECT_VERT_TOP_ON.offset(0, 9);
    public static final GuiIcon CONNECT_VERT_OFF = new GuiIcon(TEXTURE_GATE, 176, 54, 18, 18);
    public static final GuiIcon CONNECT_VERT_ON = CONNECT_VERT_OFF.offset(18, 0);
    public static final RawSprite ICON_SELECT_HOVER = new RawSprite(TEXTURE_GATE, 212, 0, 16, 16, 256.0f);
    public static final SpriteNineSliced SELECTION_HOVER = new SpriteNineSliced((ISprite)ICON_SELECT_HOVER, 3, 3, 13, 13, 16);
    public static final GuiIcon SLOT_COLOUR = new GuiIcon(TEXTURE_GATE, 176, 72, 18, 18);
    public ElementGuiSlot<?> currentHover = null;
    private final IGuiArea[] positionSlotPair;
    private final IGuiArea[] positionConnect;
    public boolean isDraggingStatement;
    public TriggerWrapper draggingTrigger;
    public ActionWrapper draggingAction;

    public GuiGate(ContainerGate container) {
        super(container);
        this.field_146999_f = 176;
        this.field_147000_g = 117 + 18 * container.slotHeight;
        boolean split = container.gate.isSplitInTwo();
        GateVariant variant = container.gate.variant;
        int triggerWidth = 18 * (variant.numTriggerArgs + 1);
        int columnWidth = 36 + triggerWidth + 18 * variant.numActionArgs;
        int columnStartFirst = split ? 79 - columnWidth : (176 - columnWidth) / 2;
        int columnStartSecond = columnStartFirst + columnWidth + 18;
        int numSlots = variant.numSlots;
        this.positionSlotPair = new IGuiArea[numSlots];
        this.positionConnect = new IGuiArea[numSlots];
        for (int i = 0; i < numSlots; ++i) {
            boolean nextOtherColumn;
            boolean otherColumn = split && i >= container.slotHeight;
            int x = otherColumn ? columnStartSecond : columnStartFirst;
            int y = (otherColumn ? i - container.slotHeight : i) * 18 + 16;
            this.positionSlotPair[i] = new GuiRectangle(x, y, columnWidth, 18).offset(this.rootElement);
            boolean bl = nextOtherColumn = split && i + 1 >= container.slotHeight;
            if (otherColumn != nextOtherColumn || i >= numSlots - 1) continue;
            this.positionConnect[i] = new GuiRectangle(x + triggerWidth, y + 9, 18, 18).offset(this.rootElement);
        }
        MessageUtil.doDelayed(() -> {
            container.sendMessage(ContainerGate.ID_VALID_STATEMENTS);
            container.sendMessage(ContainerGate.ID_CURRENT_SET);
        });
    }

    @Override
    protected boolean shouldAddHelpLedger() {
        return false;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        GateVariant variant = ((ContainerGate)this.container).gate.variant;
        int numSlots = variant.numSlots;
        for (int i = 0; i < numSlots; ++i) {
            IGuiArea pos;
            int p;
            IGuiArea actionPos = this.positionSlotPair[i].offset(18 * (2 + variant.numTriggerArgs), 0);
            ElementTrigger trigger = new ElementTrigger(this, this.positionSlotPair[i].resize(18, 18), ((ContainerGate)this.container).pairs[i].trigger);
            ElementAction action = new ElementAction(this, actionPos.resize(18, 18), ((ContainerGate)this.container).pairs[i].action);
            this.guiElements.add(trigger);
            this.guiElements.add(action);
            for (p = 0; p < variant.numTriggerArgs; ++p) {
                pos = this.positionSlotPair[i].offset(18 * (p + 1), 0).resize(18, 18);
                this.guiElements.add(new ElementStatementParam(this, pos, ((ContainerGate)this.container).pairs[i].triggerParams[p], p, trigger));
            }
            for (p = 0; p < variant.numActionArgs; ++p) {
                pos = actionPos.offset(18 * (p + 1), 0).resize(18, 18);
                this.guiElements.add(new ElementStatementParam(this, pos, ((ContainerGate)this.container).pairs[i].actionParams[p], p, action));
            }
        }
    }

    @Override
    protected void drawBackgroundLayer(float partialTicks) {
        ICON_BACK_TOP.drawAt(this.rootElement);
        int y = 16;
        for (int i = 0; i < ((ContainerGate)this.container).slotHeight; ++i) {
            ICON_BACK_MID.drawAt(this.rootElement.offset(0, y));
            y += 18;
        }
        ICON_BACK_BOTTOM.drawAt(this.rootElement.offset(0, y));
        GateLogic gate = ((ContainerGate)this.container).gate;
        int triggerArgs = gate.variant.numTriggerArgs;
        for (int i = 0; i < this.positionSlotPair.length; ++i) {
            GuiIcon icon;
            int xOff = 18 * (triggerArgs + 1);
            IGuiArea elemSlots = this.positionSlotPair[i];
            IGuiArea offsetConnect = elemSlots.offset(xOff, 0);
            boolean triggerOn = gate.triggerOn[i];
            boolean actionOn = gate.actionOn[i];
            if (triggerOn) {
                if (actionOn) {
                    CONNECT_HORIZ_ON_FULL.drawAt(offsetConnect);
                } else {
                    CONNECT_HORIZ_OFF.drawAt(offsetConnect);
                    CONNECT_HORIZ_ON_TRIGGER.drawAt(offsetConnect);
                }
            } else if (actionOn) {
                CONNECT_HORIZ_OFF.drawAt(offsetConnect);
                CONNECT_HORIZ_ON_ACTION.drawAt(offsetConnect.getX() + 7, offsetConnect.getY());
            } else {
                CONNECT_HORIZ_OFF.drawAt(offsetConnect);
            }
            IGuiArea elemConnect = this.positionConnect[i];
            if (elemConnect == null) continue;
            boolean twoConnected = gate.connections[i];
            boolean bottomOn = gate.actionOn[i + 1];
            if (twoConnected) {
                icon = actionOn ? CONNECT_VERT_ON : CONNECT_VERT_OFF;
                icon.drawAt(elemConnect);
                continue;
            }
            icon = actionOn ? CONNECT_VERT_TOP_ON : CONNECT_VERT_TOP_OFF;
            icon.drawAt(elemConnect);
            icon = bottomOn ? CONNECT_VERT_BOTTOM_ON : CONNECT_VERT_BOTTOM_OFF;
            icon.drawAt(elemConnect.offset(0, 9));
        }
        this.iteratePossible((wrapper, pos) -> {
            ElementStatement.draw(this, wrapper, (IGuiPosition)pos);
            if (this.currentHover != null) {
                this.func_73733_a(pos.getX(), pos.getY(), pos.getX() + 18, pos.getY() + 18, 0x55000000, 0x55000000);
            }
        });
    }

    @Override
    protected void drawForegroundLayer() {
        int x = this.rootElement.getX();
        int y = this.rootElement.getY();
        String localizedName = ((ContainerGate)this.container).gate.variant.getLocalizedName();
        int cX = x + (176 - this.field_146289_q.func_78256_a(localizedName)) / 2;
        this.field_146289_q.func_78276_b(localizedName, cX, y + 5, 0x404040);
        this.field_146289_q.func_78276_b(LocaleUtil.localize("gui.inventory"), x + 8, y + this.field_147000_g - 97, 0x404040);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.currentHover != null) {
            GlStateManager.func_179097_i();
            this.func_73733_a(this.rootElement.getX(), this.rootElement.getY(), this.rootElement.getX() + 176, this.rootElement.getY() + this.field_147000_g, 0x55000000, 0x55000000);
            GlStateManager.func_179126_j();
        }
        if (this.isDraggingStatement) {
            StatementWrapper wrapper = this.draggingTrigger == null ? this.draggingAction : this.draggingTrigger;
            ElementStatement.draw(this, wrapper, this.mouse.offset(-9, -9));
        }
    }

    @Override
    public void addToolTips(List<ToolTip> tooltips) {
        if (this.currentHover != null) {
            return;
        }
        this.iteratePossible((wrapper, pos) -> {
            if (pos.contains(this.mouse) && wrapper != null) {
                String[] arr = new String[]{wrapper.getDescription()};
                EnumFacing face = wrapper.sourcePart.face;
                if (face != null) {
                    String translated = ColourUtil.getTextFullTooltip(face);
                    translated = LocaleUtil.localize("gate.side", translated);
                    arr = new String[]{arr[0], translated};
                }
                tooltips.add(new ToolTip(arr));
            }
        });
    }

    private void iteratePossible(OnStatement onStatement) {
        int tx = 0;
        int ty = 0;
        EnumPipePart last = null;
        onStatement.iterate(null, this.rootElement.offset(-18, 8).resize(18, 18));
        for (TriggerWrapper triggerWrapper : ((ContainerGate)this.container).possibleTriggers) {
            if (++tx > 3 || last != null && last != triggerWrapper.sourcePart) {
                tx = 0;
                ++ty;
            }
            onStatement.iterate(triggerWrapper, this.rootElement.offset(18 * (-1 - tx), ty * 18 + 8).resize(18, 18));
            last = triggerWrapper.sourcePart;
        }
        tx = 0;
        ty = 0;
        last = null;
        onStatement.iterate(null, this.rootElement.offset(176, 8).resize(18, 18));
        for (ActionWrapper actionWrapper : ((ContainerGate)this.container).possibleActions) {
            if (++tx > 3 || last != null && last != actionWrapper.sourcePart) {
                tx = 0;
                ++ty;
            }
            onStatement.iterate(actionWrapper, this.rootElement.offset(176 + 18 * tx, ty * 18 + 8).resize(18, 18));
            last = actionWrapper.sourcePart;
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (int i = 0; i < this.positionConnect.length; ++i) {
            IGuiArea pos2 = this.positionConnect[i];
            if (pos2 == null || !pos2.contains(this.mouse)) continue;
            ((ContainerGate)this.container).setConnected(i, !((ContainerGate)this.container).gate.connections[i]);
            return;
        }
        this.iteratePossible((wrapper, pos) -> {
            if (pos.contains(this.mouse)) {
                this.isDraggingStatement = true;
                if (wrapper instanceof TriggerWrapper) {
                    this.draggingTrigger = (TriggerWrapper)wrapper;
                } else if (wrapper instanceof ActionWrapper) {
                    this.draggingAction = (ActionWrapper)wrapper;
                }
            }
        });
    }

    @Override
    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (this.isDraggingStatement) {
            for (IGuiElement elem : this.guiElements) {
                ElementStatement element;
                if (!(elem instanceof ElementStatement) || !(element = (ElementStatement)elem).contains(this.mouse)) continue;
                if (element instanceof ElementTrigger && this.draggingAction == null) {
                    ((ElementTrigger)element).reference.set(this.draggingTrigger);
                    break;
                }
                if (!(element instanceof ElementAction) || this.draggingTrigger != null) break;
                ((ElementAction)element).reference.set(this.draggingAction);
                break;
            }
            this.isDraggingStatement = false;
            this.draggingTrigger = null;
            this.draggingAction = null;
        }
    }

    private static interface OnStatement {
        public void iterate(StatementWrapper var1, IGuiArea var2);
    }
}

